/*
 * Decompiled with CFR 0.152.
 */
package net.fornwall.jelf;

import com.github.unidbg.Emulator;
import com.github.unidbg.Module;
import com.github.unidbg.pointer.UnidbgPointer;
import com.github.unidbg.unwind.Frame;
import com.github.unidbg.unwind.Unwinder;
import com.github.unidbg.utils.Inspector;
import java.io.ByteArrayOutputStream;
import java.util.Arrays;
import java.util.Stack;
import net.fornwall.jelf.DwarfCursor;
import net.fornwall.jelf.ElfBuffer;
import net.fornwall.jelf.ElfDataIn;
import net.fornwall.jelf.ElfParser;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class GnuEhFrameHeader {
    private static final Log log = LogFactory.getLog(GnuEhFrameHeader.class);
    private static final int VERSION = 1;
    private static final int DW_EH_PE_omit = 255;
    private static final int DW_EH_PE_absptr = 0;
    private static final int DW_EH_PE_uleb128 = 1;
    private static final int DW_EH_PE_udata2 = 2;
    private static final int DW_EH_PE_udata4 = 3;
    private static final int DW_EH_PE_udata8 = 4;
    private static final int DW_EH_PE_sleb128 = 9;
    private static final int DW_EH_PE_sdata2 = 10;
    private static final int DW_EH_PE_sdata4 = 11;
    private static final int DW_EH_PE_sdata8 = 12;
    private static final int DW_EH_PE_udata1 = 13;
    private static final int DW_EH_PE_block = 15;
    private static final int DW_EH_PE_pcrel = 16;
    private static final int DW_EH_PE_textrel = 32;
    private static final int DW_EH_PE_datarel = 48;
    private static final int DW_EH_PE_funcrel = 64;
    private static final int DW_EH_PE_aligned = 80;
    private static final int DW_EH_PE_indirect = 128;
    private final TableEntry[] entries;
    private final ElfParser parser;
    private static final int DWARF_REG_NUM = 256;
    private static final dwarf_cfa_t[] dwarf_cfa_table = new dwarf_cfa_t[]{new dwarf_cfa_t(255, 255), new dwarf_cfa_t(0, 255), new dwarf_cfa_t(13, 255), new dwarf_cfa_t(2, 255), new dwarf_cfa_t(3, 255), new dwarf_cfa_t(1, 1), new dwarf_cfa_t(1, 255), new dwarf_cfa_t(1, 255), new dwarf_cfa_t(1, 255), new dwarf_cfa_t(1, 1), new dwarf_cfa_t(255, 255), new dwarf_cfa_t(255, 255), new dwarf_cfa_t(1, 1), new dwarf_cfa_t(1, 255), new dwarf_cfa_t(1, 255), new dwarf_cfa_t(15, 255), new dwarf_cfa_t(1, 15), new dwarf_cfa_t(1, 9), new dwarf_cfa_t(1, 9), new dwarf_cfa_t(9, 255), new dwarf_cfa_t(1, 1), new dwarf_cfa_t(1, 9), new dwarf_cfa_t(1, 15), null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, new dwarf_cfa_t(1, 255), new dwarf_cfa_t(1, 1), null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null};
    private static final int DW_LOC_INVALID = 0;
    private static final int DW_LOC_UNDEFINED = 1;
    private static final int DW_LOC_OFFSET = 2;
    private static final int DW_LOC_VAL_OFFSET = 3;
    private static final int DW_LOC_REGISTER = 4;
    private static final int DW_LOC_EXPRESSION = 5;
    private static final int DW_LOC_VAL_EXPRESSION = 6;

    private TableEntry search(long fun) {
        TableEntry tableEntry = null;
        for (TableEntry entry : this.entries) {
            if (fun < entry.location) break;
            tableEntry = entry;
        }
        return tableEntry;
    }

    GnuEhFrameHeader(ElfParser parser, long offset, int size) {
        this.parser = parser;
        parser.seek(offset);
        Off off = new Off(offset);
        short version = parser.readUnsignedByte();
        ++off.pos;
        if (version != 1) {
            throw new IllegalStateException("version is: " + version);
        }
        short eh_frame_ptr_enc = parser.readUnsignedByte();
        ++off.pos;
        short fde_count_enc = parser.readUnsignedByte();
        ++off.pos;
        short table_enc = parser.readUnsignedByte();
        ++off.pos;
        long eh_frame_ptr = GnuEhFrameHeader.readEncodedPointer(parser, eh_frame_ptr_enc, off, true);
        long fde_count = GnuEhFrameHeader.readEncodedPointer(parser, fde_count_enc, off, true);
        this.entries = new TableEntry[(int)fde_count];
        int i = 0;
        while ((long)i < fde_count) {
            long location = GnuEhFrameHeader.readEncodedPointer(parser, table_enc, off, true);
            long address = GnuEhFrameHeader.readEncodedPointer(parser, table_enc, off, true);
            this.entries[i] = new TableEntry(location, address);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Table entry: eh_frame_ptr=0x" + Long.toHexString(eh_frame_ptr) + ", location=0x" + Long.toHexString(location) + ", address=0x" + Long.toHexString(address) + ", size=" + size));
            }
            ++i;
        }
        if (off.pos - off.init != (long)size) {
            throw new IllegalStateException("size=" + size + ", pos=" + off.pos);
        }
    }

    private static long readULEB128(ElfDataIn dataIn, Off off) {
        short b;
        long result = 0L;
        int shift = 0;
        do {
            b = dataIn.readUnsignedByte();
            ++off.pos;
            result |= (long)(b & 0x7F) << shift;
            shift += 7;
        } while ((b & 0x80) != 0);
        return result;
    }

    private static long readSLEB128(ElfDataIn dataIn, Off off) {
        short b;
        long result = 0L;
        int shift = 0;
        do {
            b = dataIn.readUnsignedByte();
            ++off.pos;
            result |= (long)(b & 0x7F) << shift;
            shift += 7;
        } while ((b & 0x80) != 0);
        if ((b & 0x40) != 0) {
            result |= -(1L << shift);
        }
        return result;
    }

    private static long readEncodedPointer(ElfDataIn dataIn, int encoding, Off off, boolean checkIndirect) {
        long result;
        if (encoding == 255) {
            return 0L;
        }
        long last_pos = off.pos++;
        switch (encoding & 0xF) {
            case 1: {
                result = GnuEhFrameHeader.readULEB128(dataIn, off);
                break;
            }
            case 13: {
                result = dataIn.readUnsignedByte();
                break;
            }
            case 2: {
                result = (long)dataIn.readShort() & 0xFFFFL;
                off.pos += 2L;
                break;
            }
            case 3: {
                result = (long)dataIn.readInt() & 0xFFFFFFFFL;
                off.pos += 4L;
                break;
            }
            case 10: {
                result = dataIn.readShort();
                off.pos += 2L;
                break;
            }
            case 11: {
                result = dataIn.readInt();
                off.pos += 4L;
                break;
            }
            case 4: 
            case 12: {
                result = dataIn.readLong();
                off.pos += 8L;
                break;
            }
            default: {
                throw new IllegalStateException("not supported: encoding=0x" + Integer.toHexString(encoding));
            }
        }
        switch (encoding & 0x70) {
            case 0: {
                break;
            }
            case 16: {
                result += last_pos;
                break;
            }
            case 48: {
                result += off.init;
                break;
            }
            default: {
                throw new IllegalStateException("not supported: encoding=0x" + Integer.toHexString(encoding));
            }
        }
        if ((encoding & 0x80) != 0 && checkIndirect) {
            throw new IllegalStateException("DW_EH_PE_indirect: encoding=0x" + Integer.toHexString(encoding));
        }
        return result;
    }

    public Frame dwarf_step(Emulator<?> emulator, Unwinder unwinder, Module module, long fun, DwarfCursor context) {
        dwarf_loc_t loc;
        TableEntry entry = this.search(fun);
        if (entry == null) {
            return null;
        }
        FDE fde = this.dwarf_get_fde(entry.address, fun);
        if (log.isDebugEnabled()) {
            log.debug((Object)("dwarf_step entry=" + entry + ", fun=0x" + Long.toHexString(fun) + ", fde=" + fde + ", module=" + module));
        }
        dwarf_loc_t dwarf_loc_t2 = loc = fde == null ? null : GnuEhFrameHeader.dwarf_get_loc(fde, fun);
        if (loc != null) {
            UnidbgPointer vsp;
            switch (loc.cfa_rule.type) {
                case 4: {
                    vsp = UnidbgPointer.pointer(emulator, (long)(context.loc[(int)loc.cfa_rule.values[0]] + loc.cfa_rule.values[1]));
                    assert (vsp != null);
                    context.loc[emulator.is32Bit() ? 13 : 31] = vsp.peer;
                    if (!log.isDebugEnabled()) break;
                    log.debug((Object)("dwarf_step cfa = " + (emulator.is32Bit() ? "r" : "x") + loc.cfa_rule.values[0] + " + " + loc.cfa_rule.values[1] + " => 0x" + Long.toHexString(vsp.peer)));
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("dwarf_step type=" + loc.cfa_rule.type);
                }
            }
            block6: for (int i = 0; i < loc.reg_rules.length; ++i) {
                dwarf_loc_rule_t rule = loc.reg_rules[i];
                if (rule == null) continue;
                switch (rule.type) {
                    case 2: {
                        UnidbgPointer value = vsp.getPointer(rule.values[0]);
                        context.loc[i] = value == null ? 0L : value.peer;
                        if (!log.isDebugEnabled()) continue block6;
                        log.debug((Object)("dwarf_step " + (emulator.is32Bit() ? "r" : "x") + i + " + (" + rule.values[0] + ") => 0x" + Long.toHexString(context.loc[i])));
                        continue block6;
                    }
                    default: {
                        throw new UnsupportedOperationException("dwarf_step type=" + rule.type);
                    }
                }
            }
            long ip = context.loc[fde.cie.return_address_register];
            if (log.isDebugEnabled()) {
                log.debug((Object)("dwarf_step cfa=0x" + Long.toHexString(vsp.peer) + ", ip=0x" + Long.toHexString(ip)));
            }
            context.ip = ip;
            context.cfa = vsp.peer;
            Frame frame = unwinder.createFrame(UnidbgPointer.pointer(emulator, (long)ip), UnidbgPointer.pointer(emulator, (long)context.cfa));
            if (frame != null) {
                context.ip = frame.ip.peer;
            }
            return frame;
        }
        return null;
    }

    private static dwarf_loc_t dwarf_get_loc(FDE fde, long pc) {
        dwarf_loc_t loc_init;
        long cur_pc = fde.pc_start;
        long[] operands = new long[2];
        dwarf_loc_t loc = loc_init = new dwarf_loc_t();
        Stack<dwarf_loc_t> loc_node_stack = new Stack<dwarf_loc_t>();
        byte[] instructions = fde.merge();
        boolean stepped = false;
        block21: for (int i = 0; i < instructions.length; ++i) {
            dwarf_loc_t loc_pc;
            if (cur_pc > pc) {
                stepped = true;
                break;
            }
            if (i == fde.cie.cfa_instructions.length) {
                loc = loc_pc = new dwarf_loc_t(loc_init);
                stepped = true;
            }
            int op = instructions[i] & 0xFF;
            int cfa_op = op >> 6;
            int cfa_op_ext = op & 0x3F;
            if (log.isDebugEnabled()) {
                log.debug((Object)("dwarf_get_loc i=" + i + ", op=0x" + Integer.toHexString(op) + ", cfa_op=" + cfa_op + ", cfa_op_ext=0x" + Integer.toHexString(cfa_op_ext) + ", cur_pc=0x" + Long.toHexString(cur_pc)));
            }
            switch (cfa_op) {
                case 1: {
                    long step = (long)cfa_op_ext * fde.cie.code_alignment_factor;
                    cur_pc += step;
                    if (!log.isDebugEnabled()) continue block21;
                    log.debug((Object)("DW_CFA_advance_loc: " + step + " to " + Long.toHexString(cur_pc)));
                    continue block21;
                }
                case 2: {
                    Off off = new Off(0L);
                    ElfBuffer dataIn = new ElfBuffer(Arrays.copyOfRange(instructions, i + 1, instructions.length));
                    long v64 = GnuEhFrameHeader.readULEB128(dataIn, off);
                    dwarf_loc_rule_t rule = loc.get_reg_rule(cfa_op_ext);
                    rule.type = 2;
                    rule.values[0] = v64 * fde.cie.data_alignment_factor;
                    i = (int)((long)i + off.pos);
                    if (!log.isDebugEnabled()) continue block21;
                    log.debug((Object)("DW_CFA_offset: r" + cfa_op_ext + " at cfa" + rule.values[0]));
                    continue block21;
                }
                case 3: {
                    loc.reg_rules[cfa_op_ext] = loc_init.reg_rules[cfa_op_ext];
                    if (!log.isDebugEnabled()) continue block21;
                    log.debug((Object)("DW_CFA_restore: r" + cfa_op_ext));
                    continue block21;
                }
                default: {
                    int type;
                    long step;
                    dwarf_cfa_t cfa = dwarf_cfa_table[cfa_op_ext];
                    if (cfa == null) {
                        throw new IllegalStateException("dwarf_get_loc illegal cfa");
                    }
                    for (int m = 0; m < 2 && (type = cfa.operand_types[m]) != 255; ++m) {
                        long v64;
                        if (type == 15) {
                            throw new IllegalStateException("dwarf_get_loc DW_EH_PE_block");
                        }
                        Off off = new Off(0L);
                        ElfBuffer dataIn = new ElfBuffer(Arrays.copyOfRange(instructions, i + 1, instructions.length));
                        operands[m] = v64 = GnuEhFrameHeader.readEncodedPointer(dataIn, type, off, true);
                        i = (int)((long)i + off.pos);
                    }
                    switch (cfa_op_ext) {
                        case 0: {
                            if (!log.isDebugEnabled()) continue block21;
                            log.debug((Object)"DW_CFA_nop");
                            continue block21;
                        }
                        case 1: {
                            cur_pc = operands[0];
                            continue block21;
                        }
                        case 2: {
                            step = operands[0] * fde.cie.code_alignment_factor;
                            cur_pc += step;
                            if (!log.isDebugEnabled()) continue block21;
                            log.debug((Object)("DW_CFA_advance_loc1: " + step + " to " + Long.toHexString(cur_pc)));
                            continue block21;
                        }
                        case 3: 
                        case 4: {
                            cur_pc += operands[0] * fde.cie.code_alignment_factor;
                            continue block21;
                        }
                        case 5: {
                            dwarf_loc_rule_t rule = loc.get_reg_rule(operands[0]);
                            rule.type = 2;
                            rule.values[0] = operands[1];
                            continue block21;
                        }
                        case 6: {
                            loc.reg_rules[(int)operands[0]] = loc_init.reg_rules[(int)operands[0]];
                            continue block21;
                        }
                        case 7: {
                            dwarf_loc_rule_t rule = loc.get_reg_rule(operands[0]);
                            rule.type = 1;
                            continue block21;
                        }
                        case 8: {
                            dwarf_loc_rule_t rule = loc.get_reg_rule(operands[0]);
                            rule.type = 0;
                            continue block21;
                        }
                        case 9: {
                            dwarf_loc_rule_t rule = loc.get_reg_rule(operands[0]);
                            rule.type = 4;
                            rule.values[0] = operands[1];
                            continue block21;
                        }
                        case 10: {
                            dwarf_loc_t loc_node = new dwarf_loc_t(loc);
                            loc_node_stack.push(loc_node);
                            continue block21;
                        }
                        case 11: {
                            dwarf_loc_t loc_node = (dwarf_loc_t)loc_node_stack.pop();
                            loc = loc_pc = new dwarf_loc_t(loc_node);
                            continue block21;
                        }
                        case 12: {
                            loc.cfa_rule.type = 4;
                            loc.cfa_rule.values[0] = operands[0];
                            loc.cfa_rule.values[1] = operands[1];
                            if (!log.isDebugEnabled()) continue block21;
                            log.debug((Object)("DW_CFA_def_cfa: r" + operands[0] + " ofs " + operands[1]));
                            continue block21;
                        }
                        case 13: {
                            if (loc.cfa_rule.type != 4) {
                                throw new IllegalStateException("NOT DW_LOC_REGISTER");
                            }
                            loc.cfa_rule.values[0] = operands[0];
                            continue block21;
                        }
                        case 14: {
                            if (loc.cfa_rule.type != 4) {
                                throw new IllegalStateException("NOT DW_LOC_REGISTER");
                            }
                            loc.cfa_rule.values[1] = operands[0];
                            if (!log.isDebugEnabled()) continue block21;
                            log.debug((Object)("DW_CFA_def_cfa_offset: " + operands[0]));
                            continue block21;
                        }
                        default: {
                            throw new IllegalStateException("dwarf_get_loc cfa_op=" + cfa_op + ", i=" + i + ", cfa_op_ext=0x" + Integer.toHexString(cfa_op_ext));
                        }
                    }
                }
            }
        }
        return stepped ? loc : loc_init;
    }

    private FDE dwarf_get_fde(long fde_offset, long fun) {
        Off off = new Off(fde_offset);
        this.parser.seek(fde_offset);
        int length = this.parser.readInt();
        off.pos += 4L;
        if (length == -1) {
            throw new UnsupportedOperationException("64bits DWARF FDE");
        }
        long cur_field_offset = off.pos;
        int cie_pointer = this.parser.readInt();
        off.pos += 4L;
        if (cie_pointer == 0) {
            throw new IllegalStateException("Invalid cie_pointer");
        }
        long cie_offset = cur_field_offset - (long)cie_pointer;
        CIE cie = this.dwarf_get_cie(cie_offset);
        this.parser.seek(off.pos);
        long pc_start = GnuEhFrameHeader.readEncodedPointer(this.parser, cie.fde_address_encoding, off, true);
        long adjust = off.pos;
        long pc_range = GnuEhFrameHeader.readEncodedPointer(this.parser, cie.fde_address_encoding, off, true) - adjust;
        long pc_end = pc_start + pc_range;
        if (fun >= pc_end) {
            return null;
        }
        if (cie.augmentation_string.charAt(0) == 'z') {
            long v64 = GnuEhFrameHeader.readULEB128(this.parser, off);
            for (long i = 0L; i < v64; ++i) {
                this.parser.readUnsignedByte();
                ++off.pos;
            }
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        for (long i = off.pos - fde_offset - 4L; i < (long)length; ++i) {
            baos.write(this.parser.readUnsignedByte());
        }
        byte[] cfa_instructions = baos.toByteArray();
        if (log.isDebugEnabled()) {
            log.debug((Object)Inspector.inspectString((byte[])cfa_instructions, (String)("dwarf_get_fde length=0x" + Integer.toHexString(length) + ", cie_offset=0x" + Long.toHexString(cie_offset) + ", pc_start=0x" + Long.toHexString(pc_start) + ", pc_end=0x" + Long.toHexString(pc_end))));
        }
        return new FDE(cie, pc_start, pc_end, cfa_instructions);
    }

    private CIE dwarf_get_cie(long cie_offset) {
        long cfa_instructions_offset;
        this.parser.seek(cie_offset);
        Off off = new Off(cie_offset);
        int length = this.parser.readInt();
        off.pos += 4L;
        if (length == -1) {
            throw new UnsupportedOperationException("64bits DWARF CIE");
        }
        int fde_address_encoding = 11;
        int cie_id = this.parser.readInt();
        off.pos += 4L;
        if (cie_id != 0) {
            throw new IllegalStateException("Invalid CIE");
        }
        short cie_version = this.parser.readUnsignedByte();
        ++off.pos;
        if (cie_version != 1) {
            throw new IllegalStateException("Invalid CIE version: " + cie_version);
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream(8);
        for (int i = 0; i < 8; ++i) {
            short b = this.parser.readUnsignedByte();
            ++off.pos;
            if (b == 0) break;
            baos.write(b);
        }
        if (baos.size() == 0) {
            throw new IllegalStateException("Invalid CIE augmentation string");
        }
        String augmentation_string = baos.toString();
        long code_alignment_factor = GnuEhFrameHeader.readULEB128(this.parser, off);
        long data_alignment_factor = GnuEhFrameHeader.readSLEB128(this.parser, off);
        short return_address_register = this.parser.readUnsignedByte();
        ++off.pos;
        if ('z' != augmentation_string.charAt(0)) {
            cfa_instructions_offset = off.pos;
        } else {
            long v64 = GnuEhFrameHeader.readULEB128(this.parser, off);
            cfa_instructions_offset = off.pos + v64;
            char[] as = augmentation_string.toCharArray();
            block6: for (int i = 1; i < as.length; ++i) {
                switch (as[i]) {
                    case 'R': {
                        fde_address_encoding = this.parser.readUnsignedByte();
                        ++off.pos;
                        continue block6;
                    }
                    case 'L': {
                        this.parser.readUnsignedByte();
                        ++off.pos;
                        continue block6;
                    }
                    case 'P': {
                        short encoding = this.parser.readUnsignedByte();
                        ++off.pos;
                        GnuEhFrameHeader.readEncodedPointer(this.parser, encoding, off, false);
                        continue block6;
                    }
                    default: {
                        throw new UnsupportedOperationException("augmentation_string=" + augmentation_string);
                    }
                }
            }
        }
        baos.reset();
        for (long i = cfa_instructions_offset - cie_offset - 4L; i < (long)length; ++i) {
            baos.write(this.parser.readUnsignedByte());
        }
        byte[] cfa_instructions = baos.toByteArray();
        if (log.isDebugEnabled()) {
            log.debug((Object)Inspector.inspectString((byte[])cfa_instructions, (String)("dwarf_get_cie length=0x" + Integer.toHexString(length) + ", augmentation_string=" + augmentation_string + ", code_alignment_factor=" + code_alignment_factor + ", data_alignment_factor=" + data_alignment_factor + ", return_address_register=" + return_address_register + ", fde_address_encoding=0x" + Integer.toHexString(fde_address_encoding) + ", cfa_instructions_offset=0x" + Long.toHexString(cfa_instructions_offset))));
        }
        return new CIE(fde_address_encoding, augmentation_string, code_alignment_factor, data_alignment_factor, return_address_register, cfa_instructions);
    }

    private static class CIE {
        final int fde_address_encoding;
        final String augmentation_string;
        final long code_alignment_factor;
        final long data_alignment_factor;
        final int return_address_register;
        final byte[] cfa_instructions;

        CIE(int fde_address_encoding, String augmentation_string, long code_alignment_factor, long data_alignment_factor, int return_address_register, byte[] cfa_instructions) {
            this.fde_address_encoding = fde_address_encoding;
            this.augmentation_string = augmentation_string;
            this.code_alignment_factor = code_alignment_factor;
            this.data_alignment_factor = data_alignment_factor;
            this.return_address_register = return_address_register;
            this.cfa_instructions = cfa_instructions;
        }
    }

    private static class FDE {
        final CIE cie;
        final long pc_start;
        final long pc_end;
        final byte[] cfa_instructions;

        FDE(CIE cie, long pc_start, long pc_end, byte[] cfa_instructions) {
            this.cie = cie;
            this.pc_start = pc_start;
            this.pc_end = pc_end;
            this.cfa_instructions = cfa_instructions;
        }

        final byte[] merge() {
            byte[] instructions = new byte[this.cie.cfa_instructions.length + this.cfa_instructions.length];
            System.arraycopy(this.cie.cfa_instructions, 0, instructions, 0, this.cie.cfa_instructions.length);
            System.arraycopy(this.cfa_instructions, 0, instructions, this.cie.cfa_instructions.length, this.cfa_instructions.length);
            return instructions;
        }
    }

    private static class dwarf_cfa_t {
        final int[] operand_types;

        dwarf_cfa_t(int t1, int t2) {
            this.operand_types = new int[]{t1, t2};
        }
    }

    private static class dwarf_loc_t {
        final dwarf_loc_rule_t cfa_rule;
        final dwarf_loc_rule_t[] reg_rules;

        dwarf_loc_t() {
            this.cfa_rule = new dwarf_loc_rule_t();
            this.reg_rules = new dwarf_loc_rule_t[256];
        }

        dwarf_loc_t(dwarf_loc_t copy) {
            this.cfa_rule = copy.cfa_rule.copy();
            this.reg_rules = new dwarf_loc_rule_t[256];
            for (int i = 0; i < 256; ++i) {
                dwarf_loc_rule_t src = copy.reg_rules[i];
                if (src == null) continue;
                this.reg_rules[i] = src.copy();
            }
        }

        dwarf_loc_rule_t get_reg_rule(long i) {
            dwarf_loc_rule_t rule = this.reg_rules[(int)i];
            if (rule == null) {
                this.reg_rules[(int)i] = rule = new dwarf_loc_rule_t();
            }
            return rule;
        }
    }

    private static class dwarf_loc_rule_t {
        int type;
        final long[] values = new long[2];

        private dwarf_loc_rule_t() {
        }

        final dwarf_loc_rule_t copy() {
            dwarf_loc_rule_t copy = new dwarf_loc_rule_t();
            copy.type = this.type;
            System.arraycopy(this.values, 0, copy.values, 0, this.values.length);
            return copy;
        }
    }

    private static class Off {
        final long init;
        long pos;

        Off(long init) {
            this.init = init;
            this.pos = init;
        }
    }

    private static class TableEntry {
        final long location;
        final long address;

        TableEntry(long location, long address) {
            this.location = location;
            this.address = address;
        }

        public String toString() {
            return "TableEntry{location=0x" + Long.toHexString(this.location) + ", address=0x" + Long.toHexString(this.address) + '}';
        }
    }
}

