/*
 * Decompiled with CFR 0.152.
 */
package com.github.unidbg.linux;

import com.github.unidbg.AbstractEmulator;
import com.github.unidbg.Emulator;
import com.github.unidbg.arm.backend.BackendException;
import com.github.unidbg.arm.context.RegisterContext;
import com.github.unidbg.file.FileResult;
import com.github.unidbg.file.NewFileIO;
import com.github.unidbg.file.linux.AndroidFileIO;
import com.github.unidbg.linux.file.DirectoryFileIO;
import com.github.unidbg.linux.file.EventFD;
import com.github.unidbg.linux.file.PipedReadFileIO;
import com.github.unidbg.linux.file.PipedWriteFileIO;
import com.github.unidbg.linux.signal.SigAction;
import com.github.unidbg.linux.signal.SignalFunction;
import com.github.unidbg.linux.signal.SignalTask;
import com.github.unidbg.linux.struct.StatFS;
import com.github.unidbg.linux.struct.StatFS32;
import com.github.unidbg.linux.struct.StatFS64;
import com.github.unidbg.linux.thread.FutexIndefinitelyWaiter;
import com.github.unidbg.linux.thread.FutexWaiter;
import com.github.unidbg.linux.thread.MarshmallowThread;
import com.github.unidbg.linux.thread.NanoSleepWaiter;
import com.github.unidbg.memory.Memory;
import com.github.unidbg.pointer.UnidbgPointer;
import com.github.unidbg.signal.SigSet;
import com.github.unidbg.signal.UnixSigSet;
import com.github.unidbg.spi.SyscallHandler;
import com.github.unidbg.thread.MainTask;
import com.github.unidbg.thread.RunnableTask;
import com.github.unidbg.thread.Task;
import com.github.unidbg.thread.ThreadContextSwitchException;
import com.github.unidbg.thread.ThreadDispatcher;
import com.github.unidbg.thread.ThreadTask;
import com.github.unidbg.thread.Waiter;
import com.github.unidbg.unix.UnixSyscallHandler;
import com.github.unidbg.unix.struct.TimeSpec;
import com.github.unidbg.utils.Inspector;
import com.sun.jna.Pointer;
import java.io.IOException;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import net.dongliu.apk.parser.utils.Pair;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class AndroidSyscallHandler
extends UnixSyscallHandler<AndroidFileIO>
implements SyscallHandler<AndroidFileIO> {
    private static final Log log = LogFactory.getLog(AndroidSyscallHandler.class);
    static final int MREMAP_MAYMOVE = 1;
    static final int MREMAP_FIXED = 2;
    private byte[] sched_cpu_mask;
    private static final int EFD_SEMAPHORE = 1;
    private static final int EFD_NONBLOCK = 2048;
    private static final int EFD_CLOEXEC = 524288;
    private static final int SCHED_OTHER = 0;
    private static final int ANDROID_PRIORITY_NORMAL = 0;
    private static final int SIG_BLOCK = 0;
    private static final int SIG_UNBLOCK = 1;
    private static final int SIG_SETMASK = 2;
    private static final int FUTEX_CMD_MASK = 127;
    private static final int FUTEX_PRIVATE_FLAG = 128;
    private static final int MUTEX_SHARED_MASK = 8192;
    private static final int MUTEX_TYPE_MASK = 49152;
    private static final int FUTEX_WAIT = 0;
    private static final int FUTEX_WAKE = 1;
    private static final int ETIMEDOUT = 110;
    private static final int SIGKILL = 9;
    private static final int SIGSTOP = 19;
    private static final int SIG_ERR = -1;
    private final Map<Integer, SigAction> sigActionMap = new HashMap<Integer, SigAction>();
    private int threadId;

    final long sched_setaffinity(Emulator<AndroidFileIO> emulator) {
        RegisterContext context = emulator.getContext();
        int pid = context.getIntArg(0);
        int cpusetsize = context.getIntArg(1);
        UnidbgPointer mask = context.getPointerArg(2);
        if (mask != null) {
            this.sched_cpu_mask = mask.getByteArray(0L, cpusetsize);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)Inspector.inspectString((byte[])this.sched_cpu_mask, (String)("sched_setaffinity pid=" + pid + ", cpusetsize=" + cpusetsize + ", mask=" + mask)));
        }
        return 0L;
    }

    final long sched_getaffinity(Emulator<AndroidFileIO> emulator) {
        RegisterContext context = emulator.getContext();
        int pid = context.getIntArg(0);
        int cpusetsize = context.getIntArg(1);
        UnidbgPointer mask = context.getPointerArg(2);
        int ret = 0;
        if (mask != null && this.sched_cpu_mask != null) {
            mask.write(0L, this.sched_cpu_mask, 0, cpusetsize);
            ret = cpusetsize;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)Inspector.inspectString((byte[])this.sched_cpu_mask, (String)("sched_getaffinity pid=" + pid + ", cpusetsize=" + cpusetsize + ", mask=" + mask)));
        }
        return ret;
    }

    final int eventfd2(Emulator<?> emulator) {
        RegisterContext ctx = emulator.getContext();
        int initval = ctx.getIntArg(0);
        int flags = ctx.getIntArg(1);
        if (log.isDebugEnabled()) {
            log.debug((Object)("eventfd2 initval=" + initval + ", flags=0x" + Integer.toHexString(flags)));
        }
        if ((flags & 0x80000) != 0) {
            throw new UnsupportedOperationException("eventfd2 flags=0x" + Integer.toHexString(flags));
        }
        boolean nonblock = (flags & 0x800) != 0;
        boolean semaphore = (flags & 1) != 0;
        EventFD fileIO = new EventFD(initval, semaphore, nonblock);
        int minFd = this.getMinFd();
        this.fdMap.put(minFd, fileIO);
        if (this.verbose) {
            System.out.printf("eventfd(%d) with flags=0x%x fd=%d from %s%n", initval, flags, minFd, emulator.getContext().getLRPointer());
        }
        return minFd;
    }

    protected int sched_setscheduler(Emulator<AndroidFileIO> emulator) {
        RegisterContext context = emulator.getContext();
        int pid = context.getIntArg(0);
        int policy = context.getIntArg(1);
        UnidbgPointer param = context.getPointerArg(2);
        if (log.isDebugEnabled()) {
            log.debug((Object)("sched_setscheduler pid=" + pid + ", policy=" + policy + ", param=" + param));
        }
        return 0;
    }

    protected int sched_getscheduler(Emulator<AndroidFileIO> emulator) {
        RegisterContext context = emulator.getContext();
        int pid = context.getIntArg(0);
        if (log.isDebugEnabled()) {
            log.debug((Object)("sched_getscheduler pid=" + pid));
        }
        return 0;
    }

    protected int sched_getparam(Emulator<AndroidFileIO> emulator) {
        RegisterContext context = emulator.getContext();
        int pid = context.getIntArg(0);
        UnidbgPointer param = context.getPointerArg(1);
        if (log.isDebugEnabled()) {
            log.debug((Object)("sched_getparam pid=" + pid + ", param=" + param));
        }
        param.setInt(0L, 0);
        return 0;
    }

    protected int sched_yield(Emulator<AndroidFileIO> emulator) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"sched_yield");
        }
        if (emulator.getThreadDispatcher().getTaskCount() <= 1) {
            return 0;
        }
        throw new ThreadContextSwitchException().setReturnValue(0L);
    }

    protected int getpriority(Emulator<AndroidFileIO> emulator) {
        RegisterContext context = emulator.getContext();
        int which = context.getIntArg(0);
        int who = context.getIntArg(1);
        if (log.isDebugEnabled()) {
            log.debug((Object)("getpriority which=" + which + ", who=" + who));
        }
        return 0;
    }

    protected int setpriority(Emulator<AndroidFileIO> emulator) {
        RegisterContext context = emulator.getContext();
        int which = context.getIntArg(0);
        int who = context.getIntArg(1);
        int prio = context.getIntArg(2);
        if (log.isDebugEnabled()) {
            log.debug((Object)("setpriority which=" + which + ", who=" + who + ", prio=" + prio));
        }
        return 0;
    }

    protected int sigprocmask(Emulator<?> emulator, int how, Pointer set, Pointer oldset) {
        Task task = (Task)emulator.get(Task.TASK_KEY);
        Task signalOps = task.isMainThread() ? emulator.getThreadDispatcher() : task;
        SigSet old = signalOps.getSigMaskSet();
        if (oldset != null && old != null) {
            if (emulator.is32Bit()) {
                oldset.setInt(0L, (int)old.getMask());
            } else {
                oldset.setLong(0L, old.getMask());
            }
        }
        if (set == null) {
            return 0;
        }
        long mask = emulator.is32Bit() ? (long)set.getInt(0L) : set.getLong(0L);
        switch (how) {
            case 0: {
                if (old == null) {
                    UnixSigSet sigSet = new UnixSigSet(mask);
                    UnixSigSet sigPendingSet = new UnixSigSet(0L);
                    signalOps.setSigMaskSet((SigSet)sigSet);
                    signalOps.setSigPendingSet((SigSet)sigPendingSet);
                } else {
                    old.blockSigSet(mask);
                }
                return 0;
            }
            case 1: {
                if (old != null) {
                    old.unblockSigSet(mask);
                }
                return 0;
            }
            case 2: {
                UnixSigSet sigSet = new UnixSigSet(mask);
                UnixSigSet sigPendingSet = new UnixSigSet(0L);
                signalOps.setSigMaskSet((SigSet)sigSet);
                signalOps.setSigPendingSet((SigSet)sigPendingSet);
                return 0;
            }
        }
        return super.sigprocmask(emulator, how, set, oldset);
    }

    protected int rt_sigpending(Emulator<AndroidFileIO> emulator) {
        Task task;
        RegisterContext context = emulator.getContext();
        UnidbgPointer set = context.getPointerArg(0);
        if (log.isDebugEnabled()) {
            log.debug((Object)("rt_sigpending set=" + set));
        }
        Task signalOps = (task = (Task)emulator.get(Task.TASK_KEY)).isMainThread() ? emulator.getThreadDispatcher() : task;
        SigSet sigSet = signalOps.getSigPendingSet();
        if (set != null && sigSet != null) {
            if (emulator.is32Bit()) {
                set.setInt(0L, (int)sigSet.getMask());
            } else {
                set.setLong(0L, sigSet.getMask());
            }
        }
        return 0;
    }

    protected int futex(Emulator<?> emulator) {
        RegisterContext context = emulator.getContext();
        UnidbgPointer uaddr = context.getPointerArg(0);
        int futex_op = context.getIntArg(1);
        int val = context.getIntArg(2);
        int old = uaddr.getInt(0L);
        boolean isPrivate = (futex_op & 0x80) != 0;
        int cmd = futex_op & 0x7F;
        if (log.isDebugEnabled()) {
            log.debug((Object)("futex uaddr=" + uaddr + ", isPrivate=" + isPrivate + ", cmd=" + cmd + ", val=0x" + Integer.toHexString(val) + ", old=0x" + Integer.toHexString(old) + ", LR=" + context.getLRPointer()));
        }
        Task task = (Task)emulator.get(Task.TASK_KEY);
        switch (cmd) {
            case 0: {
                if (old != val) {
                    Memory memory = emulator.getMemory();
                    memory.setErrno(11);
                    return -1;
                }
                UnidbgPointer timeout = context.getPointerArg(3);
                TimeSpec timeSpec = timeout == null ? null : TimeSpec.createTimeSpec(emulator, (Pointer)timeout);
                int mtype = val & 0xC000;
                int shared = val & 0x2000;
                if (log.isDebugEnabled()) {
                    log.debug((Object)("futex FUTEX_WAIT mtype=0x" + Integer.toHexString(mtype) + ", shared=" + shared + ", timeSpec=" + timeSpec + ", test=" + (mtype | shared) + ", task=" + task));
                }
                RunnableTask runningTask = emulator.getThreadDispatcher().getRunningTask();
                if (this.threadDispatcherEnabled && runningTask != null) {
                    if (timeSpec == null) {
                        runningTask.setWaiter(emulator, (Waiter)new FutexIndefinitelyWaiter((Pointer)uaddr, val));
                        throw new ThreadContextSwitchException();
                    }
                    throw new ThreadContextSwitchException().setReturnValue(-110L);
                }
                if (this.threadDispatcherEnabled && emulator.getThreadDispatcher().getTaskCount() > 1) {
                    throw new ThreadContextSwitchException().setReturnValue(-110L);
                }
                return 0;
            }
            case 1: {
                Task t;
                Waiter waiter;
                if (log.isDebugEnabled()) {
                    log.debug((Object)("futex FUTEX_WAKE val=0x" + Integer.toHexString(val) + ", old=" + old + ", task=" + task));
                }
                if (emulator.getThreadDispatcher().getTaskCount() <= 1) {
                    return 0;
                }
                int count = 0;
                Iterator iterator = emulator.getThreadDispatcher().getTaskList().iterator();
                while (!(!iterator.hasNext() || (waiter = (t = (Task)iterator.next()).getWaiter()) instanceof FutexWaiter && ((FutexWaiter)waiter).wakeUp((Pointer)uaddr) && ++count >= val)) {
                }
                if (count > 0) {
                    throw new ThreadContextSwitchException().setReturnValue((long)count);
                }
                if (this.threadDispatcherEnabled && task != null) {
                    throw new ThreadContextSwitchException().setReturnValue(1L);
                }
                return 0;
            }
        }
        throw new AbstractMethodError("futex_op=0x" + Integer.toHexString(futex_op));
    }

    protected int rt_sigtimedwait(Emulator<AndroidFileIO> emulator) {
        RegisterContext context = emulator.getContext();
        UnidbgPointer set = context.getPointerArg(0);
        UnidbgPointer info = context.getPointerArg(1);
        UnidbgPointer timeout = context.getPointerArg(2);
        int sigsetsize = context.getIntArg(3);
        long mask = emulator.is32Bit() ? (long)set.getInt(0L) : set.getLong(0L);
        Task task = (Task)emulator.get(Task.TASK_KEY);
        UnixSigSet sigSet = new UnixSigSet(mask);
        Object signalOps = task.isMainThread() ? emulator.getThreadDispatcher() : task;
        SigSet sigPendingSet = signalOps.getSigPendingSet();
        if (sigPendingSet != null) {
            for (Integer signum : sigSet) {
                if (!sigPendingSet.containsSigNumber(signum.intValue())) continue;
                sigPendingSet.removeSigNumber(signum.intValue());
                return signum;
            }
        }
        if (!task.isMainThread()) {
            throw new ThreadContextSwitchException().setReturnValue(-4L);
        }
        log.info((Object)("rt_sigtimedwait set=" + set + ", info=" + info + ", timeout=" + timeout + ", sigsetsize=" + sigsetsize + ", sigSet=" + sigSet + ", task=" + task));
        Log log = LogFactory.getLog(AbstractEmulator.class);
        if (log.isDebugEnabled()) {
            emulator.attach().debug();
        }
        return 0;
    }

    protected int rt_sigqueue(Emulator<AndroidFileIO> emulator) {
        RegisterContext context = emulator.getContext();
        int tgid = context.getIntArg(0);
        int sig = context.getIntArg(1);
        UnidbgPointer info = context.getPointerArg(2);
        if (log.isDebugEnabled()) {
            log.debug((Object)("rt_sigqueue tgid=" + tgid + ", sig=" + sig));
        }
        Task task = (Task)emulator.get(Task.TASK_KEY);
        if (tgid != 0 && tgid != -1 && Math.abs(tgid) != emulator.getPid()) {
            return -3;
        }
        if (sig == 0) {
            return 0;
        }
        if (sig < 0 || sig > 64) {
            return -22;
        }
        if (task != null) {
            SigAction sigAction = this.sigActionMap.get(sig);
            return this.processSignal(emulator.getThreadDispatcher(), sig, task, sigAction, (Pointer)info);
        }
        throw new UnsupportedOperationException();
    }

    protected FileResult<AndroidFileIO> createFdDir(int oflags, String pathname) {
        ArrayList<DirectoryFileIO.DirectoryEntry> list = new ArrayList<DirectoryFileIO.DirectoryEntry>();
        for (Map.Entry entry : this.fdMap.entrySet()) {
            list.add(new DirectoryFileIO.DirectoryEntry(DirectoryFileIO.DirentType.DT_LNK, ((Integer)entry.getKey()).toString()));
        }
        return FileResult.success((NewFileIO)new DirectoryFileIO(oflags, pathname, list.toArray(new DirectoryFileIO.DirectoryEntry[0])));
    }

    protected FileResult<AndroidFileIO> createTaskDir(Emulator<AndroidFileIO> emulator, int oflags, String pathname) {
        return FileResult.success((NewFileIO)new DirectoryFileIO(oflags, pathname, new DirectoryFileIO.DirectoryEntry(false, Integer.toString(emulator.getPid()))));
    }

    protected long statfs64(Emulator<AndroidFileIO> emulator, String path, Pointer buf) {
        FileResult result = this.resolve(emulator, path, 0);
        if (result == null) {
            log.info((Object)("statfs64 buf=" + buf + ", path=" + path));
            emulator.getMemory().setErrno(2);
            return -1L;
        }
        if (result.isSuccess()) {
            StatFS statFS = emulator.is64Bit() ? new StatFS64(buf) : new StatFS32(buf);
            int ret = ((AndroidFileIO)result.io).statfs(statFS);
            if (ret != 0) {
                log.info((Object)("statfs64 buf=" + buf + ", path=" + path));
            } else {
                if (this.verbose) {
                    System.out.printf("File statfs '%s' from %s%n", result.io, emulator.getContext().getLRPointer());
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)("statfs64 buf=" + buf + ", path=" + path));
                }
            }
            return ret;
        }
        log.info((Object)("statfs64 buf=" + buf + ", path=" + path));
        emulator.getMemory().setErrno(result.errno);
        return -1L;
    }

    protected int pipe2(Emulator<?> emulator) {
        try {
            RegisterContext context = emulator.getContext();
            UnidbgPointer pipefd = context.getPointerArg(0);
            int flags = context.getIntArg(1);
            int writefd = this.getMinFd();
            Pair<AndroidFileIO, AndroidFileIO> pair = this.getPipePair(emulator, writefd);
            this.fdMap.put(writefd, pair.getLeft());
            int readfd = this.getMinFd();
            this.fdMap.put(readfd, pair.getRight());
            pipefd.setInt(0L, readfd);
            pipefd.setInt(4L, writefd);
            if (log.isDebugEnabled()) {
                log.debug((Object)("pipe2 pipefd=" + pipefd + ", flags=0x" + flags + ", readfd=" + readfd + ", writefd=" + writefd));
            }
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        return 0;
    }

    protected Pair<AndroidFileIO, AndroidFileIO> getPipePair(Emulator<?> emulator, int writefd) throws IOException {
        PipedInputStream inputStream = new PipedInputStream();
        PipedOutputStream outputStream = new PipedOutputStream(inputStream);
        PipedWriteFileIO writeIO = new PipedWriteFileIO(outputStream, writefd);
        PipedReadFileIO readIO = new PipedReadFileIO(inputStream, writefd);
        log.info((Object)"Return default pipe pair.");
        return new Pair((Object)writeIO, (Object)readIO);
    }

    protected int fchmodat(Emulator<AndroidFileIO> emulator) {
        RegisterContext context = emulator.getContext();
        int dirfd = context.getIntArg(0);
        UnidbgPointer pathname_p = context.getPointerArg(1);
        int mode = context.getIntArg(2);
        int flags = context.getIntArg(3);
        String pathname = pathname_p.getString(0L);
        if (log.isDebugEnabled()) {
            log.debug((Object)("fchmodat dirfd=" + dirfd + ", pathname=" + pathname + ", mode=0x" + Integer.toHexString(mode) + ", flags=0x" + Integer.toHexString(flags)));
        }
        return 0;
    }

    protected int fchownat(Emulator<AndroidFileIO> emulator) {
        RegisterContext context = emulator.getContext();
        int dirfd = context.getIntArg(0);
        UnidbgPointer pathname_p = context.getPointerArg(1);
        int owner = context.getIntArg(2);
        int group = context.getIntArg(3);
        int flags = context.getIntArg(4);
        String pathname = pathname_p.getString(0L);
        if (log.isDebugEnabled()) {
            log.debug((Object)("fchownat dirfd=" + dirfd + ", pathname=" + pathname + ", owner=" + owner + ", group=" + group + ", flags=0x" + Integer.toHexString(flags)));
        }
        return 0;
    }

    protected int mkdirat(Emulator<?> emulator) {
        RegisterContext context = emulator.getContext();
        int dirfd = context.getIntArg(0);
        UnidbgPointer pathname_p = context.getPointerArg(1);
        int mode = context.getIntArg(2);
        String pathname = pathname_p.getString(0L);
        if (log.isDebugEnabled()) {
            log.debug((Object)("mkdirat dirfd=" + dirfd + ", pathname=" + pathname + ", mode=" + Integer.toHexString(mode)));
        }
        if (dirfd != -100) {
            throw new BackendException();
        }
        if (emulator.getFileSystem().mkdir(pathname, mode)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("mkdir pathname=" + pathname + ", mode=" + mode));
            }
            return 0;
        }
        log.info((Object)("mkdir pathname=" + pathname + ", mode=" + mode));
        emulator.getMemory().setErrno(13);
        return -1;
    }

    final int select(int nfds, Pointer checkfds, Pointer clearfds, boolean checkRead) {
        int i;
        int count = 0;
        for (i = 0; i < nfds; ++i) {
            int mask = checkfds.getInt((long)(i / 32));
            if ((mask >> i & 1) != 1) continue;
            AndroidFileIO io = (AndroidFileIO)this.fdMap.get(i);
            if (!checkRead || io.canRead()) {
                ++count;
                continue;
            }
            checkfds.setInt((long)(i / 32), mask &= ~(1 << i));
        }
        if (count > 0 && clearfds != null) {
            for (i = 0; i < nfds; ++i) {
                clearfds.setInt((long)(i / 32), 0);
            }
        }
        return count;
    }

    protected int sigaltstack(Emulator<?> emulator) {
        RegisterContext context = emulator.getContext();
        UnidbgPointer ss = context.getPointerArg(0);
        UnidbgPointer old_ss = context.getPointerArg(1);
        if (log.isDebugEnabled()) {
            log.debug((Object)("sigaltstack ss=" + ss + ", old_ss=" + old_ss));
        }
        return 0;
    }

    protected int renameat(Emulator<?> emulator) {
        RegisterContext context = emulator.getContext();
        int olddirfd = context.getIntArg(0);
        String oldpath = context.getPointerArg(1).getString(0L);
        int newdirfd = context.getIntArg(2);
        String newpath = context.getPointerArg(3).getString(0L);
        int ret = emulator.getFileSystem().rename(oldpath, newpath);
        if (ret != 0) {
            log.info((Object)("renameat olddirfd=" + olddirfd + ", oldpath=" + oldpath + ", newdirfd=" + newdirfd + ", newpath=" + newpath));
        } else {
            log.debug((Object)("renameat olddirfd=" + olddirfd + ", oldpath=" + oldpath + ", newdirfd=" + newdirfd + ", newpath=" + newpath));
        }
        return 0;
    }

    protected int unlinkat(Emulator<?> emulator) {
        RegisterContext context = emulator.getContext();
        int dirfd = context.getIntArg(0);
        UnidbgPointer pathname = context.getPointerArg(1);
        int flags = context.getIntArg(2);
        emulator.getFileSystem().unlink(pathname.getString(0L));
        if (log.isDebugEnabled()) {
            log.info((Object)("unlinkat dirfd=" + dirfd + ", pathname=" + pathname.getString(0L) + ", flags=" + flags));
        }
        return 0;
    }

    protected void exit(Emulator<AndroidFileIO> emulator) {
        RegisterContext context = emulator.getContext();
        int status = context.getIntArg(0);
        Task task = (Task)emulator.get(Task.TASK_KEY);
        if (task instanceof ThreadTask) {
            ThreadTask threadTask = (ThreadTask)task;
            threadTask.setExitStatus(status);
            throw new ThreadContextSwitchException().setReturnValue(0L);
        }
        System.out.println("exit status=" + status);
        if (LogFactory.getLog(AbstractEmulator.class).isDebugEnabled()) {
            emulator.attach().debug();
        }
        emulator.getBackend().emu_stop();
    }

    public MainTask createSignalHandlerTask(Emulator<?> emulator, int sig) {
        SigAction action = this.sigActionMap.get(sig);
        if (action != null) {
            return new SignalFunction(emulator, sig, action);
        }
        return super.createSignalHandlerTask(emulator, sig);
    }

    protected int sigaction(Emulator<?> emulator, int signum, Pointer act, Pointer oldact) {
        SigAction action = SigAction.create(emulator, act);
        SigAction oldAction = SigAction.create(emulator, oldact);
        if (log.isDebugEnabled()) {
            log.debug((Object)("sigaction signum=" + signum + ", action=" + (Object)((Object)action) + ", oldAction=" + (Object)((Object)oldAction)));
        }
        if (9 == signum || 19 == signum) {
            if (oldAction != null) {
                oldAction.setSaHandler(-1L);
                oldAction.pack();
            }
            return -22;
        }
        SigAction lastAction = this.sigActionMap.put(signum, action);
        if (oldAction != null) {
            if (lastAction == null) {
                oldact.write(0L, new byte[oldAction.size()], 0, oldAction.size());
            } else {
                oldAction.setSaHandler(lastAction.getSaHandler());
                oldAction.setSaRestorer(lastAction.getSaRestorer());
                oldAction.setFlags(lastAction.getFlags());
                oldAction.setMask(lastAction.getMask());
                oldAction.pack();
            }
        }
        return 0;
    }

    protected int kill(Emulator<?> emulator) {
        RegisterContext context = emulator.getContext();
        int pid = context.getIntArg(0);
        int sig = context.getIntArg(1);
        if (log.isDebugEnabled()) {
            log.debug((Object)("kill pid=" + pid + ", sig=" + sig));
        }
        if (sig == 0) {
            return 0;
        }
        if (sig < 0 || sig > 64) {
            return -22;
        }
        Task task = (Task)emulator.get(Task.TASK_KEY);
        if ((pid == 0 || pid == emulator.getPid()) && task != null) {
            SigAction action = this.sigActionMap.get(sig);
            return this.processSignal(emulator.getThreadDispatcher(), sig, task, action, null);
        }
        throw new UnsupportedOperationException("kill pid=" + pid + ", sig=" + sig + ", LR=" + context.getLRPointer());
    }

    private int processSignal(ThreadDispatcher threadDispatcher, int sig, Task task, SigAction action, Pointer sig_info) {
        if (action != null) {
            ThreadDispatcher signalOps = task.isMainThread() ? threadDispatcher : task;
            SigSet sigMaskSet = signalOps.getSigMaskSet();
            SigSet sigPendingSet = signalOps.getSigPendingSet();
            if (sigMaskSet == null || !sigMaskSet.containsSigNumber(sig)) {
                task.addSignalTask((com.github.unidbg.signal.SignalTask)new SignalTask(sig, action, sig_info));
                throw new ThreadContextSwitchException().setReturnValue(0L);
            }
            if (sigPendingSet != null) {
                sigPendingSet.addSigNumber(sig);
            }
        }
        return 0;
    }

    protected int tgkill(Emulator<?> emulator) {
        RegisterContext context = emulator.getContext();
        int tgid = context.getIntArg(0);
        int tid = context.getIntArg(1);
        int sig = context.getIntArg(2);
        if (log.isDebugEnabled()) {
            log.debug((Object)("tgkill tgid=" + tgid + ", tid=" + tid + ", sig=" + sig));
        }
        if (sig == 0) {
            return 0;
        }
        if (sig < 0 || sig > 64) {
            return -22;
        }
        SigAction action = this.sigActionMap.get(sig);
        if (emulator.getThreadDispatcher().sendSignal(tid, sig, (com.github.unidbg.signal.SignalTask)(action == null ? null : new SignalTask(sig, action)))) {
            throw new ThreadContextSwitchException().setReturnValue(0L);
        }
        return 0;
    }

    protected int set_tid_address(Emulator<AndroidFileIO> emulator) {
        Task task;
        RegisterContext context = emulator.getContext();
        UnidbgPointer tidptr = context.getPointerArg(0);
        if (log.isDebugEnabled()) {
            log.debug((Object)("set_tid_address tidptr=" + tidptr));
        }
        if ((task = (Task)emulator.get(Task.TASK_KEY)) instanceof MarshmallowThread) {
            MarshmallowThread thread = (MarshmallowThread)task;
            thread.set_tid_address((Pointer)tidptr);
        }
        return 0;
    }

    protected final int incrementThreadId(Emulator<?> emulator) {
        if (this.threadId == 0) {
            this.threadId = emulator.getPid();
        }
        return ++this.threadId & 0xFFFF;
    }

    protected int nanosleep(Emulator<?> emulator) {
        RegisterContext context = emulator.getContext();
        UnidbgPointer req = context.getPointerArg(0);
        UnidbgPointer rem = context.getPointerArg(1);
        TimeSpec timeSpec = TimeSpec.createTimeSpec(emulator, (Pointer)req);
        if (log.isDebugEnabled()) {
            log.debug((Object)("nanosleep req=" + req + ", rem=" + rem + ", timeSpec=" + timeSpec));
        }
        RunnableTask runningTask = emulator.getThreadDispatcher().getRunningTask();
        if (this.threadDispatcherEnabled && runningTask != null) {
            runningTask.setWaiter(emulator, (Waiter)new NanoSleepWaiter(emulator, (Pointer)rem, timeSpec));
            throw new ThreadContextSwitchException().setReturnValue(0L);
        }
        try {
            Thread.sleep(timeSpec.toMillis());
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return 0;
    }

    protected int fallocate(Emulator<AndroidFileIO> emulator) {
        RegisterContext context = emulator.getContext();
        int fd = context.getIntArg(0);
        int mode = context.getIntArg(1);
        int offset = context.getIntArg(2);
        int len = context.getIntArg(3);
        if (log.isDebugEnabled()) {
            log.debug((Object)("fallocate fd=" + fd + ", mode=0x" + Integer.toHexString(mode) + ", offset=" + offset + ", len=" + len));
        }
        return 0;
    }
}

