/*
 * Decompiled with CFR 0.152.
 */
package com.github.unidbg.linux;

import com.github.unidbg.Alignment;
import com.github.unidbg.Emulator;
import com.github.unidbg.Module;
import com.github.unidbg.Symbol;
import com.github.unidbg.arm.ARM;
import com.github.unidbg.linux.LinuxSymbol;
import com.github.unidbg.linux.ModuleSymbol;
import com.github.unidbg.memory.MemRegion;
import com.github.unidbg.memory.Memory;
import com.github.unidbg.pointer.UnidbgPointer;
import com.github.unidbg.spi.InitFunction;
import com.github.unidbg.spi.LibraryFile;
import com.github.unidbg.utils.Inspector;
import com.github.unidbg.virtualmodule.VirtualSymbol;
import com.sun.jna.Pointer;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.fornwall.jelf.ArmExIdx;
import net.fornwall.jelf.ElfDynamicStructure;
import net.fornwall.jelf.ElfException;
import net.fornwall.jelf.ElfFile;
import net.fornwall.jelf.ElfSection;
import net.fornwall.jelf.ElfSymbol;
import net.fornwall.jelf.GnuEhFrameHeader;
import net.fornwall.jelf.MemoizedObject;
import net.fornwall.jelf.SymbolLocator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class LinuxModule
extends Module {
    private static final Log log = LogFactory.getLog(LinuxModule.class);
    private final SymbolLocator dynsym;
    private final List<ModuleSymbol> unresolvedSymbol;
    public final List<InitFunction> initFunctionList;
    public final MemoizedObject<ArmExIdx> armExIdx;
    public final MemoizedObject<GnuEhFrameHeader> ehFrameHeader;
    private final ElfSection symbolTableSection;
    public final ElfFile elfFile;
    public final ElfDynamicStructure dynamicStructure;
    final Map<String, Long> hookMap = new HashMap<String, Long>();

    static LinuxModule createVirtualModule(String name, final Map<String, UnidbgPointer> symbols, Emulator<?> emulator) {
        if (symbols.isEmpty()) {
            throw new IllegalArgumentException("symbols is empty");
        }
        ArrayList<UnidbgPointer> list = new ArrayList<UnidbgPointer>(symbols.values());
        Collections.sort(list, new Comparator<UnidbgPointer>(){

            @Override
            public int compare(UnidbgPointer o1, UnidbgPointer o2) {
                return (int)(o1.peer - o2.peer);
            }
        });
        UnidbgPointer first = (UnidbgPointer)list.get(0);
        UnidbgPointer last = (UnidbgPointer)list.get(list.size() - 1);
        Alignment alignment = ARM.align((long)first.peer, (long)(last.peer - first.peer), (long)emulator.getPageAlign());
        long base = alignment.address;
        long size = alignment.size;
        if (log.isDebugEnabled()) {
            log.debug((Object)("createVirtualModule first=0x" + Long.toHexString(first.peer) + ", last=0x" + Long.toHexString(last.peer) + ", base=0x" + Long.toHexString(base) + ", size=0x" + Long.toHexString(size)));
        }
        LinuxModule module = new LinuxModule(base, size, name, null, Collections.emptyList(), Collections.emptyList(), Collections.emptyMap(), Collections.emptyList(), null, null, null, null, null, null){

            @Override
            public Symbol findSymbolByName(String name, boolean withDependencies) {
                UnidbgPointer pointer = (UnidbgPointer)symbols.get(name);
                if (pointer != null) {
                    return new VirtualSymbol(name, (Module)this, pointer.peer);
                }
                return null;
            }

            @Override
            public ElfSymbol getELFSymbolByName(String name) {
                return null;
            }

            public boolean isVirtual() {
                return true;
            }
        };
        for (Map.Entry<String, UnidbgPointer> entry : symbols.entrySet()) {
            module.registerSymbol(entry.getKey(), entry.getValue().peer);
        }
        return module;
    }

    LinuxModule(long base, long size, String name, SymbolLocator dynsym, List<ModuleSymbol> unresolvedSymbol, List<InitFunction> initFunctionList, Map<String, Module> neededLibraries, List<MemRegion> regions, MemoizedObject<ArmExIdx> armExIdx, MemoizedObject<GnuEhFrameHeader> ehFrameHeader, ElfSection symbolTableSection, ElfFile elfFile, ElfDynamicStructure dynamicStructure, LibraryFile libraryFile) {
        super(name, base, size, neededLibraries, regions, libraryFile);
        this.dynsym = dynsym;
        this.unresolvedSymbol = unresolvedSymbol;
        this.initFunctionList = initFunctionList;
        this.armExIdx = armExIdx;
        this.ehFrameHeader = ehFrameHeader;
        this.symbolTableSection = symbolTableSection;
        this.elfFile = elfFile;
        this.dynamicStructure = dynamicStructure;
    }

    public int virtualMemoryAddressToFileOffset(long offset) {
        try {
            return (int)this.elfFile.virtualMemoryAddrToFileOffset(offset);
        }
        catch (ElfException e) {
            return -1;
        }
        catch (IOException e) {
            throw new IllegalStateException("virtualMemoryAddressToFileOffset offset=0x" + Long.toHexString(offset));
        }
    }

    void callInitFunction(Emulator<?> emulator, boolean mustCallInit) throws IOException {
        if (!mustCallInit && !this.unresolvedSymbol.isEmpty()) {
            for (ModuleSymbol moduleSymbol : this.unresolvedSymbol) {
                log.info((Object)("[" + this.name + "]" + moduleSymbol.getSymbol().getName() + " symbol is missing before init relocationAddr=" + moduleSymbol.getRelocationAddr()));
            }
            return;
        }
        int index = 0;
        while (!this.initFunctionList.isEmpty()) {
            InitFunction initFunction = this.initFunctionList.remove(0);
            long initAddress = initFunction.getAddress();
            if (this.initFunctionListener != null) {
                this.initFunctionListener.onPreCallInitFunction((Module)this, initAddress, index);
            }
            initAddress = initFunction.call(emulator);
            if (this.initFunctionListener != null) {
                this.initFunctionListener.onPostCallInitFunction((Module)this, initAddress, index);
            }
            ++index;
        }
    }

    public List<ModuleSymbol> getUnresolvedSymbol() {
        return this.unresolvedSymbol;
    }

    public Symbol findSymbolByName(String name, boolean withDependencies) {
        try {
            ElfSymbol elfSymbol = this.dynsym.getELFSymbolByName(name);
            if (elfSymbol != null && !elfSymbol.isUndef()) {
                return new LinuxSymbol(this, elfSymbol);
            }
            if (withDependencies) {
                return this.findDependencySymbolByName(name);
            }
            return null;
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    public ElfSymbol getELFSymbolByName(String name) throws IOException {
        return this.dynsym.getELFSymbolByName(name);
    }

    public Symbol findClosestSymbolByAddress(long addr, boolean fast) {
        try {
            long entry;
            ElfSymbol elfSymbol;
            long soaddr = addr - this.base;
            if (soaddr <= 0L) {
                return null;
            }
            ElfSymbol elfSymbol2 = elfSymbol = this.dynsym == null ? null : this.dynsym.getELFSymbolByAddr(soaddr);
            if (this.symbolTableSection != null && elfSymbol == null) {
                elfSymbol = this.symbolTableSection.getELFSymbolByAddr(soaddr);
            }
            LinuxSymbol symbol = null;
            if (elfSymbol != null) {
                symbol = new LinuxSymbol(this, elfSymbol);
            }
            if (addr >= (entry = this.base + this.entryPoint) && (symbol == null || entry > symbol.getAddress())) {
                symbol = new VirtualSymbol("start", (Module)this, entry);
            }
            return symbol;
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    public int callEntry(Emulator<?> emulator, String ... args) {
        if (this.entryPoint <= 0L) {
            throw new IllegalStateException("Invalid entry point");
        }
        Memory memory = emulator.getMemory();
        UnidbgPointer stack = memory.allocateStack(0);
        int argc = 0;
        ArrayList<UnidbgPointer> argv = new ArrayList<UnidbgPointer>();
        argv.add(memory.writeStackString(emulator.getProcessName()));
        ++argc;
        for (int i = 0; args != null && i < args.length; ++i) {
            String arg = args[i];
            argv.add(memory.writeStackString(arg));
            ++argc;
        }
        if (argc % 2 != 0) {
            memory.allocateStack(emulator.getPointerSize());
        }
        UnidbgPointer auxvPointer = memory.allocateStack(emulator.getPointerSize());
        assert (auxvPointer != null);
        auxvPointer.setPointer(0L, null);
        UnidbgPointer envPointer = memory.allocateStack(emulator.getPointerSize());
        assert (envPointer != null);
        envPointer.setPointer(0L, null);
        UnidbgPointer pointer = memory.allocateStack(emulator.getPointerSize());
        assert (pointer != null);
        pointer.setPointer(0L, null);
        Collections.reverse(argv);
        for (Pointer pointer2 : argv) {
            pointer = memory.allocateStack(emulator.getPointerSize());
            assert (pointer != null);
            pointer.setPointer(0L, pointer2);
        }
        UnidbgPointer kernelArgumentBlock = memory.allocateStack(emulator.getPointerSize());
        assert (kernelArgumentBlock != null);
        kernelArgumentBlock.setInt(0L, argc);
        if (log.isDebugEnabled()) {
            UnidbgPointer unidbgPointer = memory.allocateStack(0);
            byte[] data = unidbgPointer.getByteArray(0L, (int)(stack.peer - unidbgPointer.peer));
            Inspector.inspect((byte[])data, (String)("kernelArgumentBlock=" + kernelArgumentBlock + ", envPointer=" + envPointer + ", auxvPointer=" + auxvPointer));
        }
        return emulator.eEntry(this.base + this.entryPoint, kernelArgumentBlock.peer).intValue();
    }

    public Number callFunction(Emulator<?> emulator, long offset, Object ... args) {
        return LinuxModule.emulateFunction(emulator, (long)(this.base + offset), (Object[])args);
    }

    public String getPath() {
        return this.name;
    }

    public void registerSymbol(String symbolName, long address) {
        this.hookMap.put(symbolName, address);
    }

    public String toString() {
        return "LinuxModule{base=0x" + Long.toHexString(this.base) + ", size=" + this.size + ", name='" + this.name + '\'' + '}';
    }
}

