/*
 * Decompiled with CFR 0.152.
 */
package com.github.unidbg.linux.android;

import com.github.unidbg.Emulator;
import com.github.unidbg.Svc;
import com.github.unidbg.arm.Arm64Hook;
import com.github.unidbg.arm.ArmHook;
import com.github.unidbg.arm.HookStatus;
import com.github.unidbg.arm.backend.BackendException;
import com.github.unidbg.arm.context.RegisterContext;
import com.github.unidbg.hook.HookListener;
import com.github.unidbg.linux.android.SystemPropertyProvider;
import com.github.unidbg.memory.SvcMemory;
import com.github.unidbg.pointer.UnidbgPointer;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SystemPropertyHook
implements HookListener {
    private static final Log log = LogFactory.getLog(SystemPropertyHook.class);
    private static final int PROP_VALUE_MAX = 92;
    private final Emulator<?> emulator;
    private SystemPropertyProvider propertyProvider;

    public SystemPropertyHook(Emulator<?> emulator) {
        this.emulator = emulator;
    }

    public long hook(SvcMemory svcMemory, String libraryName, String symbolName, final long old) {
        if ("libc.so".equals(libraryName)) {
            if ("__system_property_get".equals(symbolName)) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Hook " + symbolName));
                }
                if (this.emulator.is64Bit()) {
                    return svcMemory.registerSvc((Svc)new Arm64Hook(){

                        protected HookStatus hook(Emulator<?> emulator) {
                            RegisterContext context = emulator.getContext();
                            int index = 0;
                            UnidbgPointer pointer = context.getPointerArg(index);
                            String key = pointer.getString(0L);
                            return SystemPropertyHook.this.__system_property_get(old, key, index);
                        }
                    }).peer;
                }
                return svcMemory.registerSvc((Svc)new ArmHook(){

                    protected HookStatus hook(Emulator<?> emulator) {
                        RegisterContext context = emulator.getContext();
                        int index = 0;
                        UnidbgPointer pointer = context.getPointerArg(index);
                        String key = pointer.getString(0L);
                        return SystemPropertyHook.this.__system_property_get(old, key, index);
                    }
                }).peer;
            }
            if ("__system_property_read".equals(symbolName)) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Hook " + symbolName));
                }
                if (this.emulator.is64Bit()) {
                    return svcMemory.registerSvc((Svc)new Arm64Hook(){

                        protected HookStatus hook(Emulator<?> emulator) {
                            RegisterContext context = emulator.getContext();
                            UnidbgPointer pi = context.getPointerArg(0);
                            String key = pi.share(96L).getString(0L);
                            return SystemPropertyHook.this.__system_property_get(old, key, 1);
                        }
                    }).peer;
                }
                return svcMemory.registerSvc((Svc)new ArmHook(){

                    protected HookStatus hook(Emulator<?> emulator) {
                        RegisterContext context = emulator.getContext();
                        UnidbgPointer pi = context.getPointerArg(0);
                        String key = pi.share(96L).getString(0L);
                        return SystemPropertyHook.this.__system_property_get(old, key, 1);
                    }
                }).peer;
            }
            if ("__system_property_find".equals(symbolName)) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Hook " + symbolName));
                }
                if (this.emulator.is64Bit()) {
                    return svcMemory.registerSvc((Svc)new Arm64Hook(){

                        protected HookStatus hook(Emulator<?> emulator) {
                            RegisterContext context = emulator.getContext();
                            UnidbgPointer name = context.getPointerArg(0);
                            if (log.isDebugEnabled()) {
                                log.debug((Object)("__system_property_find key=" + name.getString(0L)));
                            }
                            return HookStatus.RET(emulator, (long)old);
                        }
                    }).peer;
                }
                return svcMemory.registerSvc((Svc)new ArmHook(){

                    protected HookStatus hook(Emulator<?> emulator) {
                        RegisterContext context = emulator.getContext();
                        UnidbgPointer name = context.getPointerArg(0);
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("__system_property_find key=" + name.getString(0L)));
                        }
                        return HookStatus.RET(emulator, (long)old);
                    }
                }).peer;
            }
        }
        return 0L;
    }

    private HookStatus __system_property_get(long old, String key, int index) {
        String value;
        RegisterContext context = this.emulator.getContext();
        if (this.propertyProvider != null && (value = this.propertyProvider.getProperty(key)) != null) {
            byte[] data;
            if (log.isDebugEnabled()) {
                log.debug((Object)("__system_property_get key=" + key + ", value=" + value));
            }
            if ((data = value.getBytes(StandardCharsets.UTF_8)).length >= 92) {
                throw new BackendException("invalid property value length: key=" + key + ", value=" + value);
            }
            context.getPointerArg(index + 1).write(0L, Arrays.copyOf(data, data.length + 1), 0, data.length + 1);
            return HookStatus.LR(this.emulator, (long)data.length);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("__system_property_get key=" + key));
        }
        return HookStatus.RET(this.emulator, (long)old);
    }

    public void setPropertyProvider(SystemPropertyProvider propertyProvider) {
        this.propertyProvider = propertyProvider;
    }
}

