/*
 * Decompiled with CFR 0.152.
 */
package com.github.unidbg.linux.android.dvm.jni;

import com.github.unidbg.linux.android.dvm.BaseVM;
import com.github.unidbg.linux.android.dvm.DvmField;
import com.github.unidbg.linux.android.dvm.DvmMethod;
import com.github.unidbg.linux.android.dvm.DvmObject;
import com.github.unidbg.linux.android.dvm.Shorty;
import com.github.unidbg.linux.android.dvm.VaList;
import com.github.unidbg.linux.android.dvm.VarArg;
import com.github.unidbg.linux.android.dvm.jni.ProxyCall;
import com.github.unidbg.linux.android.dvm.jni.ProxyConstructor;
import com.github.unidbg.linux.android.dvm.jni.ProxyDvmObjectVisitor;
import com.github.unidbg.linux.android.dvm.jni.ProxyField;
import com.github.unidbg.linux.android.dvm.jni.ProxyMethod;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

class ProxyUtils {
    ProxyUtils() {
    }

    private static void parseMethodArgs(DvmMethod dvmMethod, List<Class<?>> classes, List<Object> args, VarArg varArg, ClassLoader classLoader) {
        Shorty[] shorties = dvmMethod.decodeArgsShorty();
        block11: for (int i = 0; i < shorties.length; ++i) {
            Shorty shorty = shorties[i];
            switch (shorty.getType()) {
                case 'B': {
                    classes.add(Byte.TYPE);
                    args.add((byte)varArg.getIntArg(i));
                    continue block11;
                }
                case 'C': {
                    classes.add(Character.TYPE);
                    args.add(Character.valueOf((char)varArg.getIntArg(i)));
                    continue block11;
                }
                case 'I': {
                    classes.add(Integer.TYPE);
                    args.add(varArg.getIntArg(i));
                    continue block11;
                }
                case 'S': {
                    classes.add(Short.TYPE);
                    args.add((short)varArg.getIntArg(i));
                    continue block11;
                }
                case 'Z': {
                    classes.add(Boolean.TYPE);
                    int value = varArg.getIntArg(i);
                    args.add(BaseVM.valueOf(value));
                    continue block11;
                }
                case 'F': {
                    classes.add(Float.TYPE);
                    args.add(Float.valueOf(varArg.getFloatArg(i)));
                    continue block11;
                }
                case 'L': {
                    Object dvmObject = varArg.getObjectArg(i);
                    if (dvmObject == null) {
                        classes.add(shorty.decodeType(classLoader));
                        args.add(null);
                        continue block11;
                    }
                    Object obj = ProxyUtils.unpack(dvmObject);
                    classes.add(obj.getClass());
                    args.add(obj);
                    continue block11;
                }
                case 'D': {
                    classes.add(Double.TYPE);
                    args.add(varArg.getDoubleArg(i));
                    continue block11;
                }
                case 'J': {
                    classes.add(Long.TYPE);
                    args.add(varArg.getLongArg(i));
                    continue block11;
                }
                default: {
                    throw new IllegalStateException("c=" + shorty.getType());
                }
            }
        }
    }

    private static Object unpack(DvmObject<?> dvmObject) {
        if (dvmObject == null) {
            return null;
        }
        Object obj = dvmObject.getValue();
        if (obj instanceof DvmObject) {
            return ProxyUtils.unpack((DvmObject)obj);
        }
        Class<?> clazz = obj.getClass();
        if (clazz.isArray() && DvmObject.class.isAssignableFrom(clazz.getComponentType())) {
            Object[] dvmArray = (Object[])obj;
            Object[] array = new Object[dvmArray.length];
            Class<?> arrayType = null;
            boolean oneArrayType = false;
            for (int i = 0; i < dvmArray.length; ++i) {
                DvmObject dvm = (DvmObject)dvmArray[i];
                array[i] = ProxyUtils.unpack(dvm);
                if (array[i] == null) continue;
                if (arrayType == null) {
                    arrayType = array[i].getClass();
                    oneArrayType = true;
                    continue;
                }
                if (arrayType == array[i].getClass()) continue;
                oneArrayType = false;
            }
            if (oneArrayType) {
                Object oneArray = Array.newInstance(arrayType, array.length);
                for (int i = 0; i < array.length; ++i) {
                    Array.set(oneArray, i, array[i]);
                }
                return oneArray;
            }
            return array;
        }
        return obj;
    }

    static void parseMethodArgs(DvmMethod dvmMethod, List<Class<?>> classes, ClassLoader classLoader) {
        Shorty[] shorties;
        for (Shorty shorty : shorties = dvmMethod.decodeArgsShorty()) {
            Class<?> clazz = shorty.decodeType(classLoader);
            classes.add(clazz);
        }
    }

    private static boolean matchesTypes(Class<?>[] parameterTypes, Class<?>[] types, boolean strict) {
        if (parameterTypes.length != types.length) {
            return false;
        }
        for (int i = 0; i < types.length; ++i) {
            if (types[i] == null || !(strict ? parameterTypes[i] != types[i] : !parameterTypes[i].isAssignableFrom(types[i]))) continue;
            return false;
        }
        return true;
    }

    static Member matchMethodTypes(Class<?> clazz, String methodName, Class<?>[] types, boolean isStatic) throws NoSuchMethodException {
        ArrayList<Object> methods = new ArrayList<Object>();
        if (isStatic) {
            for (Method method : clazz.getMethods()) {
                if (method.getParameterTypes().length != types.length || !methodName.equals(method.getName()) || !Modifier.isStatic(method.getModifiers())) continue;
                methods.add(method);
            }
        }
        for (Method method : clazz.getDeclaredMethods()) {
            if (method.getParameterTypes().length != types.length || !methodName.equals(method.getName()) || isStatic != Modifier.isStatic(method.getModifiers())) continue;
            methods.add(method);
        }
        if (!isStatic) {
            for (Method method : clazz.getDeclaredMethods()) {
                if (method.getParameterTypes().length != types.length || !methodName.equals(method.getName()) || !Modifier.isStatic(method.getModifiers())) continue;
                methods.add(method);
            }
        }
        for (Method noSuchMethodException : methods) {
            if (!ProxyUtils.matchesTypes(noSuchMethodException.getParameterTypes(), types, true)) continue;
            return noSuchMethodException;
        }
        for (Method method : methods) {
            if (!ProxyUtils.matchesTypes(method.getParameterTypes(), types, false)) continue;
            return method;
        }
        if ("<init>".equals(methodName)) {
            for (Constructor<?> constructor : clazz.getDeclaredConstructors()) {
                if (!ProxyUtils.matchesTypes(constructor.getParameterTypes(), types, true)) continue;
                return constructor;
            }
        }
        Class<?> parentClass = clazz.getSuperclass();
        if (!isStatic && parentClass != null) {
            try {
                return ProxyUtils.matchMethodTypes(parentClass, methodName, types, false);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
        }
        throw new NoSuchMethodException(clazz.getName() + "." + methodName + Arrays.toString(types));
    }

    private static Constructor<?> matchConstructorTypes(Class<?> clazz, Class<?>[] types) throws NoSuchMethodException {
        for (Constructor<?> constructor : clazz.getDeclaredConstructors()) {
            if (!ProxyUtils.matchesTypes(constructor.getParameterTypes(), types, true)) continue;
            return constructor;
        }
        for (Constructor<?> constructor : clazz.getDeclaredConstructors()) {
            if (!ProxyUtils.matchesTypes(constructor.getParameterTypes(), types, false)) continue;
            return constructor;
        }
        throw new NoSuchMethodException(clazz.getName() + ".<init>" + Arrays.toString(types));
    }

    public static ProxyCall findAllocConstructor(Class<?> clazz, ProxyDvmObjectVisitor visitor) throws NoSuchMethodException {
        Constructor<?> constructor = ProxyUtils.matchConstructorTypes(clazz, new Class[0]);
        return new ProxyConstructor(visitor, constructor, new Object[0]);
    }

    static ProxyCall findConstructor(Class<?> clazz, DvmMethod dvmMethod, VarArg varArg, ProxyDvmObjectVisitor visitor) throws NoSuchMethodException {
        if (!"<init>".equals(dvmMethod.getMethodName())) {
            throw new IllegalStateException(dvmMethod.getMethodName());
        }
        ArrayList classes = new ArrayList(10);
        ArrayList<Object> args = new ArrayList<Object>(10);
        ProxyUtils.parseMethodArgs(dvmMethod, classes, args, varArg, clazz.getClassLoader());
        if (dvmMethod.member != null) {
            return new ProxyConstructor(visitor, (Constructor)dvmMethod.member, args.toArray());
        }
        Class[] types = classes.toArray(new Class[0]);
        Constructor<?> constructor = ProxyUtils.matchConstructorTypes(clazz, types);
        dvmMethod.setMember(constructor);
        return new ProxyConstructor(visitor, constructor, args.toArray());
    }

    static ProxyCall findMethod(Class<?> clazz, DvmMethod dvmMethod, VarArg varArg, boolean isStatic, ProxyDvmObjectVisitor visitor) throws NoSuchMethodException {
        ArrayList classes = new ArrayList(10);
        ArrayList<Object> args = new ArrayList<Object>(10);
        ProxyUtils.parseMethodArgs(dvmMethod, classes, args, varArg, clazz.getClassLoader());
        if (dvmMethod.member != null) {
            return new ProxyMethod(visitor, dvmMethod.member, args.toArray());
        }
        Class[] types = classes.toArray(new Class[0]);
        Member method = ProxyUtils.matchMethodTypes(clazz, dvmMethod.getMethodName(), types, isStatic);
        dvmMethod.setMember(method);
        return new ProxyMethod(visitor, method, args.toArray());
    }

    static ProxyCall findMethod(Class<?> clazz, DvmMethod dvmMethod, VaList vaList, boolean isStatic, ProxyDvmObjectVisitor visitor) throws NoSuchMethodException {
        ArrayList classes = new ArrayList(10);
        ArrayList<Object> args = new ArrayList<Object>(10);
        ProxyUtils.parseMethodArgs(dvmMethod, classes, args, vaList, clazz.getClassLoader());
        if (dvmMethod.member != null) {
            return new ProxyMethod(visitor, dvmMethod.member, args.toArray());
        }
        Class[] types = classes.toArray(new Class[0]);
        Member method = ProxyUtils.matchMethodTypes(clazz, dvmMethod.getMethodName(), types, isStatic);
        dvmMethod.setMember(method);
        return new ProxyMethod(visitor, method, args.toArray());
    }

    static Field matchField(Class<?> clazz, String fieldName, Class<?> fieldType, boolean isStatic) throws NoSuchFieldException {
        ArrayList<Object> fields = new ArrayList<Object>();
        if (isStatic) {
            for (Field field : clazz.getFields()) {
                if (!fieldName.equals(field.getName()) || !Modifier.isStatic(field.getModifiers())) continue;
                fields.add(field);
            }
        }
        for (Field field : clazz.getDeclaredFields()) {
            if (!fieldName.equals(field.getName()) || isStatic != Modifier.isStatic(field.getModifiers())) continue;
            fields.add(field);
        }
        if (!isStatic) {
            for (Field field : clazz.getDeclaredFields()) {
                if (!fieldName.equals(field.getName()) || !Modifier.isStatic(field.getModifiers())) continue;
                fields.add(field);
            }
        }
        for (Field noSuchFieldException : fields) {
            if (!ProxyUtils.matchesTypes(new Class[]{noSuchFieldException.getType()}, new Class[]{fieldType}, true)) continue;
            return noSuchFieldException;
        }
        for (Field field : fields) {
            if (!ProxyUtils.matchesTypes(new Class[]{field.getType()}, new Class[]{fieldType}, false)) continue;
            return field;
        }
        Class<?> parentClass = clazz.getSuperclass();
        if (!isStatic && parentClass != null) {
            try {
                return ProxyUtils.matchField(parentClass, fieldName, fieldType, false);
            }
            catch (NoSuchFieldException noSuchFieldException) {
                // empty catch block
            }
        }
        throw new NoSuchFieldException(clazz.getName() + "." + fieldName + ":" + fieldType);
    }

    static ProxyField findField(Class<?> clazz, DvmField dvmField, ProxyDvmObjectVisitor visitor) throws NoSuchFieldException {
        if (dvmField.filed != null) {
            return new ProxyField(visitor, dvmField.filed);
        }
        Shorty shorty = dvmField.decodeShorty();
        Field field = ProxyUtils.matchField(clazz, dvmField.getFieldName(), shorty.decodeType(clazz.getClassLoader()), dvmField.isStatic());
        dvmField.setFiled(field);
        return new ProxyField(visitor, field);
    }
}

