/*
 * Decompiled with CFR 0.152.
 */
package com.github.unidbg.linux.file;

import com.github.unidbg.Emulator;
import com.github.unidbg.arm.backend.Backend;
import com.github.unidbg.file.FileIO;
import com.github.unidbg.file.linux.StatStructure;
import com.github.unidbg.linux.file.DnsProxyDaemon;
import com.github.unidbg.linux.file.SocketIO;
import com.github.unidbg.utils.Inspector;
import com.sun.jna.Pointer;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class LocalSocketIO
extends SocketIO
implements FileIO {
    private static final Log log = LogFactory.getLog(LocalSocketIO.class);
    private final Emulator<?> emulator;
    private final int sdk;
    private byte[] response;
    private SocketHandler handler;

    public LocalSocketIO(Emulator<?> emulator, int sdk) {
        this.emulator = emulator;
        this.sdk = sdk;
    }

    public void close() {
        this.response = null;
        this.handler = null;
    }

    public int write(byte[] data) {
        try {
            byte[] response = this.handler.handle(data);
            if (response != null) {
                this.response = response;
            }
            return data.length;
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    public int read(Backend backend, Pointer buffer, int count) {
        if (this.response == null) {
            throw new IllegalStateException("response is null");
        }
        if (this.response.length <= count) {
            buffer.write(0L, this.response, 0, this.response.length);
            int ret = this.response.length;
            this.response = null;
            return ret;
        }
        buffer.write(0L, Arrays.copyOf(this.response, count), 0, count);
        byte[] temp = new byte[this.response.length - count];
        System.arraycopy(this.response, count, temp, 0, temp.length);
        this.response = temp;
        return count;
    }

    @Override
    public int fstat(Emulator<?> emulator, StatStructure stat) {
        return this.handler.fstat(stat);
    }

    @Override
    protected InetSocketAddress getLocalSocketAddress() {
        throw new AbstractMethodError();
    }

    protected SocketHandler resolveHandler(String path) {
        if ("/dev/socket/dnsproxyd".equals(path)) {
            return new DnsProxyDaemon(this.sdk);
        }
        return null;
    }

    @Override
    public final int connect(Pointer addr, int addrlen) {
        short sa_family = addr.getShort(0L);
        if (sa_family != 1) {
            throw new UnsupportedOperationException("sa_family=" + sa_family);
        }
        String path = new String(addr.getByteArray(2L, addrlen - 2), StandardCharsets.UTF_8).trim();
        if (log.isDebugEnabled()) {
            log.debug((Object)("connect sa_family=" + sa_family + ", path=" + path));
        }
        this.handler = this.resolveHandler(path);
        if (this.handler != null) {
            return 0;
        }
        this.emulator.getMemory().setErrno(1);
        return -1;
    }

    @Override
    public int bind(Pointer addr, int addrlen) {
        if (log.isDebugEnabled()) {
            log.debug((Object)Inspector.inspectString((byte[])addr.getByteArray(0L, addrlen), (String)("bind addrlen=" + addrlen)));
        }
        this.emulator.getMemory().setErrno(1);
        return -1;
    }

    @Override
    protected int connect_ipv6(Pointer addr, int addrlen) {
        throw new AbstractMethodError();
    }

    @Override
    protected int connect_ipv4(Pointer addr, int addrlen) {
        throw new AbstractMethodError();
    }

    @Override
    protected void setReuseAddress(int reuseAddress) {
    }

    @Override
    protected void setKeepAlive(int keepAlive) {
        throw new AbstractMethodError();
    }

    @Override
    protected void setSendBufferSize(int size) {
        throw new AbstractMethodError();
    }

    @Override
    protected void setReceiveBufferSize(int size) {
        throw new AbstractMethodError();
    }

    @Override
    protected void setTcpNoDelay(int tcpNoDelay) {
        throw new AbstractMethodError();
    }

    @Override
    protected int getTcpNoDelay() {
        throw new AbstractMethodError();
    }

    public static interface SocketHandler {
        public byte[] handle(byte[] var1) throws IOException;

        public int fstat(StatStructure var1);
    }
}

