/*
 * Decompiled with CFR 0.152.
 */
package com.github.unidbg.linux.file;

import com.github.unidbg.Emulator;
import com.github.unidbg.arm.backend.Backend;
import com.github.unidbg.file.FileIO;
import com.github.unidbg.linux.file.NetworkIF;
import com.github.unidbg.linux.file.SocketIO;
import com.sun.jna.Pointer;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.List;

public class NetLinkSocket
extends SocketIO
implements FileIO {
    private static final short RTM_NEWADDR = 20;
    private static final short RTM_GETADDR = 22;
    private final Emulator<?> emulator;
    private short netlinkType;
    private short netlinkFlags;
    private int netlinkSeq;
    private static final short NLM_F_REQUEST = 1;
    private static final short NLM_F_MULTI = 2;
    private static final short NLM_F_MATCH = 512;

    public NetLinkSocket(Emulator<?> emulator) {
        this.emulator = emulator;
    }

    public int write(byte[] data) {
        ByteBuffer buffer = ByteBuffer.wrap(data);
        buffer.order(ByteOrder.LITTLE_ENDIAN);
        int size = buffer.getInt();
        if (size - 4 > buffer.remaining()) {
            throw new IllegalStateException("remaining=" + buffer.remaining() + ", size=" + size);
        }
        byte[] tmp = new byte[size - 4];
        buffer.get(tmp);
        buffer = ByteBuffer.wrap(tmp);
        buffer.order(ByteOrder.LITTLE_ENDIAN);
        this.netlinkType = buffer.getShort();
        this.netlinkFlags = buffer.getShort();
        this.netlinkSeq = buffer.getInt();
        return size;
    }

    public int read(Backend backend, Pointer buffer, int count) {
        if (this.netlinkType == -1) {
            return -1;
        }
        return this.handleType(buffer, count, this.netlinkType);
    }

    protected int handleType(Pointer buffer, int count, short netlinkType) {
        if (netlinkType == 22 && this.netlinkFlags == 513) {
            try {
                List<NetworkIF> list = this.getNetworkIFs(this.emulator);
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                ByteBuffer bb = ByteBuffer.allocate(1024);
                bb.order(ByteOrder.LITTLE_ENDIAN);
                for (NetworkIF networkIF : list) {
                    int align;
                    bb.putInt(0);
                    bb.putShort((short)20);
                    bb.putShort((short)2);
                    bb.putInt(this.netlinkSeq);
                    bb.putInt(this.emulator.getPid());
                    bb.put((byte)2);
                    bb.put((byte)8);
                    bb.put((byte)IFF_NOARP);
                    bb.put((byte)-2);
                    bb.putInt(networkIF.index);
                    boolean IFA_ADDRESS = true;
                    bb.putShort((short)8);
                    bb.putShort((short)1);
                    bb.put(networkIF.ipv4.getAddress());
                    int IFA_LOCAL = 2;
                    bb.putShort((short)8);
                    bb.putShort((short)2);
                    bb.put(networkIF.ipv4.getAddress());
                    if (networkIF.broadcast != null) {
                        int IFA_BROADCAST = 4;
                        bb.putShort((short)8);
                        bb.putShort((short)4);
                        bb.put(networkIF.broadcast.getAddress());
                    }
                    int IFA_LABEL = 3;
                    byte[] label = networkIF.ifName.getBytes(StandardCharsets.UTF_8);
                    int label_len = label.length + 5;
                    bb.putShort((short)label_len);
                    bb.putShort((short)3);
                    bb.put(Arrays.copyOf(label, label.length + 1));
                    for (int m = align = label_len % 4; align > 0 && m < 4; ++m) {
                        bb.put((byte)0);
                    }
                    int __IFA_MAX = 8;
                    bb.putShort((short)8);
                    bb.putShort((short)8);
                    bb.putInt(128);
                    int IFA_CACHEINFO = 6;
                    bb.putShort((short)20);
                    bb.putShort((short)6);
                    bb.putInt(-1);
                    bb.putInt(-1);
                    bb.putInt(100);
                    bb.putInt(200);
                    bb.flip();
                    int nlmsg_len = bb.remaining();
                    bb.putInt(nlmsg_len);
                    baos.write(bb.array(), 0, nlmsg_len);
                    bb.clear();
                }
                byte[] response = baos.toByteArray();
                if (count >= response.length) {
                    buffer.write(0L, response, 0, response.length);
                    this.netlinkType = (short)-1;
                    return response.length;
                }
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
        }
        throw new UnsupportedOperationException("buffer=" + buffer + ", count=" + count + ", netlinkType=0x" + Integer.toHexString(netlinkType));
    }

    @Override
    protected int getTcpNoDelay() {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    @Override
    protected void setTcpNoDelay(int tcpNoDelay) {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    @Override
    protected void setReuseAddress(int reuseAddress) {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    @Override
    protected void setKeepAlive(int keepAlive) {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    @Override
    protected void setSendBufferSize(int size) {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    @Override
    protected void setReceiveBufferSize(int size) {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    @Override
    protected InetSocketAddress getLocalSocketAddress() {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    @Override
    protected int connect_ipv6(Pointer addr, int addrlen) {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    @Override
    protected int connect_ipv4(Pointer addr, int addrlen) {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    public void close() {
        this.netlinkType = 0;
        this.netlinkFlags = 0;
    }
}

