/*
 * Decompiled with CFR 0.152.
 */
package com.github.unidbg.linux.signal;

import com.github.unidbg.AbstractEmulator;
import com.github.unidbg.Emulator;
import com.github.unidbg.arm.backend.Backend;
import com.github.unidbg.linux.signal.SigAction;
import com.github.unidbg.memory.MemoryBlock;
import com.github.unidbg.pointer.UnidbgPointer;
import com.github.unidbg.signal.AbstractSignalTask;
import com.github.unidbg.signal.SigSet;
import com.github.unidbg.signal.SignalOps;
import com.github.unidbg.signal.UnixSigSet;
import com.sun.jna.Pointer;

public class SignalTask
extends AbstractSignalTask {
    private final SigAction action;
    private Pointer sig_info;
    private UnidbgPointer stack;
    private MemoryBlock infoBlock;

    public SignalTask(int signum, SigAction action) {
        this(signum, action, null);
    }

    public SignalTask(int signum, SigAction action, Pointer sig_info) {
        super(signum);
        this.action = action;
        this.sig_info = sig_info;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Number callHandler(SignalOps signalOps, AbstractEmulator<?> emulator) {
        SigSet sigSet = signalOps.getSigMaskSet();
        try {
            Number number;
            long sa_mask = this.action.getMask();
            if (sigSet == null) {
                UnixSigSet newSigSet = new UnixSigSet(sa_mask);
                signalOps.setSigMaskSet((SigSet)newSigSet);
            } else {
                sigSet.blockSigSet(sa_mask);
            }
            if (this.isContextSaved()) {
                number = this.continueRun(emulator, emulator.getReturnAddress());
                return number;
            }
            number = this.runHandler(emulator);
            return number;
        }
        finally {
            signalOps.setSigMaskSet(sigSet);
        }
    }

    private Number runHandler(AbstractEmulator<?> emulator) {
        Backend backend = emulator.getBackend();
        if (this.stack == null) {
            this.stack = this.allocateStack((Emulator)emulator);
        }
        if (this.action.needSigInfo() && this.infoBlock == null && this.sig_info == null) {
            this.infoBlock = emulator.getMemory().malloc(128, true);
            this.infoBlock.getPointer().setInt(0L, this.signum);
            this.sig_info = this.infoBlock.getPointer();
        }
        if (emulator.is32Bit()) {
            backend.reg_write(12, (Number)this.stack.peer);
            backend.reg_write(66, (Number)this.signum);
            backend.reg_write(67, (Number)(this.sig_info == null ? 0L : UnidbgPointer.nativeValue((Pointer)this.sig_info)));
            backend.reg_write(68, (Number)0);
            backend.reg_write(10, (Number)emulator.getReturnAddress());
        } else {
            backend.reg_write(4, (Number)this.stack.peer);
            backend.reg_write(199, (Number)this.signum);
            backend.reg_write(200, (Number)(this.sig_info == null ? 0L : UnidbgPointer.nativeValue((Pointer)this.sig_info)));
            backend.reg_write(201, (Number)0);
            backend.reg_write(2, (Number)emulator.getReturnAddress());
        }
        return emulator.emulate(this.action.getSaHandler(), emulator.getReturnAddress());
    }

    public String toString() {
        return "SignalTask sa_handler=" + this.action.getSaHandler() + ", stack=" + this.stack + ", signum=" + this.signum;
    }

    public void destroy(Emulator<?> emulator) {
        super.destroy(emulator);
        if (this.infoBlock != null) {
            this.infoBlock.free();
            this.infoBlock = null;
        }
    }
}

