/*
 * Decompiled with CFR 0.152.
 */
package com.github.unidbg.linux.thread;

import com.github.unidbg.Emulator;
import com.github.unidbg.arm.Arm64Svc;
import com.github.unidbg.arm.backend.Backend;
import com.github.unidbg.arm.context.RegisterContext;
import com.github.unidbg.memory.SvcMemory;
import com.github.unidbg.pointer.UnidbgPointer;
import com.github.unidbg.unix.ThreadJoinVisitor;
import com.sun.jna.Pointer;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicLong;
import keystone.Keystone;
import keystone.KeystoneArchitecture;
import keystone.KeystoneEncoded;
import keystone.KeystoneMode;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

class ClonePatcher64
extends Arm64Svc {
    private static final Log log = LogFactory.getLog(ClonePatcher64.class);
    private final ThreadJoinVisitor visitor;
    private final AtomicLong value_ptr;
    private int threadId;

    public ClonePatcher64(ThreadJoinVisitor visitor, AtomicLong value_ptr) {
        this.visitor = visitor;
        this.value_ptr = value_ptr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long handle(Emulator<?> emulator) {
        RegisterContext context = emulator.getContext();
        UnidbgPointer pthread_start = context.getPointerArg(0);
        UnidbgPointer child_stack = context.getPointerArg(1);
        int flags = context.getIntArg(2);
        UnidbgPointer thread = context.getPointerArg(3);
        Pointer start_routine = thread.getPointer(96L);
        Pointer arg = thread.getPointer(104L);
        log.info((Object)("clone start_routine=" + start_routine + ", child_stack=" + child_stack + ", flags=0x" + Integer.toHexString(flags) + ", arg=" + arg + ", pthread_start=" + pthread_start));
        Backend backend = emulator.getBackend();
        boolean join = this.visitor == null || this.visitor.canJoin(start_routine, ++this.threadId);
        UnidbgPointer pointer = UnidbgPointer.register(emulator, (int)4);
        try {
            pointer = pointer.share(-8L, 0L);
            pointer.setLong(0L, (long)this.threadId);
            if (join) {
                pointer = pointer.share(-8L, 0L);
                pointer.setPointer(0L, start_routine);
                pointer = pointer.share(-8L, 0L);
                pointer.setPointer(0L, arg);
            }
            pointer = pointer.share(-8L, 0L);
            pointer.setLong(0L, join ? 1L : 0L);
        }
        finally {
            backend.reg_write(4, (Number)pointer.peer);
        }
        return 0L;
    }

    public UnidbgPointer onRegister(SvcMemory svcMemory, int svcNumber) {
        try (Keystone keystone = new Keystone(KeystoneArchitecture.Arm64, KeystoneMode.LittleEndian);){
            KeystoneEncoded encoded = keystone.assemble(Arrays.asList("sub sp, sp, #0x10", "stp x29, x30, [sp]", "svc #0x" + Integer.toHexString(svcNumber), "ldr x13, [sp]", "add sp, sp, #0x8", "cmp x13, #0", "b.eq #0x48", "ldp x0, x13, [sp]", "add sp, sp, #0x10", "mov x8, #0", "mov x12, #0x" + Integer.toHexString(svcNumber), "mov x16, #0x" + Integer.toHexString(34918), "svc #0", "blr x13", "mov x8, #0", "mov x12, #0x" + Integer.toHexString(svcNumber), "mov x16, #0x" + Integer.toHexString(34952), "svc #0", "ldr x0, [sp]", "add sp, sp, #0x8", "ldp x29, x30, [sp]", "add sp, sp, #0x10", "ret"));
            byte[] code = encoded.getMachineCode();
            UnidbgPointer pointer = svcMemory.allocate(code.length, ((Object)((Object)this)).getClass().getSimpleName());
            pointer.write(code);
            UnidbgPointer unidbgPointer = pointer;
            return unidbgPointer;
        }
    }

    public void handlePreCallback(Emulator<?> emulator) {
        if (this.visitor.isSaveContext()) {
            emulator.pushContext(4);
        }
    }

    public void handlePostCallback(Emulator<?> emulator) {
        super.handlePostCallback(emulator);
        this.value_ptr.set(emulator.getContext().getLongArg(0));
    }
}

