/*
 * Decompiled with CFR 0.152.
 */
package com.github.unidbg.linux.thread;

import com.github.unidbg.AbstractEmulator;
import com.github.unidbg.Emulator;
import com.github.unidbg.arm.backend.Backend;
import com.github.unidbg.pointer.UnidbgPointer;
import com.github.unidbg.thread.ThreadTask;
import com.sun.jna.Pointer;

public class MarshmallowThread
extends ThreadTask {
    private final UnidbgPointer fn;
    private final UnidbgPointer thread;
    private Pointer errno;
    private Pointer tidptr;

    public MarshmallowThread(Emulator<?> emulator, UnidbgPointer fn, UnidbgPointer thread, Pointer tidptr, int tid) {
        super(tid, emulator.getReturnAddress());
        this.fn = fn;
        this.thread = thread;
        this.tidptr = tidptr;
    }

    public void setExitStatus(int status) {
        super.setExitStatus(status);
        if (this.tidptr != null) {
            this.tidptr.setInt(0L, 0);
        }
    }

    public boolean setErrno(Emulator<?> emulator, int errno) {
        if (this.errno != null) {
            this.errno.setInt(0L, errno);
            return true;
        }
        return super.setErrno(emulator, errno);
    }

    public String toString() {
        return "MarshmallowThread fn=" + this.fn + ", arg=" + this.thread;
    }

    protected Number runThread(AbstractEmulator<?> emulator) {
        Backend backend = emulator.getBackend();
        UnidbgPointer stack = this.allocateStack((Emulator)emulator);
        if (emulator.is32Bit()) {
            Pointer tls = this.thread.share(72L);
            this.errno = tls.share(8L);
            backend.reg_write(66, (Number)UnidbgPointer.nativeValue((Pointer)this.thread));
            backend.reg_write(12, (Number)stack.peer);
            backend.reg_write(113, (Number)UnidbgPointer.nativeValue((Pointer)tls));
            backend.reg_write(10, (Number)this.until);
        } else {
            Pointer tls = this.thread.share(176L);
            this.errno = tls.share(16L);
            backend.reg_write(199, (Number)UnidbgPointer.nativeValue((Pointer)this.thread));
            backend.reg_write(4, (Number)stack.peer);
            backend.reg_write(262, (Number)UnidbgPointer.nativeValue((Pointer)tls));
            backend.reg_write(2, (Number)this.until);
        }
        return emulator.emulate(this.fn.peer, this.until);
    }

    public void set_tid_address(Pointer tidptr) {
        this.tidptr = tidptr;
    }
}

