/*
 * Decompiled with CFR 0.152.
 */
package com.github.unidbg.linux.android;

import com.github.unidbg.Emulator;
import com.github.unidbg.linux.LinuxModule;
import com.github.unidbg.unwind.Frame;
import com.github.unidbg.unwind.SimpleARM64Unwinder;
import com.github.unidbg.unwind.Unwinder;
import java.io.IOException;
import net.fornwall.jelf.DwarfCursor;
import net.fornwall.jelf.DwarfCursor64;
import net.fornwall.jelf.GnuEhFrameHeader;
import net.fornwall.jelf.MemoizedObject;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

class AndroidARM64Unwinder
extends SimpleARM64Unwinder {
    private static final Log log = LogFactory.getLog(AndroidARM64Unwinder.class);
    private final DwarfCursor context;

    public AndroidARM64Unwinder(Emulator<?> emulator) {
        super(emulator);
        this.context = new DwarfCursor64(emulator);
    }

    protected Frame unw_step(Emulator<?> emulator, Frame frame) {
        try {
            MemoizedObject<GnuEhFrameHeader> ehFrameHeader;
            LinuxModule module = (LinuxModule)emulator.getMemory().findModuleByAddress(this.context.ip);
            MemoizedObject<GnuEhFrameHeader> memoizedObject = ehFrameHeader = module == null ? null : module.ehFrameHeader;
            if (ehFrameHeader != null) {
                Frame ret;
                long fun = this.context.ip - module.base;
                GnuEhFrameHeader frameHeader = ehFrameHeader.getValue();
                Frame frame2 = ret = frameHeader == null ? null : frameHeader.dwarf_step(emulator, (Unwinder)this, module, fun, this.context);
                if (ret != null) {
                    return ret;
                }
            }
        }
        catch (RuntimeException exception) {
            log.warn((Object)"unw_step", (Throwable)exception);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        return super.unw_step(emulator, frame);
    }
}

