/*
 * Decompiled with CFR 0.152.
 */
package com.github.unidbg.linux.android;

import com.github.unidbg.Emulator;
import com.github.unidbg.Svc;
import com.github.unidbg.arm.Arm64Hook;
import com.github.unidbg.arm.ArmHook;
import com.github.unidbg.arm.HookStatus;
import com.github.unidbg.arm.backend.BackendException;
import com.github.unidbg.arm.context.EditableArm64RegisterContext;
import com.github.unidbg.arm.context.RegisterContext;
import com.github.unidbg.hook.HookListener;
import com.github.unidbg.linux.android.SystemPropertyProvider;
import com.github.unidbg.memory.SvcMemory;
import com.github.unidbg.pointer.UnidbgPointer;
import com.sun.jna.Pointer;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SystemPropertyHook
implements HookListener {
    private static final Logger log = LoggerFactory.getLogger(SystemPropertyHook.class);
    public static final int PROP_VALUE_MAX = 92;
    private final Emulator<?> emulator;
    private SystemPropertyProvider propertyProvider;

    public SystemPropertyHook(Emulator<?> emulator) {
        this.emulator = emulator;
    }

    public long hook(SvcMemory svcMemory, String libraryName, String symbolName, final long old) {
        if ("libc.so".equals(libraryName)) {
            if ("__system_property_get".equals(symbolName)) {
                log.debug("Hook {}", (Object)symbolName);
                if (this.emulator.is64Bit()) {
                    return svcMemory.registerSvc((Svc)new Arm64Hook(){

                        protected HookStatus hook(Emulator<?> emulator) {
                            RegisterContext context = emulator.getContext();
                            int index = 0;
                            UnidbgPointer pointer = context.getPointerArg(index);
                            String key = pointer.getString(0L);
                            return SystemPropertyHook.this.__system_property_get(old, key, index);
                        }
                    }).peer;
                }
                return svcMemory.registerSvc((Svc)new ArmHook(){

                    protected HookStatus hook(Emulator<?> emulator) {
                        RegisterContext context = emulator.getContext();
                        int index = 0;
                        UnidbgPointer pointer = context.getPointerArg(index);
                        String key = pointer.getString(0L);
                        return SystemPropertyHook.this.__system_property_get(old, key, index);
                    }
                }).peer;
            }
            if ("__system_property_read".equals(symbolName)) {
                log.debug("Hook {}", (Object)symbolName);
                if (this.emulator.is64Bit()) {
                    return svcMemory.registerSvc((Svc)new Arm64Hook(){

                        protected HookStatus hook(Emulator<?> emulator) {
                            RegisterContext context = emulator.getContext();
                            UnidbgPointer pi = context.getPointerArg(0);
                            String key = pi.share(96L).getString(0L);
                            return SystemPropertyHook.this.__system_property_get(old, key, 1);
                        }
                    }).peer;
                }
                return svcMemory.registerSvc((Svc)new ArmHook(){

                    protected HookStatus hook(Emulator<?> emulator) {
                        RegisterContext context = emulator.getContext();
                        UnidbgPointer pi = context.getPointerArg(0);
                        String key = pi.share(96L).getString(0L);
                        return SystemPropertyHook.this.__system_property_get(old, key, 1);
                    }
                }).peer;
            }
            if ("__system_property_find".equals(symbolName)) {
                log.debug("Hook {}", (Object)symbolName);
                if (this.emulator.is64Bit()) {
                    return svcMemory.registerSvc((Svc)new Arm64Hook((boolean)true){
                        private String name;

                        protected HookStatus hook(Emulator<?> emulator) {
                            RegisterContext context = emulator.getContext();
                            UnidbgPointer name = context.getPointerArg(0);
                            this.name = name.getString(0L);
                            if (log.isDebugEnabled()) {
                                log.debug("__system_property_find key={}, LR={}", (Object)this.name, (Object)context.getLRPointer());
                            }
                            if (log.isTraceEnabled()) {
                                emulator.attach().debug();
                            }
                            return HookStatus.RET(emulator, (long)old);
                        }

                        public void handlePostCallback(Emulator<?> emulator) {
                            Pointer replace;
                            super.handlePostCallback(emulator);
                            EditableArm64RegisterContext context = (EditableArm64RegisterContext)emulator.getContext();
                            UnidbgPointer pi = context.getPointerArg(0);
                            if (log.isDebugEnabled()) {
                                log.debug("__system_property_find key={}, pi={}, value={}", new Object[]{this.name, pi, pi == null ? null : pi.share(4L).getString(0L)});
                            }
                            if (SystemPropertyHook.this.propertyProvider != null && (replace = SystemPropertyHook.this.propertyProvider.__system_property_find(this.name)) != null) {
                                context.setXLong(0, UnidbgPointer.nativeValue((Pointer)replace));
                            }
                        }
                    }).peer;
                }
                return svcMemory.registerSvc((Svc)new ArmHook(){

                    protected HookStatus hook(Emulator<?> emulator) {
                        RegisterContext context = emulator.getContext();
                        UnidbgPointer name = context.getPointerArg(0);
                        if (log.isDebugEnabled()) {
                            log.debug("__system_property_find key={}, LR={}", (Object)name.getString(0L), (Object)context.getLRPointer());
                        }
                        if (log.isTraceEnabled()) {
                            emulator.attach().debug();
                        }
                        return HookStatus.RET(emulator, (long)old);
                    }
                }).peer;
            }
        }
        return 0L;
    }

    private HookStatus __system_property_get(long old, String key, int index) {
        String value;
        RegisterContext context = this.emulator.getContext();
        if (this.propertyProvider != null && (value = this.propertyProvider.getProperty(key)) != null) {
            log.debug("__system_property_get key={}, value={}", (Object)key, (Object)value);
            byte[] data = value.getBytes(StandardCharsets.UTF_8);
            if (data.length >= 92) {
                throw new BackendException("invalid property value length: key=" + key + ", value=" + value);
            }
            byte[] newData = Arrays.copyOf(data, data.length + 1);
            UnidbgPointer pointer = context.getPointerArg(index + 1);
            pointer.write(0L, newData, 0, newData.length);
            return HookStatus.LR(this.emulator, (long)data.length);
        }
        log.debug("__system_property_get key={}", (Object)key);
        return HookStatus.RET(this.emulator, (long)old);
    }

    public void setPropertyProvider(SystemPropertyProvider propertyProvider) {
        this.propertyProvider = propertyProvider;
    }
}

