/*
 * Decompiled with CFR 0.152.
 */
package com.github.unidbg.linux.android.dvm;

import com.github.unidbg.Emulator;
import com.github.unidbg.Module;
import com.github.unidbg.Symbol;
import com.github.unidbg.linux.android.dvm.BaseVM;
import com.github.unidbg.linux.android.dvm.DvmField;
import com.github.unidbg.linux.android.dvm.DvmMethod;
import com.github.unidbg.linux.android.dvm.DvmObject;
import com.github.unidbg.linux.android.dvm.Jni;
import com.github.unidbg.linux.android.dvm.JniFunction;
import com.github.unidbg.pointer.UnidbgPointer;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DvmClass
extends DvmObject<Class<?>> {
    private static final Log log = LogFactory.getLog(DvmClass.class);
    private static final String ROOT_CLASS = "java/lang/Class";
    public final BaseVM vm;
    private final DvmClass superClass;
    private final DvmClass[] interfaceClasses;
    private final String className;
    private final Map<Integer, DvmMethod> staticMethodMap = new HashMap<Integer, DvmMethod>();
    private final Map<Integer, DvmMethod> methodMap = new HashMap<Integer, DvmMethod>();
    private final Map<Integer, DvmField> fieldMap = new HashMap<Integer, DvmField>();
    private final Map<Integer, DvmField> staticFieldMap = new HashMap<Integer, DvmField>();
    final Map<String, UnidbgPointer> nativesMap = new HashMap<String, UnidbgPointer>();
    private JniFunction jni;

    protected DvmClass(BaseVM vm, String className, DvmClass superClass, DvmClass[] interfaceClasses) {
        this(vm, className, superClass, interfaceClasses, null);
    }

    protected DvmClass(BaseVM vm, String className, DvmClass superClass, DvmClass[] interfaceClasses, Class<?> value) {
        super(ROOT_CLASS.equals(className) ? null : vm.resolveClass(ROOT_CLASS, new DvmClass[0]), value);
        this.vm = vm;
        this.superClass = superClass;
        this.interfaceClasses = interfaceClasses;
        this.className = className;
    }

    public DvmClass getSuperclass() {
        return this.superClass;
    }

    public DvmClass[] getInterfaces() {
        return this.interfaceClasses;
    }

    @Override
    public DvmClass getObjectType() {
        if (ROOT_CLASS.equals(this.className)) {
            return this;
        }
        return super.getObjectType();
    }

    public String getClassName() {
        return this.className;
    }

    public String getName() {
        return this.className.replace('/', '.');
    }

    public DvmObject<?> newObject(Object value) {
        return new DvmObject<Object>(this, value);
    }

    DvmObject<?> allocObject() {
        String signature = this.getClassName() + "->allocObject";
        if (log.isDebugEnabled()) {
            log.debug((Object)("allocObject signature=" + signature));
        }
        BaseVM vm = this.vm;
        return this.checkJni(vm, this).allocObject(vm, this, signature);
    }

    final DvmMethod getStaticMethod(int hash) {
        DvmMethod method = this.staticMethodMap.get(hash);
        if (method == null && this.superClass != null) {
            method = this.superClass.getStaticMethod(hash);
        }
        if (method == null) {
            DvmClass interfaceClass;
            DvmClass[] dvmClassArray = this.interfaceClasses;
            int n = dvmClassArray.length;
            for (int i = 0; i < n && (method = (interfaceClass = dvmClassArray[i]).getStaticMethod(hash)) == null; ++i) {
            }
        }
        return method;
    }

    int getStaticMethodID(String methodName, String args) {
        String signature = this.getClassName() + "->" + methodName + args;
        int hash = signature.hashCode();
        if (log.isDebugEnabled()) {
            log.debug((Object)("getStaticMethodID signature=" + signature + ", hash=0x" + Long.toHexString(hash)));
        }
        if (this.checkJni(this.vm, this).acceptMethod(this, signature, true)) {
            if (!this.staticMethodMap.containsKey(hash)) {
                this.staticMethodMap.put(hash, new DvmMethod(this, methodName, args, true));
            }
            return hash;
        }
        return 0;
    }

    final DvmMethod getMethod(int hash) {
        DvmMethod method = this.methodMap.get(hash);
        if (method == null && this.superClass != null) {
            method = this.superClass.getMethod(hash);
        }
        if (method == null) {
            DvmClass interfaceClass;
            DvmClass[] dvmClassArray = this.interfaceClasses;
            int n = dvmClassArray.length;
            for (int i = 0; i < n && (method = (interfaceClass = dvmClassArray[i]).getMethod(hash)) == null; ++i) {
            }
        }
        return method;
    }

    int getMethodID(String methodName, String args) {
        String signature = this.getClassName() + "->" + methodName + args;
        int hash = signature.hashCode();
        if (log.isDebugEnabled()) {
            log.debug((Object)("getMethodID signature=" + signature + ", hash=0x" + Long.toHexString(hash)));
        }
        if (this.vm.jni == null || this.vm.jni.acceptMethod(this, signature, false)) {
            if (!this.methodMap.containsKey(hash)) {
                this.methodMap.put(hash, new DvmMethod(this, methodName, args, false));
            }
            return hash;
        }
        return 0;
    }

    final DvmField getField(int hash) {
        DvmField field = this.fieldMap.get(hash);
        if (field == null && this.superClass != null) {
            field = this.superClass.getField(hash);
        }
        if (field == null) {
            DvmClass interfaceClass;
            DvmClass[] dvmClassArray = this.interfaceClasses;
            int n = dvmClassArray.length;
            for (int i = 0; i < n && (field = (interfaceClass = dvmClassArray[i]).getField(hash)) == null; ++i) {
            }
        }
        return field;
    }

    int getFieldID(String fieldName, String fieldType) {
        String signature = this.getClassName() + "->" + fieldName + ":" + fieldType;
        int hash = signature.hashCode();
        if (log.isDebugEnabled()) {
            log.debug((Object)("getFieldID signature=" + signature + ", hash=0x" + Long.toHexString(hash)));
        }
        if (this.vm.jni == null || this.vm.jni.acceptField(this, signature, false)) {
            if (!this.fieldMap.containsKey(hash)) {
                this.fieldMap.put(hash, new DvmField(this, fieldName, fieldType, false));
            }
            return hash;
        }
        return 0;
    }

    final DvmField getStaticField(int hash) {
        DvmField field = this.staticFieldMap.get(hash);
        if (field == null && this.superClass != null) {
            field = this.superClass.getStaticField(hash);
        }
        if (field == null) {
            DvmClass interfaceClass;
            DvmClass[] dvmClassArray = this.interfaceClasses;
            int n = dvmClassArray.length;
            for (int i = 0; i < n && (field = (interfaceClass = dvmClassArray[i]).getStaticField(hash)) == null; ++i) {
            }
        }
        return field;
    }

    int getStaticFieldID(String fieldName, String fieldType) {
        String signature = this.getClassName() + "->" + fieldName + ":" + fieldType;
        int hash = signature.hashCode();
        if (log.isDebugEnabled()) {
            log.debug((Object)("getStaticFieldID signature=" + signature + ", hash=0x" + Long.toHexString(hash)));
        }
        if (this.vm.jni == null || this.vm.jni.acceptField(this, signature, true)) {
            if (!this.staticFieldMap.containsKey(hash)) {
                this.staticFieldMap.put(hash, new DvmField(this, fieldName, fieldType, true));
            }
            return hash;
        }
        return 0;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DvmClass dvmClass = (DvmClass)o;
        return Objects.equals(this.getClassName(), dvmClass.getClassName());
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.getClassName());
    }

    @Override
    public String toString() {
        return "class " + this.getClassName();
    }

    public final UnidbgPointer findNativeFunction(Emulator<?> emulator, String method) {
        UnidbgPointer fnPtr = this.nativesMap.get(method);
        int index = method.indexOf(40);
        if (fnPtr == null && index == -1) {
            index = method.length();
        }
        StringBuilder builder = new StringBuilder();
        builder.append("Java_");
        DvmClass.mangleForJni(builder, this.getClassName());
        builder.append("_");
        DvmClass.mangleForJni(builder, method.substring(0, index));
        String symbolName = builder.toString();
        if (fnPtr == null) {
            for (Module module : emulator.getMemory().getLoadedModules()) {
                Symbol symbol = module.findSymbolByName(symbolName, false);
                if (symbol == null) continue;
                fnPtr = (UnidbgPointer)symbol.createPointer(emulator);
                break;
            }
        }
        if (fnPtr == null) {
            throw new IllegalArgumentException("find method failed: " + method);
        }
        if (this.vm.verbose) {
            System.out.printf("Find native function %s => %s%n", symbolName, fnPtr);
        }
        return fnPtr;
    }

    private static void mangleForJni(StringBuilder builder, String name) {
        char[] chars;
        for (char c : chars = name.toCharArray()) {
            if (c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z' || c >= '0' && c <= '9') {
                builder.append(c);
                continue;
            }
            if (c == '.' || c == '/') {
                builder.append("_");
                continue;
            }
            if (c == '_') {
                builder.append("_1");
                continue;
            }
            if (c == ';') {
                builder.append("_2");
                continue;
            }
            if (c == '[') {
                builder.append("_3");
                continue;
            }
            builder.append(String.format("_0%04x", c & 0xFFFF));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void callStaticJniMethod(Emulator<?> emulator, String method, Object ... args) {
        try {
            DvmClass.callJniMethod(emulator, this.vm, this, this, method, args);
        }
        finally {
            this.vm.deleteLocalRefs();
        }
    }

    public boolean callStaticJniMethodBoolean(Emulator<?> emulator, String method, Object ... args) {
        return BaseVM.valueOf(this.callStaticJniMethodInt(emulator, method, args));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int callStaticJniMethodInt(Emulator<?> emulator, String method, Object ... args) {
        try {
            int n = DvmClass.callJniMethod(emulator, this.vm, this, this, method, args).intValue();
            return n;
        }
        finally {
            this.vm.deleteLocalRefs();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long callStaticJniMethodLong(Emulator<?> emulator, String method, Object ... args) {
        try {
            long l = DvmClass.callJniMethod(emulator, this.vm, this, this, method, args).longValue();
            return l;
        }
        finally {
            this.vm.deleteLocalRefs();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T extends DvmObject<?>> T callStaticJniMethodObject(Emulator<?> emulator, String method, Object ... args) {
        try {
            Number number = DvmClass.callJniMethod(emulator, this.vm, this, this, method, args);
            Object t = this.vm.getObject(number.intValue());
            return t;
        }
        finally {
            this.vm.deleteLocalRefs();
        }
    }

    final boolean isInstance(DvmClass dvmClass) {
        if (dvmClass == this) {
            return true;
        }
        for (DvmClass dc : this.interfaceClasses) {
            if (dc != dvmClass) continue;
            return true;
        }
        if (this.superClass != null) {
            return this.superClass.isInstance(dvmClass);
        }
        return false;
    }

    protected final void setJni(JniFunction jni) {
        this.jni = jni;
    }

    final Jni getJni() {
        return this.jni;
    }
}

