/*
 * Decompiled with CFR 0.152.
 */
package com.github.unidbg.linux.android.dvm;

import com.github.unidbg.linux.android.dvm.BaseVM;
import com.github.unidbg.linux.android.dvm.DvmClass;
import com.github.unidbg.linux.android.dvm.DvmObject;
import com.github.unidbg.linux.android.dvm.Hashable;
import com.github.unidbg.linux.android.dvm.Shorty;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;

public class DvmField
extends Hashable {
    private final DvmClass dvmClass;
    final String fieldName;
    final String fieldType;
    private final boolean isStatic;
    private Shorty[] shortyCache;
    public Field filed;

    DvmField(DvmClass dvmClass, String fieldName, String fieldType, boolean isStatic) {
        this.dvmClass = dvmClass;
        this.fieldName = fieldName;
        this.fieldType = fieldType;
        this.isStatic = isStatic;
    }

    public DvmClass getDvmClass() {
        return this.dvmClass;
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public String getFieldType() {
        return this.fieldType;
    }

    public boolean isStatic() {
        return this.isStatic;
    }

    final String getSignature() {
        return this.dvmClass.getClassName() + "->" + this.fieldName + ":" + this.fieldType;
    }

    public final Shorty decodeShorty() {
        if (this.shortyCache != null) {
            return this.shortyCache[0];
        }
        char[] chars = this.getFieldType().toCharArray();
        ArrayList<Shorty> list = new ArrayList<Shorty>(chars.length);
        int arrayDimensions = 0;
        boolean isType = false;
        Shorty shorty = null;
        StringBuilder binaryName = new StringBuilder();
        for (int i = 0; i < chars.length; ++i) {
            char c = chars[i];
            if (isType) {
                if (c == ';') {
                    isType = false;
                    shorty.setBinaryName(binaryName.toString());
                    binaryName.delete(0, binaryName.length());
                    continue;
                }
                binaryName.append(c);
                continue;
            }
            char type = '0';
            switch (c) {
                case 'L': {
                    isType = true;
                    type = c;
                    break;
                }
                case 'B': 
                case 'C': 
                case 'D': 
                case 'F': 
                case 'I': 
                case 'J': 
                case 'S': 
                case 'Z': {
                    type = c;
                    break;
                }
                case '[': {
                    ++arrayDimensions;
                    break;
                }
                default: {
                    throw new IllegalStateException("i=" + i + ", char=" + chars[i] + ", fieldType=" + this.fieldType);
                }
            }
            if (type == '0') continue;
            shorty = new Shorty(arrayDimensions, type);
            list.add(shorty);
            arrayDimensions = 0;
        }
        this.shortyCache = list.toArray(new Shorty[0]);
        return this.shortyCache[0];
    }

    DvmObject<?> getStaticObjectField() {
        BaseVM vm = this.dvmClass.vm;
        return this.checkJni(vm, this.dvmClass).getStaticObjectField(vm, this.dvmClass, this);
    }

    boolean getStaticBooleanField() {
        BaseVM vm = this.dvmClass.vm;
        return this.checkJni(vm, this.dvmClass).getStaticBooleanField(vm, this.dvmClass, this);
    }

    byte getStaticByteField() {
        BaseVM vm = this.dvmClass.vm;
        return this.checkJni(vm, this.dvmClass).getStaticByteField(vm, this.dvmClass, this);
    }

    int getStaticIntField() {
        BaseVM vm = this.dvmClass.vm;
        return this.checkJni(vm, this.dvmClass).getStaticIntField(vm, this.dvmClass, this);
    }

    DvmObject<?> getObjectField(DvmObject<?> dvmObject) {
        BaseVM vm = this.dvmClass.vm;
        return this.checkJni(vm, this.dvmClass).getObjectField(vm, dvmObject, this);
    }

    byte getByteField(DvmObject<?> dvmObject) {
        BaseVM vm = this.dvmClass.vm;
        return this.checkJni(vm, this.dvmClass).getByteField(vm, dvmObject, this);
    }

    int getIntField(DvmObject<?> dvmObject) {
        BaseVM vm = this.dvmClass.vm;
        return this.checkJni(vm, this.dvmClass).getIntField(vm, dvmObject, this);
    }

    long getLongField(DvmObject<?> dvmObject) {
        BaseVM vm = this.dvmClass.vm;
        return this.checkJni(vm, this.dvmClass).getLongField(vm, dvmObject, this);
    }

    float getFloatField(DvmObject<?> dvmObject) {
        BaseVM vm = this.dvmClass.vm;
        return this.checkJni(vm, this.dvmClass).getFloatField(vm, dvmObject, this);
    }

    void setObjectField(DvmObject<?> dvmObject, DvmObject<?> value) {
        BaseVM vm = this.dvmClass.vm;
        this.checkJni(vm, this.dvmClass).setObjectField(vm, dvmObject, this, value);
    }

    int getBooleanField(DvmObject<?> dvmObject) {
        BaseVM vm = this.dvmClass.vm;
        return this.checkJni(vm, this.dvmClass).getBooleanField(vm, dvmObject, this) ? 1 : 0;
    }

    void setIntField(DvmObject<?> dvmObject, int value) {
        BaseVM vm = this.dvmClass.vm;
        this.checkJni(vm, this.dvmClass).setIntField(vm, dvmObject, this, value);
    }

    void setLongField(DvmObject<?> dvmObject, long value) {
        BaseVM vm = this.dvmClass.vm;
        this.checkJni(vm, this.dvmClass).setLongField(vm, dvmObject, this, value);
    }

    void setBooleanField(DvmObject<?> dvmObject, boolean value) {
        BaseVM vm = this.dvmClass.vm;
        this.checkJni(vm, this.dvmClass).setBooleanField(vm, dvmObject, this, value);
    }

    void setFloatField(DvmObject<?> dvmObject, float value) {
        BaseVM vm = this.dvmClass.vm;
        this.checkJni(vm, this.dvmClass).setFloatField(vm, dvmObject, this, value);
    }

    void setDoubleField(DvmObject<?> dvmObject, double value) {
        BaseVM vm = this.dvmClass.vm;
        this.checkJni(vm, this.dvmClass).setDoubleField(vm, dvmObject, this, value);
    }

    void setStaticObjectField(DvmObject<?> value) {
        BaseVM vm = this.dvmClass.vm;
        this.checkJni(vm, this.dvmClass).setStaticObjectField(vm, this.dvmClass, this, value);
    }

    void setStaticBooleanField(boolean value) {
        BaseVM vm = this.dvmClass.vm;
        this.checkJni(vm, this.dvmClass).setStaticBooleanField(vm, this.dvmClass, this, value);
    }

    void setStaticIntField(int value) {
        BaseVM vm = this.dvmClass.vm;
        this.checkJni(vm, this.dvmClass).setStaticIntField(vm, this.dvmClass, this, value);
    }

    void setStaticLongField(long value) {
        BaseVM vm = this.dvmClass.vm;
        this.checkJni(vm, this.dvmClass).setStaticLongField(vm, this.dvmClass, this, value);
    }

    void setStaticFloatField(float value) {
        BaseVM vm = this.dvmClass.vm;
        this.checkJni(vm, this.dvmClass).setStaticFloatField(vm, this.dvmClass, this, value);
    }

    void setStaticDoubleField(double value) {
        BaseVM vm = this.dvmClass.vm;
        this.checkJni(vm, this.dvmClass).setStaticDoubleField(vm, this.dvmClass, this, value);
    }

    long getStaticLongField() {
        BaseVM vm = this.dvmClass.vm;
        return this.checkJni(vm, this.dvmClass).getStaticLongField(vm, this.dvmClass, this);
    }

    public void setFiled(Field filed) {
        filed.setAccessible(true);
        if (Modifier.isStatic(filed.getModifiers()) ^ this.isStatic) {
            throw new IllegalStateException(this.toString());
        }
        this.filed = filed;
    }

    public String toString() {
        return this.getSignature();
    }
}

