/*
 * Decompiled with CFR 0.152.
 */
package com.github.unidbg.linux.android.dvm;

import com.github.unidbg.linux.android.dvm.BaseVM;
import com.github.unidbg.linux.android.dvm.DvmClass;
import com.github.unidbg.linux.android.dvm.DvmObject;
import com.github.unidbg.linux.android.dvm.Hashable;
import com.github.unidbg.linux.android.dvm.Shorty;
import com.github.unidbg.linux.android.dvm.VaList;
import com.github.unidbg.linux.android.dvm.VarArg;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Member;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.UUID;

public class DvmMethod
extends Hashable {
    private final DvmClass dvmClass;
    final String methodName;
    final String args;
    final boolean isStatic;
    private Shorty[] shortyCache;
    public Member member;

    DvmMethod(DvmClass dvmClass, String methodName, String args, boolean isStatic) {
        this.dvmClass = dvmClass;
        this.methodName = methodName;
        this.args = args;
        this.isStatic = isStatic;
    }

    public boolean isConstructor() {
        return "<init>".equals(this.methodName);
    }

    public DvmClass getDvmClass() {
        return this.dvmClass;
    }

    public String getMethodName() {
        if (UUID.class.getName().equals(this.dvmClass.getName()) && "createString".equals(this.methodName)) {
            return "toString";
        }
        return this.methodName;
    }

    public String getArgs() {
        return this.args;
    }

    public final String getSignature() {
        return this.dvmClass.getClassName() + "->" + this.methodName + this.args;
    }

    public boolean isStatic() {
        return this.isStatic;
    }

    DvmObject<?> callStaticObjectMethod(VarArg varArg) {
        BaseVM vm = this.dvmClass.vm;
        return this.checkJni(vm, this.dvmClass).callStaticObjectMethod(vm, this.dvmClass, this, varArg);
    }

    DvmObject<?> callStaticObjectMethodV(VaList vaList) {
        BaseVM vm = this.dvmClass.vm;
        return this.checkJni(vm, this.dvmClass).callStaticObjectMethodV(vm, this.dvmClass, this, vaList);
    }

    DvmObject<?> callStaticObjectMethodA(VaList vaList) {
        BaseVM vm = this.dvmClass.vm;
        return this.checkJni(vm, this.dvmClass).callStaticObjectMethodV(vm, this.dvmClass, this, vaList);
    }

    DvmObject<?> callObjectMethod(DvmObject<?> dvmObject, VarArg varArg) {
        BaseVM vm = this.dvmClass.vm;
        return this.checkJni(vm, this.dvmClass).callObjectMethod(vm, dvmObject, this, varArg);
    }

    long callLongMethodA(DvmObject<?> dvmObject, VaList vaList) {
        BaseVM vm = this.dvmClass.vm;
        return this.checkJni(vm, this.dvmClass).callLongMethodV(vm, dvmObject, this, vaList);
    }

    long callLongMethod(DvmObject<?> dvmObject, VarArg varArg) {
        BaseVM vm = this.dvmClass.vm;
        return this.checkJni(vm, this.dvmClass).callLongMethod(vm, dvmObject, this, varArg);
    }

    long callLongMethodV(DvmObject<?> dvmObject, VaList vaList) {
        BaseVM vm = this.dvmClass.vm;
        return this.checkJni(vm, this.dvmClass).callLongMethodV(vm, dvmObject, this, vaList);
    }

    DvmObject<?> callObjectMethodV(DvmObject<?> dvmObject, VaList vaList) {
        BaseVM vm = this.dvmClass.vm;
        return this.checkJni(vm, this.dvmClass).callObjectMethodV(vm, dvmObject, this, vaList);
    }

    DvmObject<?> callObjectMethodA(DvmObject<?> dvmObject, VaList vaList) {
        BaseVM vm = this.dvmClass.vm;
        return this.checkJni(vm, this.dvmClass).callObjectMethodV(vm, dvmObject, this, vaList);
    }

    byte callByteMethodV(DvmObject<?> dvmObject, VaList vaList) {
        BaseVM vm = this.dvmClass.vm;
        return this.checkJni(vm, this.dvmClass).callByteMethodV(vm, dvmObject, this, vaList);
    }

    short callShortMethodV(DvmObject<?> dvmObject, VaList vaList) {
        BaseVM vm = this.dvmClass.vm;
        return this.checkJni(vm, this.dvmClass).callShortMethodV(vm, dvmObject, this, vaList);
    }

    int callIntMethodV(DvmObject<?> dvmObject, VaList vaList) {
        BaseVM vm = this.dvmClass.vm;
        return this.checkJni(vm, this.dvmClass).callIntMethodV(vm, dvmObject, this, vaList);
    }

    boolean callBooleanMethod(DvmObject<?> dvmObject, VarArg varArg) {
        BaseVM vm = this.dvmClass.vm;
        return this.checkJni(vm, this.dvmClass).callBooleanMethod(vm, dvmObject, this, varArg);
    }

    boolean callBooleanMethodV(DvmObject<?> dvmObject, VaList vaList) {
        BaseVM vm = this.dvmClass.vm;
        return this.checkJni(vm, this.dvmClass).callBooleanMethodV(vm, dvmObject, this, vaList);
    }

    boolean callBooleanMethodA(DvmObject<?> dvmObject, VaList vaList) {
        BaseVM vm = this.dvmClass.vm;
        return this.checkJni(vm, this.dvmClass).callBooleanMethodV(vm, dvmObject, this, vaList);
    }

    int callIntMethod(DvmObject<?> dvmObject, VarArg varArg) {
        BaseVM vm = this.dvmClass.vm;
        return this.checkJni(vm, this.dvmClass).callIntMethod(vm, dvmObject, this, varArg);
    }

    int callIntMethodA(DvmObject<?> dvmObject, VaList vaList) {
        BaseVM vm = this.dvmClass.vm;
        return this.checkJni(vm, this.dvmClass).callIntMethodV(vm, dvmObject, this, vaList);
    }

    double callDoubleMethod(DvmObject<?> dvmObject, VarArg varArg) {
        BaseVM vm = this.dvmClass.vm;
        return this.checkJni(vm, this.dvmClass).callDoubleMethod(vm, dvmObject, this, varArg);
    }

    char callCharMethodV(DvmObject<?> dvmObject, VaList vaList) {
        BaseVM vm = this.dvmClass.vm;
        return this.checkJni(vm, this.dvmClass).callCharMethodV(vm, dvmObject, this, vaList);
    }

    void callVoidMethod(DvmObject<?> dvmObject, VarArg varArg) {
        BaseVM vm = this.dvmClass.vm;
        this.checkJni(vm, this.dvmClass).callVoidMethod(vm, dvmObject, this, varArg);
    }

    int callStaticIntMethod(VarArg varArg) {
        BaseVM vm = this.dvmClass.vm;
        return this.checkJni(vm, this.dvmClass).callStaticIntMethod(vm, this.dvmClass, this, varArg);
    }

    int callStaticIntMethodV(VaList vaList) {
        BaseVM vm = this.dvmClass.vm;
        return this.checkJni(vm, this.dvmClass).callStaticIntMethodV(vm, this.dvmClass, this, vaList);
    }

    long callStaticLongMethodA(VaList vaList) {
        BaseVM vm = this.dvmClass.vm;
        return this.checkJni(vm, this.dvmClass).callStaticLongMethodV(vm, this.dvmClass, this, vaList);
    }

    long callStaticLongMethod(VarArg varArg) {
        BaseVM vm = this.dvmClass.vm;
        return this.checkJni(vm, this.dvmClass).callStaticLongMethod(vm, this.dvmClass, this, varArg);
    }

    long callStaticLongMethodV(VaList vaList) {
        BaseVM vm = this.dvmClass.vm;
        return this.checkJni(vm, this.dvmClass).callStaticLongMethodV(vm, this.dvmClass, this, vaList);
    }

    boolean CallStaticBooleanMethod(VarArg varArg) {
        BaseVM vm = this.dvmClass.vm;
        return this.checkJni(vm, this.dvmClass).callStaticBooleanMethod(vm, this.dvmClass, this, varArg);
    }

    boolean callStaticBooleanMethodV(VaList vaList) {
        BaseVM vm = this.dvmClass.vm;
        return this.checkJni(vm, this.dvmClass).callStaticBooleanMethodV(vm, this.dvmClass, this, vaList);
    }

    float callStaticFloatMethod(VarArg varArg) {
        BaseVM vm = this.dvmClass.vm;
        return this.checkJni(vm, this.dvmClass).callStaticFloatMethod(vm, this.dvmClass, this, varArg);
    }

    double callStaticDoubleMethod(VarArg varArg) {
        BaseVM vm = this.dvmClass.vm;
        return this.checkJni(vm, this.dvmClass).callStaticDoubleMethod(vm, this.dvmClass, this, varArg);
    }

    void callStaticVoidMethod(VarArg varArg) {
        BaseVM vm = this.dvmClass.vm;
        this.checkJni(vm, this.dvmClass).callStaticVoidMethod(vm, this.dvmClass, this, varArg);
    }

    void callStaticVoidMethodV(VaList vaList) {
        BaseVM vm = this.dvmClass.vm;
        this.checkJni(vm, this.dvmClass).callStaticVoidMethodV(vm, this.dvmClass, this, vaList);
    }

    void callStaticVoidMethodA(VaList vaList) {
        BaseVM vm = this.dvmClass.vm;
        this.checkJni(vm, this.dvmClass).callStaticVoidMethodV(vm, this.dvmClass, this, vaList);
    }

    DvmObject<?> newObjectV(VaList vaList) {
        BaseVM vm = this.dvmClass.vm;
        return this.checkJni(vm, this.dvmClass).newObjectV(vm, this.dvmClass, this, vaList);
    }

    DvmObject<?> newObjectA(VaList vaList) {
        BaseVM vm = this.dvmClass.vm;
        return this.checkJni(vm, this.dvmClass).newObjectV(vm, this.dvmClass, this, vaList);
    }

    DvmObject<?> newObject(VarArg varArg) {
        BaseVM vm = this.dvmClass.vm;
        return this.checkJni(vm, this.dvmClass).newObject(vm, this.dvmClass, this, varArg);
    }

    void callVoidMethodV(DvmObject<?> dvmObject, VaList vaList) {
        BaseVM vm = this.dvmClass.vm;
        this.checkJni(vm, this.dvmClass).callVoidMethodV(vm, dvmObject, this, vaList);
    }

    void callVoidMethodA(DvmObject<?> dvmObject, VaList vaList) {
        BaseVM vm = this.dvmClass.vm;
        this.checkJni(vm, this.dvmClass).callVoidMethodV(vm, dvmObject, this, vaList);
    }

    float callFloatMethodV(DvmObject<?> dvmObject, VaList vaList) {
        BaseVM vm = this.dvmClass.vm;
        return this.checkJni(vm, this.dvmClass).callFloatMethodV(vm, dvmObject, this, vaList);
    }

    final DvmObject<?> toReflectedMethod() {
        BaseVM vm = this.dvmClass.vm;
        return this.checkJni(vm, this.dvmClass).toReflectedMethod(vm, this.dvmClass, this);
    }

    public final Shorty[] decodeArgsShorty() {
        char c;
        if (this.shortyCache != null) {
            return this.shortyCache;
        }
        char[] chars = this.args.toCharArray();
        ArrayList<Shorty> list = new ArrayList<Shorty>(chars.length);
        int arrayDimensions = 0;
        boolean isType = false;
        Shorty shorty = null;
        StringBuilder binaryName = new StringBuilder();
        for (int i = 1; i < chars.length && (c = chars[i]) != ')'; ++i) {
            if (isType) {
                if (c == ';') {
                    isType = false;
                    shorty.setBinaryName(binaryName.toString());
                    binaryName.delete(0, binaryName.length());
                    continue;
                }
                binaryName.append(c);
                continue;
            }
            char type = '0';
            switch (c) {
                case 'L': {
                    isType = true;
                    type = c;
                    break;
                }
                case 'B': 
                case 'C': 
                case 'D': 
                case 'F': 
                case 'I': 
                case 'J': 
                case 'S': 
                case 'Z': {
                    type = c;
                    break;
                }
                case '[': {
                    ++arrayDimensions;
                    break;
                }
                default: {
                    throw new IllegalStateException("i=" + i + ", char=" + chars[i] + ", args=" + this.args);
                }
            }
            if (type == '0') continue;
            shorty = new Shorty(arrayDimensions, type);
            list.add(shorty);
            arrayDimensions = 0;
        }
        this.shortyCache = list.toArray(new Shorty[0]);
        return this.shortyCache;
    }

    public void setMember(Member member) {
        ((AccessibleObject)((Object)member)).setAccessible(true);
        if (!Modifier.isStatic(member.getModifiers()) && this.isStatic) {
            throw new IllegalStateException(this.toString());
        }
        if (member.getDeclaringClass().getName().equals(this.dvmClass.getName())) {
            this.member = member;
        }
    }

    public String toString() {
        return this.getSignature();
    }
}

