/*
 * Decompiled with CFR 0.152.
 */
package com.github.unidbg.linux.android.dvm.apk;

import com.github.unidbg.linux.android.dvm.apk.Apk;
import java.io.File;
import java.io.IOException;
import java.security.cert.CertificateException;
import java.util.ArrayList;
import net.dongliu.apk.parser.bean.ApkMeta;
import net.dongliu.apk.parser.bean.ApkSigner;
import net.dongliu.apk.parser.bean.CertificateMeta;
import net.dongliu.apk.parser.exception.ParserException;

class ApkFile
implements Apk {
    private final File apkFile;
    private ApkMeta apkMeta;
    private CertificateMeta[] signatures;

    ApkFile(File file) {
        this.apkFile = file;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public long getVersionCode() {
        if (this.apkMeta != null) {
            return this.apkMeta.getVersionCode();
        }
        try (net.dongliu.apk.parser.ApkFile apkFile = new net.dongliu.apk.parser.ApkFile(this.apkFile);){
            this.apkMeta = apkFile.getApkMeta();
            long l = this.apkMeta.getVersionCode();
            return l;
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public String getVersionName() {
        if (this.apkMeta != null) {
            return this.apkMeta.getVersionName();
        }
        try (net.dongliu.apk.parser.ApkFile apkFile = new net.dongliu.apk.parser.ApkFile(this.apkFile);){
            this.apkMeta = apkFile.getApkMeta();
            String string = this.apkMeta.getVersionName();
            return string;
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public String getManifestXml() {
        try (net.dongliu.apk.parser.ApkFile apkFile = new net.dongliu.apk.parser.ApkFile(this.apkFile);){
            String string = apkFile.getManifestXml();
            return string;
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public byte[] openAsset(String fileName) {
        try (net.dongliu.apk.parser.ApkFile apkFile = new net.dongliu.apk.parser.ApkFile(this.apkFile);){
            byte[] byArray = apkFile.getFileData("assets/" + fileName);
            return byArray;
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public CertificateMeta[] getSignatures() {
        if (this.signatures != null) {
            return this.signatures;
        }
        try (net.dongliu.apk.parser.ApkFile apkFile = new net.dongliu.apk.parser.ApkFile(this.apkFile);){
            ArrayList signatures = new ArrayList(10);
            for (ApkSigner signer : apkFile.getApkSingers()) {
                signatures.addAll(signer.getCertificateMetas());
            }
            CertificateMeta[] certificateMetaArray = this.signatures = signatures.toArray(new CertificateMeta[0]);
            return certificateMetaArray;
        }
        catch (IOException | CertificateException e) {
            throw new IllegalStateException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public String getPackageName() {
        if (this.apkMeta != null) {
            return this.apkMeta.getPackageName();
        }
        try (net.dongliu.apk.parser.ApkFile apkFile = new net.dongliu.apk.parser.ApkFile(this.apkFile);){
            this.apkMeta = apkFile.getApkMeta();
            String string = this.apkMeta.getPackageName();
            return string;
        }
        catch (ParserException e) {
            return null;
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public File getParentFile() {
        return this.apkFile.getParentFile();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public byte[] getFileData(String path) {
        try (net.dongliu.apk.parser.ApkFile apkFile = new net.dongliu.apk.parser.ApkFile(this.apkFile);){
            byte[] byArray = apkFile.getFileData(path);
            return byArray;
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }
}

