/*
 * Decompiled with CFR 0.152.
 */
package com.github.unidbg.linux.android.dvm.jni;

import com.github.unidbg.linux.android.dvm.jni.ProxyDvmObjectVisitor;
import java.lang.reflect.Field;

class ProxyField {
    private final ProxyDvmObjectVisitor visitor;
    private final Field field;

    ProxyField(ProxyDvmObjectVisitor visitor, Field field) {
        this.visitor = visitor;
        this.field = field;
    }

    final Object get(Object thisObj) throws IllegalAccessException {
        if (this.visitor != null) {
            this.visitor.onProxyVisit(this.field, thisObj, null);
        }
        Object result = this.field.get(thisObj);
        if (this.visitor != null) {
            result = this.visitor.postProxyVisit(this.field, thisObj, null, result);
        }
        return result;
    }

    final long getLong(Object thisObj) throws IllegalAccessException {
        if (this.visitor != null) {
            this.visitor.onProxyVisit(this.field, thisObj, null);
        }
        long result = this.field.getLong(thisObj);
        if (this.visitor != null) {
            result = this.visitor.postProxyVisit(this.field, thisObj, null, result);
        }
        return result;
    }

    final float getFloat(Object thisObj) throws IllegalAccessException {
        if (this.visitor != null) {
            this.visitor.onProxyVisit(this.field, thisObj, null);
        }
        float result = this.field.getFloat(thisObj);
        if (this.visitor != null) {
            result = this.visitor.postProxyVisit(this.field, thisObj, null, Float.valueOf(result)).floatValue();
        }
        return result;
    }

    final boolean getBoolean(Object thisObj) throws IllegalAccessException {
        if (this.visitor != null) {
            this.visitor.onProxyVisit(this.field, thisObj, null);
        }
        boolean result = this.field.getBoolean(thisObj);
        if (this.visitor != null) {
            result = this.visitor.postProxyVisit(this.field, thisObj, null, result);
        }
        return result;
    }

    final byte getByte(Object thisObj) throws IllegalAccessException {
        if (this.visitor != null) {
            this.visitor.onProxyVisit(this.field, thisObj, null);
        }
        byte result = this.field.getByte(thisObj);
        if (this.visitor != null) {
            result = this.visitor.postProxyVisit(this.field, thisObj, null, result);
        }
        return result;
    }

    final int getInt(Object thisObj) throws IllegalAccessException {
        if (this.visitor != null) {
            this.visitor.onProxyVisit(this.field, thisObj, null);
        }
        int result = this.field.getInt(thisObj);
        if (this.visitor != null) {
            result = this.visitor.postProxyVisit(this.field, thisObj, null, result);
        }
        return result;
    }

    final void setInt(Object thisObj, int value) throws IllegalAccessException {
        if (this.visitor != null) {
            this.visitor.onProxyVisit(this.field, thisObj, new Object[]{value});
        }
        this.field.setInt(thisObj, value);
    }

    final void setFloat(Object thisObj, float value) throws IllegalAccessException {
        if (this.visitor != null) {
            this.visitor.onProxyVisit(this.field, thisObj, new Object[]{Float.valueOf(value)});
        }
        this.field.setFloat(thisObj, value);
    }

    final void setDouble(Object thisObj, double value) throws IllegalAccessException {
        if (this.visitor != null) {
            this.visitor.onProxyVisit(this.field, thisObj, new Object[]{value});
        }
        this.field.setDouble(thisObj, value);
    }

    final void setObject(Object thisObj, Object value) throws IllegalAccessException {
        if (this.visitor != null) {
            this.visitor.onProxyVisit(this.field, thisObj, new Object[]{value});
        }
        this.field.set(thisObj, value);
    }

    final void setBoolean(Object thisObj, boolean value) throws IllegalAccessException {
        if (this.visitor != null) {
            this.visitor.onProxyVisit(this.field, thisObj, new Object[]{value});
        }
        this.field.setBoolean(thisObj, value);
    }

    final void setLong(Object thisObj, long value) throws IllegalAccessException {
        if (this.visitor != null) {
            this.visitor.onProxyVisit(this.field, thisObj, new Object[]{value});
        }
        this.field.setLong(thisObj, value);
    }
}

