/*
 * Decompiled with CFR 0.152.
 */
package com.github.unidbg.linux.android.dvm.jni;

import com.github.unidbg.arm.backend.BackendException;
import com.github.unidbg.linux.android.dvm.VM;
import com.github.unidbg.linux.android.dvm.jni.ProxyCall;
import com.github.unidbg.linux.android.dvm.jni.ProxyDvmException;
import com.github.unidbg.linux.android.dvm.jni.ProxyDvmObject;
import com.github.unidbg.linux.android.dvm.jni.ProxyDvmObjectVisitor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Member;
import java.lang.reflect.Method;

class ProxyMethod
implements ProxyCall {
    private final ProxyDvmObjectVisitor visitor;
    private final Member method;
    private final Object[] args;

    ProxyMethod(ProxyDvmObjectVisitor visitor, Member method, Object[] args) {
        this.visitor = visitor;
        this.method = method;
        this.args = args;
    }

    @Override
    public Object call(VM vm, Object obj) throws IllegalAccessException, InvocationTargetException {
        try {
            this.patchClassName(obj, this.args);
            if (this.visitor != null) {
                this.visitor.onProxyVisit(this.method, obj, this.args);
            }
            if (this.method instanceof Method) {
                Object result = ((Method)this.method).invoke(obj, this.args);
                if (this.visitor != null) {
                    result = this.visitor.postProxyVisit(this.method, obj, this.args, result);
                }
                return result;
            }
            throw new UnsupportedOperationException("method=" + this.method);
        }
        catch (InvocationTargetException e) {
            Throwable cause = e.getTargetException();
            if (cause instanceof BackendException) {
                throw (BackendException)cause;
            }
            if (cause instanceof ProxyDvmException) {
                vm.throwException(ProxyDvmObject.createObject(vm, cause));
                return null;
            }
            if (cause instanceof ClassNotFoundException) {
                vm.throwException(ProxyDvmObject.createObject(vm, cause));
                return null;
            }
            throw e;
        }
    }

    private void patchClassName(Object obj, Object[] args) {
        if (obj instanceof ClassLoader && args.length == 1 && ("loadClass".equals(this.method.getName()) || "findClass".equals(this.method.getName()))) {
            String binaryName = (String)args[0];
            args[0] = binaryName.replace('/', '.');
        }
    }
}

