/*
 * Decompiled with CFR 0.152.
 */
package com.github.unidbg.linux.file;

import com.github.unidbg.arm.backend.Backend;
import com.github.unidbg.file.linux.AndroidFileIO;
import com.github.unidbg.file.linux.BaseAndroidFileIO;
import com.github.unidbg.utils.Inspector;
import com.sun.jna.Pointer;
import java.io.IOException;
import java.io.PipedInputStream;
import java.util.Arrays;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PipedReadFileIO
extends BaseAndroidFileIO
implements AndroidFileIO {
    private static final Log log = LogFactory.getLog(PipedReadFileIO.class);
    private final int writefd;
    private final PipedInputStream inputStream;

    public PipedReadFileIO(PipedInputStream inputStream, int writefd) {
        super(0);
        this.inputStream = inputStream;
        this.writefd = writefd;
    }

    public int read(Backend backend, Pointer buffer, int count) {
        try {
            byte[] receiveBuf = new byte[Math.min(count, this.inputStream.available())];
            int read = this.inputStream.read(receiveBuf, 0, receiveBuf.length);
            if (read <= 0) {
                return read;
            }
            byte[] data = Arrays.copyOf(receiveBuf, read);
            buffer.write(0L, data, 0, data.length);
            if (log.isDebugEnabled()) {
                log.debug((Object)Inspector.inspectString((byte[])data, (String)("read fd=" + this.writefd)));
            }
            return data.length;
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    public boolean canRead() {
        try {
            return this.inputStream.available() > 0;
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    public void close() {
        try {
            this.inputStream.close();
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    public String toString() {
        return "PipedRead: " + this.writefd;
    }
}

