/*
 * Decompiled with CFR 0.152.
 */
package com.github.unidbg.linux.file;

import com.alibaba.fastjson.util.IOUtils;
import com.github.unidbg.Emulator;
import com.github.unidbg.arm.backend.Backend;
import com.github.unidbg.file.FileIO;
import com.github.unidbg.file.linux.AndroidFileIO;
import com.github.unidbg.linux.file.SocketIO;
import com.github.unidbg.utils.Inspector;
import com.sun.jna.Pointer;
import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.util.Arrays;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class TcpSocket
extends SocketIO
implements FileIO {
    private static final Log log = LogFactory.getLog(TcpSocket.class);
    private final Socket socket;
    private ServerSocket serverSocket;
    private final Emulator<?> emulator;
    protected OutputStream outputStream;
    protected InputStream inputStream;
    private byte[] receiveBuf;

    public TcpSocket(Emulator<?> emulator) {
        this(emulator, new Socket());
    }

    private TcpSocket(Emulator<?> emulator, Socket socket) {
        this.emulator = emulator;
        this.socket = socket;
        if (emulator.getSyscallHandler().isVerbose()) {
            System.out.printf("Tcp opened '%s' from %s%n", this, emulator.getContext().getLRPointer());
        }
    }

    public void close() {
        IOUtils.close((Closeable)this.outputStream);
        IOUtils.close((Closeable)this.inputStream);
        IOUtils.close((Closeable)this.socket);
        IOUtils.close((Closeable)this.serverSocket);
    }

    public int write(byte[] data) {
        try {
            if (log.isDebugEnabled()) {
                Inspector.inspect((byte[])data, (String)("write hex=" + Hex.encodeHexString((byte[])data)));
            }
            this.outputStream.write(data);
            return data.length;
        }
        catch (IOException e) {
            log.debug((Object)"write failed", (Throwable)e);
            return -1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int recvfrom(Backend backend, Pointer buf, int len, int flags, Pointer src_addr, Pointer addrlen) {
        boolean peek;
        boolean bl = peek = (flags & 2) != 0;
        if (peek && (flags & 0xFFFFFFFD) == 0 && this.inputStream.markSupported() && src_addr == null && addrlen == null) {
            try {
                this.inputStream.mark(len);
                int n = this.readInternal(buf, len, false);
                return n;
            }
            finally {
                try {
                    this.inputStream.reset();
                }
                catch (IOException e) {
                    log.warn((Object)"recvfrom", (Throwable)e);
                }
            }
        }
        return super.recvfrom(backend, buf, len, flags, src_addr, addrlen);
    }

    public int read(Backend backend, Pointer buffer, int count) {
        return this.readInternal(buffer, count, true);
    }

    protected int readInternal(Pointer buffer, int count, boolean logRead) {
        try {
            int read;
            if (this.receiveBuf == null) {
                this.receiveBuf = new byte[this.socket.getReceiveBufferSize()];
            }
            if ((read = this.inputStream.read(this.receiveBuf, 0, Math.min(count, this.receiveBuf.length))) <= 0) {
                return read;
            }
            byte[] data = Arrays.copyOf(this.receiveBuf, read);
            buffer.write(0L, data, 0, data.length);
            if (logRead && log.isDebugEnabled()) {
                Inspector.inspect((byte[])data, (String)("readInternal socket=" + this.socket));
            }
            return data.length;
        }
        catch (IOException e) {
            log.debug((Object)"readInternal", (Throwable)e);
            return -1;
        }
    }

    public int listen(int backlog) {
        try {
            this.serverSocket = new ServerSocket();
            IOUtils.close((Closeable)this.socket);
            this.serverSocket.bind(this.socket.getLocalSocketAddress(), backlog);
            return 0;
        }
        catch (IOException e) {
            log.debug((Object)"listen failed", (Throwable)e);
            this.emulator.getMemory().setErrno(95);
            return -1;
        }
    }

    @Override
    public AndroidFileIO accept(Pointer addr, Pointer addrlen) {
        try {
            Socket socket = this.serverSocket.accept();
            TcpSocket io = new TcpSocket(this.emulator, socket);
            io.inputStream = new BufferedInputStream(socket.getInputStream());
            io.outputStream = socket.getOutputStream();
            if (addr != null) {
                io.getpeername(addr, addrlen);
            }
            return io;
        }
        catch (IOException e) {
            log.debug((Object)"accept failed", (Throwable)e);
            this.emulator.getMemory().setErrno(11);
            return null;
        }
    }

    @Override
    protected int bind_ipv4(Pointer addr, int addrlen) {
        short sa_family = addr.getShort(0L);
        if (sa_family != 2) {
            throw new AbstractMethodError("sa_family=" + sa_family);
        }
        try {
            int port = Short.reverseBytes(addr.getShort(2L)) & 0xFFFF;
            InetSocketAddress address = new InetSocketAddress(InetAddress.getByAddress(addr.getByteArray(4L, 4)), port);
            if (log.isDebugEnabled()) {
                byte[] data = addr.getByteArray(0L, addrlen);
                Inspector.inspect((byte[])data, (String)("address=" + address));
            }
            this.socket.bind(address);
            return 0;
        }
        catch (IOException e) {
            log.debug((Object)"bind ipv4 failed", (Throwable)e);
            this.emulator.getMemory().setErrno(98);
            return -1;
        }
    }

    @Override
    protected int connect_ipv4(Pointer addr, int addrlen) {
        short sa_family;
        if (log.isDebugEnabled()) {
            byte[] data = addr.getByteArray(0L, addrlen);
            Inspector.inspect((byte[])data, (String)"addr");
        }
        if ((sa_family = addr.getShort(0L)) != 2) {
            throw new AbstractMethodError("sa_family=" + sa_family);
        }
        try {
            int port = Short.reverseBytes(addr.getShort(2L)) & 0xFFFF;
            InetSocketAddress address = new InetSocketAddress(InetAddress.getByAddress(addr.getByteArray(4L, 4)), port);
            this.socket.connect(address);
            this.outputStream = this.socket.getOutputStream();
            this.inputStream = new BufferedInputStream(this.socket.getInputStream());
            return 0;
        }
        catch (IOException e) {
            log.debug((Object)"connect ipv4 failed", (Throwable)e);
            this.emulator.getMemory().setErrno(111);
            return -1;
        }
    }

    @Override
    protected int connect_ipv6(Pointer addr, int addrlen) {
        short sa_family;
        if (log.isDebugEnabled()) {
            byte[] data = addr.getByteArray(0L, addrlen);
            Inspector.inspect((byte[])data, (String)"addr");
        }
        if ((sa_family = addr.getShort(0L)) != 10) {
            throw new AbstractMethodError("sa_family=" + sa_family);
        }
        try {
            int port = Short.reverseBytes(addr.getShort(2L)) & 0xFFFF;
            InetSocketAddress address = new InetSocketAddress(InetAddress.getByAddress(addr.getByteArray(8L, 16)), port);
            this.socket.connect(address);
            this.outputStream = this.socket.getOutputStream();
            this.inputStream = new BufferedInputStream(this.socket.getInputStream());
            return 0;
        }
        catch (IOException e) {
            log.debug((Object)"connect ipv6 failed", (Throwable)e);
            this.emulator.getMemory().setErrno(111);
            return -1;
        }
    }

    public int getpeername(Pointer addr, Pointer addrlen) {
        InetSocketAddress remote = (InetSocketAddress)this.socket.getRemoteSocketAddress();
        this.fillAddress(remote, addr, addrlen);
        return 0;
    }

    @Override
    protected InetSocketAddress getLocalSocketAddress() {
        return (InetSocketAddress)this.socket.getLocalSocketAddress();
    }

    @Override
    protected void setKeepAlive(int keepAlive) throws SocketException {
        this.socket.setKeepAlive(keepAlive != 0);
    }

    @Override
    protected void setSendBufferSize(int size) throws SocketException {
        this.socket.setSendBufferSize(size);
    }

    @Override
    protected void setReceiveBufferSize(int size) throws SocketException {
        this.socket.setReceiveBufferSize(size);
    }

    @Override
    protected void setReuseAddress(int reuseAddress) throws SocketException {
        this.socket.setReuseAddress(reuseAddress != 0);
    }

    @Override
    protected void setTcpNoDelay(int tcpNoDelay) throws SocketException {
        this.socket.setTcpNoDelay(tcpNoDelay != 0);
    }

    @Override
    protected int getTcpNoDelay() throws SocketException {
        return this.socket.getTcpNoDelay() ? 1 : 0;
    }

    public int shutdown(int how) {
        switch (how) {
            case 0: 
            case 1: {
                IOUtils.close((Closeable)this.outputStream);
                this.outputStream = null;
                return 0;
            }
            case 2: {
                IOUtils.close((Closeable)this.outputStream);
                IOUtils.close((Closeable)this.inputStream);
                this.outputStream = null;
                this.inputStream = null;
                return 0;
            }
        }
        return super.shutdown(how);
    }

    public String toString() {
        return this.socket.toString();
    }
}

