/*
 * Decompiled with CFR 0.152.
 */
package com.github.unidbg.linux.signal;

import com.github.unidbg.AbstractEmulator;
import com.github.unidbg.Emulator;
import com.github.unidbg.arm.backend.Backend;
import com.github.unidbg.linux.signal.SigAction;
import com.github.unidbg.memory.MemoryBlock;
import com.github.unidbg.pointer.UnidbgPointer;
import com.github.unidbg.thread.MainTask;

public class SignalFunction
extends MainTask {
    private final int signum;
    private final SigAction action;
    private MemoryBlock infoBlock;

    public SignalFunction(Emulator<?> emulator, int signum, SigAction action) {
        super(emulator.getPid(), emulator.getReturnAddress());
        this.signum = signum;
        this.action = action;
    }

    public String toThreadString() {
        return "SignalFunction sa_handler=" + this.action.getSaHandler() + ", signum=" + this.signum;
    }

    public void destroy(Emulator<?> emulator) {
        super.destroy(emulator);
        if (this.infoBlock != null) {
            this.infoBlock.free();
            this.infoBlock = null;
        }
    }

    protected Number run(AbstractEmulator<?> emulator) {
        Backend backend = emulator.getBackend();
        if (this.action.needSigInfo() && this.infoBlock == null) {
            this.infoBlock = emulator.getMemory().malloc(128, true);
            this.infoBlock.getPointer().setInt(0L, this.signum);
        }
        UnidbgPointer stack = this.allocateStack((Emulator)emulator);
        if (emulator.is32Bit()) {
            backend.reg_write(12, (Number)stack.peer);
            backend.reg_write(66, (Number)this.signum);
            backend.reg_write(67, (Number)(this.infoBlock == null ? 0L : this.infoBlock.getPointer().peer));
            backend.reg_write(68, (Number)0);
            backend.reg_write(10, (Number)this.until);
        } else {
            backend.reg_write(4, (Number)stack.peer);
            backend.reg_write(199, (Number)this.signum);
            backend.reg_write(200, (Number)(this.infoBlock == null ? 0L : this.infoBlock.getPointer().peer));
            backend.reg_write(201, (Number)0);
            backend.reg_write(2, (Number)this.until);
        }
        return emulator.emulate(this.action.getSaHandler(), this.until);
    }
}

