/*
 * Decompiled with CFR 0.152.
 */
package com.github.unidbg.linux.thread;

import com.github.unidbg.Emulator;
import com.github.unidbg.linux.thread.FutexWaiter;
import com.github.unidbg.unix.struct.TimeSpec;
import com.sun.jna.Pointer;

public class FutexNanoSleepWaiter
extends FutexWaiter {
    private final long waitMillis;
    private final long startWaitTimeInMillis;

    public FutexNanoSleepWaiter(Pointer uaddr, int val, TimeSpec timeSpec) {
        super(uaddr, val);
        this.waitMillis = timeSpec.toMillis();
        this.startWaitTimeInMillis = System.currentTimeMillis();
        if (this.waitMillis <= 0L) {
            throw new IllegalStateException();
        }
    }

    @Override
    public boolean canDispatch() {
        boolean ret = super.canDispatch();
        if (ret) {
            return true;
        }
        if (System.currentTimeMillis() - this.startWaitTimeInMillis >= this.waitMillis) {
            return true;
        }
        Thread.yield();
        return false;
    }

    @Override
    protected void onContinueRunInternal(Emulator<?> emulator) {
        super.onContinueRunInternal(emulator);
        emulator.getBackend().reg_write(emulator.is32Bit() ? 66 : 199, (Number)-110);
    }
}

