/*
 * Decompiled with CFR 0.152.
 */
package com.github.unidbg.virtualmodule.android;

import com.github.unidbg.Emulator;
import com.github.unidbg.Svc;
import com.github.unidbg.arm.Arm64Hook;
import com.github.unidbg.arm.ArmHook;
import com.github.unidbg.arm.HookStatus;
import com.github.unidbg.arm.NestedRun;
import com.github.unidbg.arm.context.EditableArm32RegisterContext;
import com.github.unidbg.arm.context.EditableArm64RegisterContext;
import com.github.unidbg.memory.SvcMemory;
import com.github.unidbg.pointer.UnidbgPointer;
import com.github.unidbg.virtualmodule.VirtualModule;
import com.sun.jna.Pointer;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SystemProperties
extends VirtualModule<Void> {
    private static final Logger log = LoggerFactory.getLogger(SystemProperties.class);

    public SystemProperties(Emulator<?> emulator, Void extra) {
        super(emulator, (Object)extra, "libsystemproperties.so");
    }

    protected void onInitialize(Emulator<?> emulator, Void extra, Map<String, UnidbgPointer> symbols) {
        boolean is64Bit = emulator.is64Bit();
        SvcMemory svcMemory = emulator.getSvcMemory();
        symbols.put("__system_property_read_callback", svcMemory.registerSvc((Svc)(is64Bit ? new Arm64Hook(){

            public HookStatus hook(Emulator<?> emulator) {
                EditableArm64RegisterContext context = (EditableArm64RegisterContext)emulator.getContext();
                UnidbgPointer pi = context.getPointerArg(0);
                UnidbgPointer callback = context.getPointerArg(1);
                UnidbgPointer cookie = context.getPointerArg(2);
                log.debug("__system_property_read_callback pi={}, callback={}, cookie={}", new Object[]{pi, callback, cookie});
                Pointer key = pi.share(96L);
                Pointer value = pi.share(4L);
                context.setXLong(0, UnidbgPointer.nativeValue((Pointer)cookie));
                context.setXLong(1, UnidbgPointer.nativeValue((Pointer)value));
                context.setXLong(2, UnidbgPointer.nativeValue((Pointer)key));
                context.setXLong(3, (long)pi.getInt(0L));
                return HookStatus.RET(emulator, (long)UnidbgPointer.nativeValue((Pointer)callback));
            }
        } : new ArmHook(){

            protected HookStatus hook(Emulator<?> emulator) throws NestedRun {
                EditableArm32RegisterContext context = (EditableArm32RegisterContext)emulator.getContext();
                UnidbgPointer pi = context.getPointerArg(0);
                UnidbgPointer callback = context.getPointerArg(1);
                UnidbgPointer cookie = context.getPointerArg(2);
                log.debug("__system_property_read_callback pi={}, callback={}, cookie={}", new Object[]{pi, callback, cookie});
                Pointer key = pi.share(96L);
                Pointer value = pi.share(4L);
                context.setR0((int)UnidbgPointer.nativeValue((Pointer)cookie));
                context.setR1((int)UnidbgPointer.nativeValue((Pointer)value));
                context.setR2((int)UnidbgPointer.nativeValue((Pointer)key));
                context.setR3(pi.getInt(0L));
                return HookStatus.RET(emulator, (long)UnidbgPointer.nativeValue((Pointer)callback));
            }
        })));
    }
}

