/*
 * Decompiled with CFR 0.152.
 */
package net.fornwall.jelf;

import com.github.unidbg.Emulator;
import com.github.unidbg.Module;
import com.github.unidbg.pointer.UnidbgPointer;
import com.github.unidbg.unwind.Frame;
import com.github.unidbg.unwind.Unwinder;
import com.github.unidbg.utils.Inspector;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.Arrays;
import net.fornwall.jelf.DwarfCursor;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ArmExIdx {
    private static final Log log = LogFactory.getLog(ArmExIdx.class);
    private static final int ARM_EXIDX_CANT_UNWIND = 1;
    private static final int ARM_EXIDX_COMPACT = Integer.MIN_VALUE;
    private static final int ARM_EXTBL_OP_FINISH = 176;
    private static final int ARM_EXIDX_VFP_SHIFT_16 = 65536;
    private static final int ARM_EXIDX_VFP_DOUBLE = 131072;
    private static final int UNW_ARM_SP = 13;
    private static final int UNW_ARM_LR = 14;
    private static final int UNW_ARM_PC = 15;
    private final long virtualAddress;
    private final ByteBuffer buffer;

    ArmExIdx(long virtualAddress, ByteBuffer buffer) {
        this.virtualAddress = virtualAddress;
        this.buffer = buffer;
        this.buffer.order(ByteOrder.LITTLE_ENDIAN);
    }

    public Frame arm_exidx_step(Emulator<?> emulator, Unwinder unwinder, Module module, long fun, DwarfCursor context) {
        byte[] instruction;
        boolean compact;
        int value = 1;
        this.buffer.position(0);
        long offset = this.virtualAddress;
        int entry = 0;
        while (this.buffer.hasRemaining()) {
            int key = this.buffer.getInt() << 1 >> 1;
            if (key == 0) continue;
            if (fun < (long)(key = (int)((long)key + offset))) break;
            offset += 8L;
            entry = key;
            value = this.buffer.getInt();
        }
        if (value == 1) {
            return null;
        }
        if (fun == (long)entry) {
            UnidbgPointer fp;
            UnidbgPointer ip = UnidbgPointer.register(emulator, (int)10);
            Frame frame = unwinder.createFrame(ip, fp = UnidbgPointer.register(emulator, (int)12));
            if (frame != null) {
                context.ip = frame.ip.peer;
            }
            return frame;
        }
        boolean bl = compact = (value & Integer.MIN_VALUE) != 0;
        if (compact) {
            int index = value >> 24 & 0xF;
            if (index != 0) {
                throw new IllegalStateException("compact model must be Su16 / __aeabi_unwind_cpp_pr0");
            }
            ByteBuffer bb = ByteBuffer.allocate(4);
            bb.putInt(value);
            instruction = Arrays.copyOfRange(bb.array(), 1, 4);
        } else {
            value = value << 1 >> 1;
            long addr = (long)value + offset - 4L;
            UnidbgPointer pointer = UnidbgPointer.pointer(emulator, (long)(module.base + addr));
            assert (pointer != null);
            value = pointer.getInt(0L);
            if ((value & Integer.MIN_VALUE) == 0) {
                long personality = ((long)value << 1 >> 1) + addr;
                int data = pointer.getInt(4L);
                int n = data >> 24 & 0xFF;
                ByteBuffer bb = ByteBuffer.allocate((n + 1) * 4);
                bb.putInt(data);
                for (int i = 0; i < n; ++i) {
                    bb.putInt(pointer.getInt((long)((i + 2) * 4)));
                }
                instruction = Arrays.copyOfRange(bb.array(), 1, bb.capacity());
                if (log.isDebugEnabled()) {
                    log.debug((Object)("unwind generic model: " + module + ", entry=0x" + Integer.toHexString(entry) + ", personality=0x" + Long.toHexString(personality)));
                }
            } else {
                int index = value >> 24 & 0xF;
                switch (index) {
                    case 0: {
                        ByteBuffer bb = ByteBuffer.allocate(4);
                        bb.putInt(value);
                        instruction = Arrays.copyOfRange(bb.array(), 1, bb.capacity());
                        break;
                    }
                    case 1: 
                    case 2: {
                        int n = value >> 16 & 0xFF;
                        ByteBuffer bb = ByteBuffer.allocate((n + 1) * 4);
                        bb.putInt(value);
                        for (int i = 0; i < n; ++i) {
                            bb.putInt(pointer.getInt((long)((i + 1) * 4)));
                        }
                        instruction = Arrays.copyOfRange(bb.array(), 2, bb.capacity());
                        break;
                    }
                    default: {
                        throw new UnsupportedOperationException("index=" + index);
                    }
                }
            }
        }
        if (instruction.length > 0 && (instruction[instruction.length - 1] & 0xFF) != 176) {
            byte[] tmp = new byte[instruction.length + 1];
            System.arraycopy(instruction, 0, tmp, 0, instruction.length);
            tmp[instruction.length] = -80;
            instruction = tmp;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)Inspector.inspectString((byte[])instruction, (String)("unwind entry=0x" + Integer.toHexString(entry) + ", value=0x" + Integer.toHexString(value) + ", fun=0x" + Long.toHexString(fun) + ", module=" + module.name)));
        }
        return this.arm_exidx_decode(emulator, instruction, unwinder, context);
    }

    private Frame arm_exidx_decode(Emulator<?> emulator, byte[] instruction, Unwinder unwinder, DwarfCursor context) {
        context.loc[15] = null;
        arm_exbuf_data edata = new arm_exbuf_data();
        for (int i = 0; i < instruction.length; ++i) {
            int op2;
            int op = instruction[i] & 0xFF;
            if ((op & 0xC0) == 0) {
                edata.cmd = arm_exbuf_cmd.ARM_EXIDX_CMD_DATA_POP;
                edata.data = ((op & 0x3F) << 2) + 4;
            } else if ((op & 0xC0) == 64) {
                edata.cmd = arm_exbuf_cmd.ARM_EXIDX_CMD_DATA_PUSH;
                edata.data = ((op & 0x3F) << 2) + 4;
            } else if ((op & 0xF0) == 128) {
                op2 = instruction[++i] & 0xFF;
                if (op == 128 && op2 == 0) {
                    edata.cmd = arm_exbuf_cmd.ARM_EXIDX_CMD_REFUSED;
                } else {
                    edata.cmd = arm_exbuf_cmd.ARM_EXIDX_CMD_REG_POP;
                    edata.data = (op & 0xF) << 8 | op2;
                    edata.data <<= 4;
                }
            } else if ((op & 0xF0) == 144) {
                if (op == 157 || op == 159) {
                    edata.cmd = arm_exbuf_cmd.ARM_EXIDX_CMD_RESERVED;
                } else {
                    edata.cmd = arm_exbuf_cmd.ARM_EXIDX_CMD_REG_TO_SP;
                    edata.data = op & 0xF;
                }
            } else if ((op & 0xF0) == 160) {
                int end = op & 7;
                edata.data = (1 << end + 1) - 1;
                edata.data <<= 4;
                if ((op & 8) != 0) {
                    edata.data |= 0x4000;
                }
                edata.cmd = arm_exbuf_cmd.ARM_EXIDX_CMD_REG_POP;
            } else if (op == 176) {
                edata.cmd = arm_exbuf_cmd.ARM_EXIDX_CMD_FINISH;
            } else if (op == 177) {
                if ((op2 = instruction[++i] & 0xFF) == 0 || (op2 & 0xF0) != 0) {
                    edata.cmd = arm_exbuf_cmd.ARM_EXIDX_CMD_RESERVED;
                } else {
                    edata.cmd = arm_exbuf_cmd.ARM_EXIDX_CMD_REG_POP;
                    edata.data = op2 & 0xF;
                }
            } else if (op == 178) {
                byte b;
                int offset = 0;
                int shift = 0;
                do {
                    b = instruction[++i];
                    offset |= (b & 0x7F) << shift;
                    shift = (byte)(shift + 7);
                } while ((b & 0x80) != 0);
                edata.data = offset * 4 + 516;
                edata.cmd = arm_exbuf_cmd.ARM_EXIDX_CMD_DATA_POP;
            } else if (op == 179 || op == 200 || op == 201) {
                edata.cmd = arm_exbuf_cmd.ARM_EXIDX_CMD_VFP_POP;
                edata.data = instruction[++i] & 0xFF;
                if (op == 200) {
                    edata.data |= 0x10000;
                }
                if (op != 179) {
                    edata.data |= 0x20000;
                }
            } else if ((op & 0xF8) == 184 || (op & 0xF8) == 208) {
                edata.cmd = arm_exbuf_cmd.ARM_EXIDX_CMD_VFP_POP;
                edata.data = 0x80 | op & 7;
                if ((op & 0xF8) == 208) {
                    edata.data |= 0x20000;
                }
            } else if (op >= 192 && op <= 197) {
                edata.cmd = arm_exbuf_cmd.ARM_EXIDX_CMD_WREG_POP;
                edata.data = 0xA0 | op & 7;
            } else if (op == 198) {
                edata.cmd = arm_exbuf_cmd.ARM_EXIDX_CMD_WREG_POP;
                edata.data = instruction[++i] & 0xFF;
            } else if (op == 199) {
                if ((op2 = instruction[++i] & 0xFF) == 0 || (op2 & 0xF0) != 0) {
                    edata.cmd = arm_exbuf_cmd.ARM_EXIDX_CMD_RESERVED;
                } else {
                    edata.cmd = arm_exbuf_cmd.ARM_EXIDX_CMD_WCGR_POP;
                    edata.data = op2 & 0xF;
                }
            } else {
                edata.cmd = arm_exbuf_cmd.ARM_EXIDX_CMD_RESERVED;
            }
            if (this.arm_exidx_apply_cmd(emulator, edata, context)) continue;
            return null;
        }
        Long pc = context.loc[15];
        if (pc != null) {
            return unwinder.createFrame(UnidbgPointer.pointer(emulator, (Number)pc), UnidbgPointer.pointer(emulator, (long)context.cfa));
        }
        return null;
    }

    private boolean arm_exidx_apply_cmd(Emulator<?> emulator, arm_exbuf_data edata, DwarfCursor context) {
        switch (edata.cmd) {
            case ARM_EXIDX_CMD_FINISH: {
                if (context.loc[15] == null) {
                    context.loc[15] = context.loc[14];
                }
                context.ip = context.loc[15];
                if (!log.isDebugEnabled()) break;
                log.debug((Object)"finish");
                break;
            }
            case ARM_EXIDX_CMD_DATA_PUSH: {
                context.cfa -= (long)edata.data;
                if (!log.isDebugEnabled()) break;
                log.debug((Object)("vsp = vsp - " + edata.data));
                break;
            }
            case ARM_EXIDX_CMD_DATA_POP: {
                context.cfa += (long)edata.data;
                if (!log.isDebugEnabled()) break;
                log.debug((Object)("vsp = vsp + " + edata.data));
                break;
            }
            case ARM_EXIDX_CMD_REG_POP: {
                ArrayList<String> list = log.isDebugEnabled() ? new ArrayList<String>(16) : null;
                for (int m = 0; m < 16; ++m) {
                    if ((edata.data & 1 << m) == 0) continue;
                    String reg = "r" + m;
                    if (list != null) {
                        list.add(reg);
                    }
                    UnidbgPointer sp = UnidbgPointer.pointer(emulator, (long)context.cfa);
                    assert (sp != null);
                    long value = (long)sp.getInt(0L) & 0xFFFFFFFFL;
                    context.loc[m] = value;
                    context.cfa += 4L;
                    if (!log.isDebugEnabled()) continue;
                    log.debug((Object)("pop " + reg + " -> 0x" + Long.toHexString(value)));
                }
                if ((edata.data & 0x2000) != 0) {
                    context.cfa = context.loc[13];
                }
                if (!log.isDebugEnabled() || list == null) break;
                log.debug((Object)("pop " + ((Object)list).toString().replace('[', '{').replace(']', '}')));
                break;
            }
            case ARM_EXIDX_CMD_REG_TO_SP: {
                long value = context.loc[edata.data];
                context.loc[13] = value;
                if (log.isDebugEnabled()) {
                    log.debug((Object)("vsp = r" + edata.data + " [0x" + Long.toHexString(context.loc[13]) + "]"));
                }
                long sp = context.cfa;
                context.cfa = value;
                if (context.cfa != 0L) break;
                System.err.println("vsp is null: sp=0x" + Long.toHexString(sp));
                return false;
            }
            case ARM_EXIDX_CMD_VFP_POP: {
                int start = edata.data >> 4 & 0xF;
                int count = edata.data & 0xF;
                int end = start + count;
                for (int m = start; m <= end; ++m) {
                    context.cfa += 8L;
                }
                if ((edata.data & 0x20000) == 0) {
                    context.cfa += 4L;
                }
                if (!log.isDebugEnabled()) break;
                log.debug((Object)("pop {D" + start + "-D" + end + "}"));
                break;
            }
            case ARM_EXIDX_CMD_WREG_POP: {
                int start = edata.data >> 4 & 0xF;
                int count = edata.data & 0xF;
                int end = start + count;
                for (int m = start; m <= end; ++m) {
                    context.cfa += 8L;
                }
                break;
            }
            case ARM_EXIDX_CMD_WCGR_POP: {
                for (int m = 0; m < 4; ++m) {
                    if ((edata.data & 1 << m) == 0) continue;
                    context.cfa += 4L;
                }
                break;
            }
            case ARM_EXIDX_CMD_REFUSED: 
            case ARM_EXIDX_CMD_RESERVED: {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("cmd=" + (Object)((Object)edata.cmd)));
                }
                return false;
            }
            default: {
                log.warn((Object)("arm_exidx_decode cmd=" + (Object)((Object)edata.cmd)));
                return false;
            }
        }
        return true;
    }

    private static class arm_exbuf_data {
        arm_exbuf_cmd cmd;
        int data;

        private arm_exbuf_data() {
        }
    }

    static enum arm_exbuf_cmd {
        ARM_EXIDX_CMD_FINISH,
        ARM_EXIDX_CMD_DATA_PUSH,
        ARM_EXIDX_CMD_DATA_POP,
        ARM_EXIDX_CMD_REG_POP,
        ARM_EXIDX_CMD_REG_TO_SP,
        ARM_EXIDX_CMD_VFP_POP,
        ARM_EXIDX_CMD_WREG_POP,
        ARM_EXIDX_CMD_WCGR_POP,
        ARM_EXIDX_CMD_RESERVED,
        ARM_EXIDX_CMD_REFUSED;

    }
}

