/*
 * Decompiled with CFR 0.152.
 */
package net.fornwall.jelf;

import java.io.IOException;
import net.fornwall.jelf.ElfDynamicStructure;
import net.fornwall.jelf.ElfException;
import net.fornwall.jelf.ElfFile;
import net.fornwall.jelf.ElfHashTable;
import net.fornwall.jelf.ElfInitArray;
import net.fornwall.jelf.ElfParser;
import net.fornwall.jelf.ElfRelocation;
import net.fornwall.jelf.ElfStringTable;
import net.fornwall.jelf.ElfSymbol;
import net.fornwall.jelf.MemoizedObject;
import net.fornwall.jelf.SymbolLocator;

public final class ElfSection
implements SymbolLocator {
    public static final int SHT_NULL = 0;
    public static final int SHT_PROGBITS = 1;
    public static final int SHT_SYMTAB = 2;
    public static final int SHT_STRTAB = 3;
    public static final int SHT_RELA = 4;
    public static final int SHT_HASH = 5;
    public static final int SHT_DYNAMIC = 6;
    public static final int SHT_NOTE = 7;
    public static final int SHT_NOBITS = 8;
    public static final int SHT_REL = 9;
    public static final int SHT_SHLIB = 10;
    public static final int SHT_DYNSYM = 11;
    public static final int SHT_INIT_ARRAY = 14;
    public static final int SHT_FINI_ARRAY = 15;
    public static final int SHT_PREINIT_ARRAY = 16;
    public static final int SHT_GROUP = 17;
    public static final int SHT_SYMTAB_SHNDX = 18;
    public static final int SHT_GNU_verdef = 0x6FFFFFFD;
    public static final int SHT_GNU_verneed = 0x6FFFFFFE;
    public static final int SHT_GNU_versym = 0x6FFFFFFF;
    public static final int SHT_LOOS = 0x60000000;
    public static final int SHT_HIOS = 0x6FFFFFFF;
    public static final int SHT_LOPROC = 0x70000000;
    public static final int SHT_HIPROC = Integer.MAX_VALUE;
    public static final int SHT_LOUSER = Integer.MIN_VALUE;
    public static final int SHT_HIUSER = -1;
    public static final int FLAG_WRITE = 1;
    public static final int FLAG_ALLOC = 2;
    public static final int FLAG_EXEC_INSTR = 4;
    public static final int FLAG_MASK = -268435456;
    public static final String STRING_TABLE_NAME = ".strtab";
    public static final String DYNAMIC_STRING_TABLE_NAME = ".dynstr";
    public final int name_ndx;
    public final int type;
    public final long flags;
    public final long address;
    public final long section_offset;
    public final long size;
    public final int link;
    public final int info;
    public final long address_alignment;
    public final long entry_size;
    private MemoizedObject<ElfSymbol>[] symbols;
    private MemoizedObject<ElfStringTable> stringTable;
    private MemoizedObject<ElfHashTable> hashTable;
    private MemoizedObject<ElfRelocation>[] relocations;
    private MemoizedObject<ElfDynamicStructure> dynamicStructure;
    private MemoizedObject<ElfInitArray> initArray;
    private MemoizedObject<ElfInitArray> preInitArray;
    private final ElfFile elfHeader;

    ElfSection(final ElfFile elfFile, final ElfParser parser, long offset) {
        this.elfHeader = parser.elfFile;
        parser.seek(offset);
        this.name_ndx = parser.readInt();
        this.type = parser.readInt();
        this.flags = parser.readIntOrLong();
        this.address = parser.readIntOrLong();
        this.section_offset = parser.readIntOrLong();
        this.size = parser.readIntOrLong();
        this.link = parser.readInt();
        this.info = parser.readInt();
        this.address_alignment = parser.readIntOrLong();
        this.entry_size = parser.readIntOrLong();
        switch (this.type) {
            case 2: 
            case 11: {
                int num_entries = (int)(this.size / this.entry_size);
                this.symbols = MemoizedObject.uncheckedArray(num_entries);
                for (int i = 0; i < num_entries; ++i) {
                    final long symbolOffset = this.section_offset + (long)i * this.entry_size;
                    this.symbols[i] = new MemoizedObject<ElfSymbol>(){

                        @Override
                        public ElfSymbol computeValue() {
                            return new ElfSymbol(parser, symbolOffset, ElfSection.this.type);
                        }
                    };
                }
                break;
            }
            case 3: {
                this.stringTable = new MemoizedObject<ElfStringTable>(){

                    @Override
                    public ElfStringTable computeValue() throws IOException {
                        return new ElfStringTable(parser, ElfSection.this.section_offset, (int)ElfSection.this.size);
                    }
                };
                break;
            }
            case 5: {
                this.hashTable = new MemoizedObject<ElfHashTable>(){

                    @Override
                    public ElfHashTable computeValue() {
                        return new ElfHashTable(parser, ElfSection.this.section_offset, (int)ElfSection.this.size);
                    }
                };
                break;
            }
            case 6: {
                this.dynamicStructure = new MemoizedObject<ElfDynamicStructure>(){

                    @Override
                    protected ElfDynamicStructure computeValue() throws ElfException, IOException {
                        return new ElfDynamicStructure(elfFile, parser, ElfSection.this.section_offset, (int)ElfSection.this.size);
                    }
                };
                break;
            }
            case 4: 
            case 9: {
                int num_entries = (int)(this.size / this.entry_size);
                this.relocations = MemoizedObject.uncheckedArray(num_entries);
                for (int i = 0; i < num_entries; ++i) {
                    final long relocationOffset = this.section_offset + (long)i * this.entry_size;
                    this.relocations[i] = new MemoizedObject<ElfRelocation>(){

                        @Override
                        public ElfRelocation computeValue() throws IOException {
                            return new ElfRelocation(parser, relocationOffset, ElfSection.this.entry_size, parser.elfFile.getSection(ElfSection.this.link));
                        }
                    };
                }
                break;
            }
            case 14: {
                this.initArray = new MemoizedObject<ElfInitArray>(){

                    @Override
                    protected ElfInitArray computeValue() throws ElfException {
                        return new ElfInitArray(parser, ElfSection.this.section_offset, (int)ElfSection.this.size);
                    }
                };
                break;
            }
            case 16: {
                this.preInitArray = new MemoizedObject<ElfInitArray>(){

                    @Override
                    protected ElfInitArray computeValue() throws ElfException {
                        return new ElfInitArray(parser, ElfSection.this.section_offset, (int)ElfSection.this.size);
                    }
                };
                break;
            }
        }
    }

    public ElfInitArray getInitArray() throws IOException {
        return this.initArray.getValue();
    }

    public ElfInitArray getPreInitArray() throws IOException {
        return this.preInitArray.getValue();
    }

    public int getNumberOfSymbols() {
        return this.symbols != null ? this.symbols.length : 0;
    }

    @Override
    public ElfSymbol getELFSymbol(int index) throws IOException {
        return this.symbols[index].getValue();
    }

    @Override
    public ElfSymbol getELFSymbolByName(String name) throws IOException {
        int m = this.getNumberOfSymbols();
        for (int i = 0; i < m; ++i) {
            ElfSymbol symbol = this.getELFSymbol(i);
            if (name == null || !name.equals(symbol.getName())) continue;
            return symbol;
        }
        return null;
    }

    @Override
    public ElfSymbol getELFSymbolByAddr(long addr) throws IOException {
        int m = this.getNumberOfSymbols();
        for (int i = 0; i < m; ++i) {
            ElfSymbol symbol = this.getELFSymbol(i);
            if (addr < symbol.value || addr >= symbol.value + symbol.size) continue;
            return symbol;
        }
        return null;
    }

    public int getNumberOfRelocations() {
        return this.relocations != null ? this.relocations.length : 0;
    }

    public ElfRelocation getELFRelocation(int index) throws IOException {
        return this.relocations[index].getValue();
    }

    public ElfStringTable getStringTable() throws IOException {
        return this.stringTable != null ? this.stringTable.getValue() : null;
    }

    public ElfDynamicStructure getDynamicSection() throws IOException {
        return this.dynamicStructure != null ? this.dynamicStructure.getValue() : null;
    }

    public ElfHashTable getHashTable() throws IOException {
        return this.hashTable != null ? this.hashTable.getValue() : null;
    }

    public String getName() throws IOException {
        if (this.name_ndx == 0) {
            return null;
        }
        ElfStringTable tbl = this.elfHeader.getSectionNameStringTable();
        return tbl.get(this.name_ndx);
    }

    public String toString() {
        try {
            return "ElfSectionHeader[name=" + this.getName() + ", type=0x" + Long.toHexString(this.type) + "]";
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

