/*
 * Decompiled with CFR 0.152.
 */
package com.github.unidbg;

import capstone.api.Instruction;
import capstone.api.RegsAccess;
import com.alibaba.fastjson.util.IOUtils;
import com.github.unidbg.Emulator;
import com.github.unidbg.Module;
import com.github.unidbg.RegAccessPrinter;
import com.github.unidbg.TraceHook;
import com.github.unidbg.arm.InstructionVisitor;
import com.github.unidbg.arm.backend.Backend;
import com.github.unidbg.arm.backend.BackendException;
import com.github.unidbg.arm.backend.CodeHook;
import com.github.unidbg.arm.backend.UnHook;
import com.github.unidbg.listener.TraceCodeListener;
import com.github.unidbg.memory.Memory;
import java.io.Closeable;
import java.io.PrintStream;
import java.util.Arrays;

public class AssemblyCodeDumper
implements CodeHook,
TraceHook {
    private final Emulator<?> emulator;
    private final long traceBegin;
    private final long traceEnd;
    private final TraceCodeListener listener;
    private final int maxLengthLibraryName;
    private UnHook unHook;
    private PrintStream redirect;
    private RegAccessPrinter lastInstructionWritePrinter;

    public AssemblyCodeDumper(Emulator<?> emulator, long begin, long end, TraceCodeListener listener) {
        this.emulator = emulator;
        this.traceBegin = begin;
        this.traceEnd = end;
        this.listener = listener;
        Memory memory = emulator.getMemory();
        if (begin > end) {
            this.maxLengthLibraryName = memory.getMaxLengthLibraryName().length();
        } else {
            int value = 0;
            for (Module module : memory.getLoadedModules()) {
                int length;
                long max;
                long min = Math.max(begin, module.base);
                if (min >= (max = Math.min(end, module.base + module.size)) || (length = module.name.length()) <= value) continue;
                value = length;
            }
            this.maxLengthLibraryName = value;
        }
    }

    @Override
    public void onAttach(UnHook unHook) {
        if (this.unHook != null) {
            throw new IllegalStateException();
        }
        this.unHook = unHook;
    }

    @Override
    public void detach() {
        if (this.unHook != null) {
            this.unHook.unhook();
            this.unHook = null;
        }
    }

    @Override
    public void stopTrace() {
        this.detach();
        IOUtils.close((Closeable)this.redirect);
        this.redirect = null;
    }

    private boolean canTrace(long address) {
        return this.traceBegin > this.traceEnd || address >= this.traceBegin && address <= this.traceEnd;
    }

    @Override
    public void setRedirect(PrintStream redirect) {
        this.redirect = redirect;
    }

    @Override
    public void hook(final Backend backend, final long address, final int size, Object user) {
        if (this.canTrace(address)) {
            try {
                PrintStream out = System.err;
                if (this.redirect != null) {
                    out = this.redirect;
                }
                Object[] insns = this.emulator.printAssemble(out, address, size, this.maxLengthLibraryName, new InstructionVisitor(){

                    @Override
                    public void visitLast(StringBuilder builder) {
                        if (AssemblyCodeDumper.this.lastInstructionWritePrinter != null) {
                            AssemblyCodeDumper.this.lastInstructionWritePrinter.print(AssemblyCodeDumper.this.emulator, backend, builder, address);
                        }
                    }

                    @Override
                    public void visit(StringBuilder builder, Instruction ins) {
                        RegsAccess regsAccess = ins.regsAccess();
                        if (regsAccess != null) {
                            short[] regsRead = regsAccess.getRegsRead();
                            RegAccessPrinter readPrinter = new RegAccessPrinter(address, ins, regsRead, false);
                            readPrinter.print(AssemblyCodeDumper.this.emulator, backend, builder, address);
                            short[] regWrite = regsAccess.getRegsWrite();
                            if (regWrite.length > 0) {
                                AssemblyCodeDumper.this.lastInstructionWritePrinter = new RegAccessPrinter(address + (long)size, ins, regWrite, true);
                            }
                        }
                    }
                });
                if (this.listener != null) {
                    if (insns == null || insns.length != 1) {
                        throw new IllegalStateException("insns=" + Arrays.toString(insns));
                    }
                    this.listener.onInstruction(this.emulator, address, (Instruction)insns[0]);
                }
            }
            catch (BackendException e) {
                throw new IllegalStateException(e);
            }
        }
    }
}

