/*
 * Decompiled with CFR 0.152.
 */
package com.github.unidbg;

import com.github.unidbg.arm.ARMEmulator;
import com.github.unidbg.arm.backend.BackendFactory;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

public abstract class EmulatorBuilder<T extends ARMEmulator<?>> {
    protected final boolean is64Bit;
    protected String processName;
    protected File rootDir;
    protected final List<BackendFactory> backendFactories = new ArrayList<BackendFactory>(5);

    protected EmulatorBuilder(boolean is64Bit) {
        this.is64Bit = is64Bit;
    }

    public EmulatorBuilder<T> setProcessName(String processName) {
        this.processName = processName;
        return this;
    }

    public EmulatorBuilder<T> setRootDir(File rootDir) {
        this.rootDir = rootDir;
        return this;
    }

    public EmulatorBuilder<T> addBackendFactory(BackendFactory backendFactory) {
        this.backendFactories.add(backendFactory);
        return this;
    }

    public abstract T build();
}

