/*
 * Decompiled with CFR 0.152.
 */
package com.github.unidbg.arm;

import com.github.unidbg.Emulator;
import com.github.unidbg.Svc;
import com.github.unidbg.arm.ARM;
import com.github.unidbg.arm.Arm64Svc;
import com.github.unidbg.arm.ArmSvc;
import com.github.unidbg.arm.ThumbSvc;
import com.github.unidbg.arm.backend.Backend;
import com.github.unidbg.memory.MemRegion;
import com.github.unidbg.memory.SvcMemory;
import com.github.unidbg.pointer.UnidbgPointer;
import java.io.DataOutput;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ARMSvcMemory
implements SvcMemory {
    private static final Log log = LogFactory.getLog(ARMSvcMemory.class);
    private final Emulator<?> emulator;
    private UnidbgPointer base;
    private final long baseAddr;
    private final int size;
    private final List<MemRegion> memRegions = new ArrayList<MemRegion>();
    private final Map<String, UnidbgPointer> symbolMap = new HashMap<String, UnidbgPointer>();
    private int thumbSvcNumber = 0;
    private int armSvcNumber = 255;
    private final Map<Integer, Svc> svcMap = new HashMap<Integer, Svc>();

    public ARMSvcMemory(long base, int size, Emulator<?> emulator) {
        this.emulator = emulator;
        this.base = UnidbgPointer.pointer(emulator, base);
        assert (this.base != null);
        this.base.setSize(size);
        this.baseAddr = base;
        this.size = size;
        Backend backend = emulator.getBackend();
        backend.mem_map(base, size, 5);
    }

    @Override
    public void serialize(DataOutput out) {
        throw new UnsupportedOperationException();
    }

    @Override
    public long getBase() {
        return this.baseAddr;
    }

    @Override
    public int getSize() {
        return this.size;
    }

    @Override
    public MemRegion findRegion(long addr) {
        if (addr >= this.baseAddr && addr < this.baseAddr + (long)this.size) {
            for (MemRegion region : this.memRegions) {
                if (addr < region.begin || addr >= region.end) continue;
                return region;
            }
        }
        return null;
    }

    @Override
    public UnidbgPointer allocate(int size, final String label) {
        size = ARM.alignSize(size);
        UnidbgPointer pointer = this.base.share(0L, size);
        this.base = (UnidbgPointer)this.base.share(size);
        if (log.isDebugEnabled()) {
            log.debug((Object)("allocate size=" + size + ", label=" + label + ", base=" + this.base));
        }
        this.memRegions.add(new MemRegion(pointer.peer, pointer.peer + (long)size, 5, null, 0L){

            @Override
            public String getName() {
                return label;
            }
        });
        return pointer;
    }

    @Override
    public UnidbgPointer allocateSymbolName(String name) {
        UnidbgPointer ptr = this.symbolMap.get(name);
        if (ptr == null) {
            byte[] nameBytes = name.getBytes();
            int size = nameBytes.length + 1;
            ptr = this.allocate(size, "Symbol." + name);
            ptr.write(0L, Arrays.copyOf(nameBytes, size), 0, size);
            this.symbolMap.put(name, ptr);
        }
        return ptr;
    }

    @Override
    public Svc getSvc(int svcNumber) {
        return this.svcMap.get(svcNumber);
    }

    @Override
    public UnidbgPointer registerSvc(Svc svc) {
        int number;
        if (svc instanceof ThumbSvc) {
            if (this.emulator.is64Bit()) {
                throw new IllegalStateException("is 64 bit mode");
            }
            if (++this.thumbSvcNumber == 128) {
                ++this.thumbSvcNumber;
            }
            number = this.thumbSvcNumber;
        } else if (svc instanceof ArmSvc || svc instanceof Arm64Svc) {
            if (svc instanceof ArmSvc && this.emulator.is64Bit()) {
                throw new IllegalStateException("is 64 bit mode");
            }
            if (svc instanceof Arm64Svc && !this.emulator.is64Bit()) {
                throw new IllegalStateException("is 32 bit mode");
            }
            if (++this.armSvcNumber == 128) {
                ++this.armSvcNumber;
            }
            number = this.armSvcNumber;
        } else {
            throw new IllegalStateException("svc=" + svc);
        }
        if (this.svcMap.put(number, svc) != null) {
            throw new IllegalStateException();
        }
        return svc.onRegister(this, number);
    }

    @Override
    public final UnidbgPointer writeStackString(String str) {
        byte[] data = str.getBytes(StandardCharsets.UTF_8);
        return this.writeStackBytes(Arrays.copyOf(data, data.length + 1));
    }

    @Override
    public final UnidbgPointer writeStackBytes(byte[] data) {
        UnidbgPointer pointer = this.allocate(data.length, "writeStackBytes: " + Hex.encodeHexString((byte[])data));
        assert (pointer != null);
        pointer.write(0L, data, 0, data.length);
        return pointer;
    }
}

