/*
 * Decompiled with CFR 0.152.
 */
package com.github.unidbg.arm;

import capstone.api.Disassembler;
import capstone.api.DisassemblerFactory;
import capstone.api.Instruction;
import com.alibaba.fastjson.util.IOUtils;
import com.github.unidbg.AbstractEmulator;
import com.github.unidbg.Family;
import com.github.unidbg.Module;
import com.github.unidbg.arm.ARM;
import com.github.unidbg.arm.ARMEmulator;
import com.github.unidbg.arm.Arm64Svc;
import com.github.unidbg.arm.InstructionVisitor;
import com.github.unidbg.arm.SimpleARM64Debugger;
import com.github.unidbg.arm.backend.Backend;
import com.github.unidbg.arm.backend.BackendFactory;
import com.github.unidbg.arm.backend.EventMemHook;
import com.github.unidbg.arm.backend.UnHook;
import com.github.unidbg.arm.context.BackendArm64RegisterContext;
import com.github.unidbg.arm.context.RegisterContext;
import com.github.unidbg.debugger.Debugger;
import com.github.unidbg.file.NewFileIO;
import com.github.unidbg.memory.Memory;
import com.github.unidbg.pointer.UnidbgPointer;
import com.github.unidbg.spi.Dlfcn;
import com.github.unidbg.spi.SyscallHandler;
import com.github.unidbg.thread.Entry;
import com.github.unidbg.thread.Function64;
import com.github.unidbg.unix.UnixSyscallHandler;
import com.github.unidbg.unwind.SimpleARM64Unwinder;
import com.github.unidbg.unwind.Unwinder;
import com.sun.jna.Pointer;
import java.io.Closeable;
import java.io.File;
import java.io.PrintStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Collection;
import java.util.Date;
import keystone.Keystone;
import keystone.KeystoneArchitecture;
import keystone.KeystoneEncoded;
import keystone.KeystoneMode;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class AbstractARM64Emulator<T extends NewFileIO>
extends AbstractEmulator<T>
implements ARMEmulator<T> {
    private static final Log log = LogFactory.getLog(AbstractARM64Emulator.class);
    protected final Memory memory;
    private final UnixSyscallHandler<T> syscallHandler;
    private static final long LR = 0x7FFFF0000L;
    private final Dlfcn dlfcn;
    private Disassembler arm64DisassemblerCache;

    public AbstractARM64Emulator(String processName, File rootDir, Family family, Collection<BackendFactory> backendFactories, String ... envs) {
        super(true, processName, 0xFFFE0000L, 65536, rootDir, family, backendFactories);
        this.backend.switchUserMode();
        this.backend.hook_add_new(new EventMemHook(){

            @Override
            public boolean hook(Backend backend, long address, int size, long value, Object user, EventMemHook.UnmappedType unmappedType) {
                log.warn((Object)((Object)((Object)unmappedType) + " memory failed: address=0x" + Long.toHexString(address) + ", size=" + size + ", value=0x" + Long.toHexString(value)));
                if (LogFactory.getLog(AbstractEmulator.class).isDebugEnabled()) {
                    AbstractARM64Emulator.this.attach().debug();
                }
                return false;
            }

            @Override
            public void onAttach(UnHook unHook) {
            }

            @Override
            public void detach() {
                throw new UnsupportedOperationException();
            }
        }, 112, null);
        this.syscallHandler = this.createSyscallHandler(this.svcMemory);
        this.backend.enableVFP();
        this.memory = this.createMemory(this.syscallHandler, envs);
        this.dlfcn = this.createDyld(this.svcMemory);
        this.memory.addHookListener(this.dlfcn);
        this.backend.hook_add_new(this.syscallHandler, this);
        this.setupTraps();
    }

    private synchronized Disassembler createArm64Disassembler() {
        if (this.arm64DisassemblerCache == null) {
            this.arm64DisassemblerCache = DisassemblerFactory.createArm64Disassembler();
            this.arm64DisassemblerCache.setDetail(true);
        }
        return this.arm64DisassemblerCache;
    }

    protected void setupTraps() {
        int size = this.getPageAlign();
        this.backend.mem_map(0x7FFFF0000L, size, 5);
        ByteBuffer buffer = ByteBuffer.allocate(size);
        buffer.order(ByteOrder.LITTLE_ENDIAN);
        int code = Arm64Svc.assembleSvc(0);
        for (int i = 0; i < size; i += 4) {
            buffer.putInt(code);
        }
        this.memory.pointer(0x7FFFF0000L).write(buffer.array());
    }

    @Override
    protected RegisterContext createRegisterContext(Backend backend) {
        return new BackendArm64RegisterContext(backend, this);
    }

    @Override
    public Dlfcn getDlfcn() {
        return this.dlfcn;
    }

    @Override
    protected final byte[] assemble(Iterable<String> assembly) {
        try (Keystone keystone = new Keystone(KeystoneArchitecture.Arm64, KeystoneMode.LittleEndian);){
            KeystoneEncoded encoded = keystone.assemble(assembly);
            byte[] byArray = encoded.getMachineCode();
            return byArray;
        }
    }

    @Override
    protected Debugger createConsoleDebugger() {
        return new SimpleARM64Debugger(this){

            @Override
            protected void dumpClass(String className) {
                AbstractARM64Emulator.this.dumpClass(className);
            }

            @Override
            protected void searchClass(String keywords) {
                AbstractARM64Emulator.this.searchClass(keywords);
            }

            @Override
            protected void dumpGPBProtobufMsg(String className) {
                AbstractARM64Emulator.this.dumpGPBProtobufMsg(className);
            }
        };
    }

    @Override
    protected void closeInternal() {
        this.syscallHandler.destroy();
        IOUtils.close((Closeable)this.arm64DisassemblerCache);
    }

    @Override
    public Module loadLibrary(File libraryFile) {
        return this.memory.load(libraryFile);
    }

    @Override
    public Module loadLibrary(File libraryFile, boolean forceCallInit) {
        return this.memory.load(libraryFile, forceCallInit);
    }

    @Override
    public Memory getMemory() {
        return this.memory;
    }

    @Override
    public SyscallHandler<T> getSyscallHandler() {
        return this.syscallHandler;
    }

    @Override
    public final void showRegs() {
        this.showRegs((int[])null);
    }

    @Override
    public final void showRegs(int ... regs) {
        ARM.showRegs64(this, regs);
    }

    @Override
    public Instruction[] printAssemble(PrintStream out, long address, int size, int maxLengthLibraryName, InstructionVisitor visitor) {
        Instruction[] insns = this.disassemble(address, size, 0L);
        this.printAssemble(out, insns, address, maxLengthLibraryName, visitor);
        return insns;
    }

    @Override
    public Instruction[] disassemble(long address, int size, long count) {
        byte[] code = this.backend.mem_read(address, size);
        return this.createArm64Disassembler().disasm(code, address, count);
    }

    @Override
    public Instruction[] disassemble(long address, byte[] code, boolean thumb, long count) {
        if (thumb) {
            throw new IllegalStateException();
        }
        return this.createArm64Disassembler().disasm(code, address, count);
    }

    private void printAssemble(PrintStream out, Instruction[] insns, long address, int maxLengthLibraryName, InstructionVisitor visitor) {
        StringBuilder builder = new StringBuilder();
        for (Instruction ins : insns) {
            if (visitor != null) {
                visitor.visitLast(builder);
            }
            builder.append('\n');
            builder.append(this.dateFormat.format(new Date()));
            builder.append(ARM.assembleDetail(this, ins, address, false, maxLengthLibraryName));
            if (visitor != null) {
                visitor.visit(builder, ins);
            }
            address += (long)ins.getSize();
        }
        out.print(builder);
    }

    @Override
    public int getPointerSize() {
        return 8;
    }

    @Override
    protected int getPageAlignInternal() {
        return 4096;
    }

    @Override
    public Number eFunc(long begin, Number ... arguments) {
        return this.runMainForResult(new Function64(this.getPid(), begin, 0x7FFFF0000L, this.isPaddingArgument(), arguments));
    }

    @Override
    public Number eEntry(long begin, long sp) {
        return this.runMainForResult(new Entry(this.getPid(), begin, 0x7FFFF0000L, sp));
    }

    @Override
    public Pointer getStackPointer() {
        return UnidbgPointer.register(this, 4);
    }

    @Override
    public Unwinder getUnwinder() {
        return new SimpleARM64Unwinder(this);
    }

    @Override
    public long getReturnAddress() {
        return 0x7FFFF0000L;
    }
}

