/*
 * Decompiled with CFR 0.152.
 */
package com.github.unidbg.arm;

import capstone.api.Disassembler;
import capstone.api.DisassemblerFactory;
import capstone.api.Instruction;
import com.alibaba.fastjson.util.IOUtils;
import com.github.unidbg.AbstractEmulator;
import com.github.unidbg.Family;
import com.github.unidbg.Module;
import com.github.unidbg.arm.ARM;
import com.github.unidbg.arm.ARMEmulator;
import com.github.unidbg.arm.ArmSvc;
import com.github.unidbg.arm.InstructionVisitor;
import com.github.unidbg.arm.SimpleARMDebugger;
import com.github.unidbg.arm.backend.Backend;
import com.github.unidbg.arm.backend.BackendFactory;
import com.github.unidbg.arm.backend.EventMemHook;
import com.github.unidbg.arm.backend.UnHook;
import com.github.unidbg.arm.context.BackendArm32RegisterContext;
import com.github.unidbg.arm.context.RegisterContext;
import com.github.unidbg.debugger.Debugger;
import com.github.unidbg.file.NewFileIO;
import com.github.unidbg.memory.Memory;
import com.github.unidbg.pointer.UnidbgPointer;
import com.github.unidbg.spi.Dlfcn;
import com.github.unidbg.spi.SyscallHandler;
import com.github.unidbg.thread.Entry;
import com.github.unidbg.thread.Function32;
import com.github.unidbg.unix.UnixSyscallHandler;
import com.github.unidbg.unwind.SimpleARMUnwinder;
import com.github.unidbg.unwind.Unwinder;
import com.sun.jna.Pointer;
import java.io.Closeable;
import java.io.File;
import java.io.PrintStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Collection;
import java.util.Date;
import keystone.Keystone;
import keystone.KeystoneArchitecture;
import keystone.KeystoneEncoded;
import keystone.KeystoneMode;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class AbstractARMEmulator<T extends NewFileIO>
extends AbstractEmulator<T>
implements ARMEmulator<T> {
    private static final Log log = LogFactory.getLog(AbstractARMEmulator.class);
    private static final long LR = 0xFFFF0000L;
    protected final Memory memory;
    private final UnixSyscallHandler<T> syscallHandler;
    private final Dlfcn dlfcn;
    private Disassembler armDisassemblerCache;
    private Disassembler thumbDisassemblerCache;

    public AbstractARMEmulator(String processName, File rootDir, Family family, Collection<BackendFactory> backendFactories, String ... envs) {
        super(false, processName, 0xFFFE0000L, 65536, rootDir, family, backendFactories);
        this.backend.switchUserMode();
        this.backend.hook_add_new(new EventMemHook(){

            @Override
            public boolean hook(Backend backend, long address, int size, long value, Object user, EventMemHook.UnmappedType unmappedType) {
                Object context = AbstractARMEmulator.this.getContext();
                log.warn((Object)((Object)((Object)unmappedType) + " memory failed: address=0x" + Long.toHexString(address) + ", size=" + size + ", value=0x" + Long.toHexString(value) + ", PC=" + context.getPCPointer() + ", LR=" + context.getLRPointer()));
                if (LogFactory.getLog(AbstractEmulator.class).isDebugEnabled()) {
                    AbstractARMEmulator.this.attach().debug();
                }
                return false;
            }

            @Override
            public void onAttach(UnHook unHook) {
            }

            @Override
            public void detach() {
                throw new UnsupportedOperationException();
            }
        }, 112, null);
        this.syscallHandler = this.createSyscallHandler(this.svcMemory);
        this.backend.enableVFP();
        this.memory = this.createMemory(this.syscallHandler, envs);
        this.dlfcn = this.createDyld(this.svcMemory);
        this.memory.addHookListener(this.dlfcn);
        this.backend.hook_add_new(this.syscallHandler, this);
        this.setupTraps();
    }

    private synchronized Disassembler createThumbCapstone() {
        if (this.thumbDisassemblerCache == null) {
            this.thumbDisassemblerCache = DisassemblerFactory.createArmDisassembler((boolean)true);
            this.thumbDisassemblerCache.setDetail(true);
        }
        return this.thumbDisassemblerCache;
    }

    private synchronized Disassembler createArmCapstone() {
        if (this.armDisassemblerCache == null) {
            this.armDisassemblerCache = DisassemblerFactory.createArmDisassembler((boolean)false);
            this.armDisassemblerCache.setDetail(true);
        }
        return this.armDisassemblerCache;
    }

    @Override
    protected RegisterContext createRegisterContext(Backend backend) {
        return new BackendArm32RegisterContext(backend, this);
    }

    @Override
    public Dlfcn getDlfcn() {
        return this.dlfcn;
    }

    protected void setupTraps() {
        int size = 65536;
        this.backend.mem_map(0xFFFF0000L, size, 5);
        int code = ArmSvc.assembleSvc(0);
        ByteBuffer buffer = ByteBuffer.allocate(size);
        buffer.order(ByteOrder.LITTLE_ENDIAN);
        for (int i = 0; i < size; i += 4) {
            buffer.putInt(code);
        }
        this.memory.pointer(0xFFFF0000L).write(buffer.array());
    }

    @Override
    protected final byte[] assemble(Iterable<String> assembly) {
        try (Keystone keystone = new Keystone(KeystoneArchitecture.Arm, KeystoneMode.Arm);){
            KeystoneEncoded encoded = keystone.assemble(assembly);
            byte[] byArray = encoded.getMachineCode();
            return byArray;
        }
    }

    @Override
    protected Debugger createConsoleDebugger() {
        return new SimpleARMDebugger(this){

            @Override
            protected void dumpClass(String className) {
                AbstractARMEmulator.this.dumpClass(className);
            }

            @Override
            protected void searchClass(String keywords) {
                AbstractARMEmulator.this.searchClass(keywords);
            }
        };
    }

    @Override
    protected void closeInternal() {
        this.syscallHandler.destroy();
        IOUtils.close((Closeable)this.thumbDisassemblerCache);
        IOUtils.close((Closeable)this.armDisassemblerCache);
    }

    @Override
    public Module loadLibrary(File libraryFile) {
        return this.memory.load(libraryFile);
    }

    @Override
    public Module loadLibrary(File libraryFile, boolean forceCallInit) {
        return this.memory.load(libraryFile, forceCallInit);
    }

    @Override
    public Memory getMemory() {
        return this.memory;
    }

    @Override
    public SyscallHandler<T> getSyscallHandler() {
        return this.syscallHandler;
    }

    @Override
    public final void showRegs() {
        this.showRegs((int[])null);
    }

    @Override
    public final void showRegs(int ... regs) {
        ARM.showRegs(this, regs);
    }

    @Override
    public Instruction[] printAssemble(PrintStream out, long address, int size, int maxLengthLibraryName, InstructionVisitor visitor) {
        Instruction[] insns = this.disassemble(address, size, 0L);
        this.printAssemble(out, insns, address, ARM.isThumb(this.backend), maxLengthLibraryName, visitor);
        return insns;
    }

    @Override
    public Instruction[] disassemble(long address, int size, long count) {
        boolean thumb = ARM.isThumb(this.backend);
        byte[] code = this.backend.mem_read(address, size);
        return thumb ? this.createThumbCapstone().disasm(code, address, count) : this.createArmCapstone().disasm(code, address, count);
    }

    @Override
    public Instruction[] disassemble(long address, byte[] code, boolean thumb, long count) {
        return thumb ? this.createThumbCapstone().disasm(code, address, count) : this.createArmCapstone().disasm(code, address, count);
    }

    private void printAssemble(PrintStream out, Instruction[] insns, long address, boolean thumb, int maxLengthLibraryName, InstructionVisitor visitor) {
        StringBuilder builder = new StringBuilder();
        for (Instruction ins : insns) {
            if (visitor != null) {
                visitor.visitLast(builder);
            }
            builder.append('\n');
            builder.append(this.dateFormat.format(new Date()));
            builder.append(ARM.assembleDetail(this, ins, address, thumb, maxLengthLibraryName));
            if (visitor != null) {
                visitor.visit(builder, ins);
            }
            address += (long)ins.getSize();
        }
        out.print(builder);
    }

    @Override
    public Number eFunc(long begin, Number ... arguments) {
        return this.runMainForResult(new Function32(this.getPid(), begin, 0xFFFF0000L, this.isPaddingArgument(), arguments));
    }

    @Override
    public Number eEntry(long begin, long sp) {
        return this.runMainForResult(new Entry(this.getPid(), begin, 0xFFFF0000L, sp));
    }

    @Override
    public int getPointerSize() {
        return 4;
    }

    @Override
    protected int getPageAlignInternal() {
        return 4096;
    }

    @Override
    public Pointer getStackPointer() {
        return UnidbgPointer.register(this, 12);
    }

    @Override
    public Unwinder getUnwinder() {
        return new SimpleARMUnwinder(this);
    }

    @Override
    public long getReturnAddress() {
        return 0xFFFF0000L;
    }
}

