/*
 * Decompiled with CFR 0.152.
 */
package com.github.unidbg.arm;

import com.github.unidbg.ByteArrayNumber;
import com.github.unidbg.StringNumber;
import com.github.unidbg.memory.Memory;
import com.github.unidbg.pointer.UnidbgPointer;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Arguments {
    private static final Log log = LogFactory.getLog(Arguments.class);
    public final Number[] args;
    public final List<Number> pointers = new ArrayList<Number>(10);

    Arguments(Memory memory, Number[] args) {
        for (int i = 0; args != null && i < args.length; ++i) {
            UnidbgPointer pointer;
            if (args[i] instanceof StringNumber) {
                StringNumber str = (StringNumber)args[i];
                pointer = memory.writeStackString(str.value);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("map arg" + (i + 1) + ": " + pointer + " -> " + args[i]));
                }
                args[i] = pointer.peer;
                this.pointers.add(pointer.peer);
                continue;
            }
            if (args[i] instanceof ByteArrayNumber) {
                ByteArrayNumber array = (ByteArrayNumber)args[i];
                pointer = memory.writeStackBytes(array.value);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("map arg" + (i + 1) + ": " + pointer + " -> " + Hex.encodeHexString((byte[])array.value)));
                }
                args[i] = pointer.peer;
                this.pointers.add(pointer.peer);
                continue;
            }
            if (args[i] != null) continue;
            args[i] = 0;
        }
        this.args = args;
    }
}

