/*
 * Decompiled with CFR 0.152.
 */
package com.github.unidbg.arm;

import capstone.api.Instruction;
import com.github.unidbg.Emulator;
import com.github.unidbg.arm.backend.Backend;

public class CodeHistory {
    public final long address;
    private final int size;
    final boolean thumb;

    CodeHistory(long address, int size, boolean thumb) {
        this.address = address;
        this.size = size;
        this.thumb = thumb;
    }

    Instruction disassemble(Emulator<?> emulator) {
        Backend backend = emulator.getBackend();
        byte[] code = backend.mem_read(this.address, this.size);
        Instruction[] insns = emulator.disassemble(this.address, code, this.thumb, 1L);
        if (insns.length == 0) {
            return null;
        }
        return insns[0];
    }
}

