/*
 * Decompiled with CFR 0.152.
 */
package com.github.unidbg.arm;

import com.github.unidbg.arm.backend.Backend;

public class Cpsr {
    private final Backend backend;
    private final int regId;
    private int value;
    private static final int A32_BIT = 4;
    private static final int THUMB_BIT = 5;
    private static final int NEGATIVE_BIT = 31;
    private static final int ZERO_BIT = 30;
    private static final int CARRY_BIT = 29;
    private static final int OVERFLOW_BIT = 28;
    private static final int MODE_MASK = 31;

    private static boolean hasBit(int value, int offset) {
        return (value >> offset & 1) == 1;
    }

    private void setBit(int offset) {
        int mask = 1 << offset;
        this.value |= mask;
        this.backend.reg_write(this.regId, this.value);
    }

    private void clearBit(int offset) {
        int mask = ~(1 << offset);
        this.value &= mask;
        this.backend.reg_write(this.regId, this.value);
    }

    public static Cpsr getArm(Backend backend) {
        return new Cpsr(backend, 3);
    }

    public static Cpsr getArm64(Backend backend) {
        return new Cpsr(backend, 3);
    }

    private Cpsr(Backend backend, int regId) {
        this.backend = backend;
        this.regId = regId;
        this.value = backend.reg_read(regId).intValue();
    }

    public int getValue() {
        return this.value;
    }

    public boolean isA32() {
        return Cpsr.hasBit(this.value, 4);
    }

    public boolean isThumb() {
        return Cpsr.hasBit(this.value, 5);
    }

    public boolean isNegative() {
        return Cpsr.hasBit(this.value, 31);
    }

    void setNegative(boolean on) {
        if (on) {
            this.setBit(31);
        } else {
            this.clearBit(31);
        }
    }

    public boolean isZero() {
        return Cpsr.hasBit(this.value, 30);
    }

    void setZero(boolean on) {
        if (on) {
            this.setBit(30);
        } else {
            this.clearBit(30);
        }
    }

    public boolean hasCarry() {
        return Cpsr.hasBit(this.value, 29);
    }

    public void setCarry(boolean on) {
        if (on) {
            this.setBit(29);
        } else {
            this.clearBit(29);
        }
    }

    public boolean isOverflow() {
        return Cpsr.hasBit(this.value, 28);
    }

    void setOverflow(boolean on) {
        if (on) {
            this.setBit(28);
        } else {
            this.clearBit(28);
        }
    }

    public int getMode() {
        return this.value & 0x1F;
    }

    public int getEL() {
        return this.value >> 2 & 3;
    }

    public final void switchUserMode() {
        this.value &= 0xFFFFFFE0;
        this.value |= 0x10;
        this.backend.reg_write(this.regId, this.value);
    }
}

