/*
 * Decompiled with CFR 0.152.
 */
package com.github.unidbg.arm;

import com.github.unidbg.Emulator;
import com.github.unidbg.arm.backend.Backend;
import com.github.unidbg.pointer.UnidbgPointer;
import java.util.HashMap;
import java.util.Map;

public final class RegContext {
    private final Backend backend;
    private final Map<Integer, UnidbgPointer> ctx;

    public static RegContext backupContext(Emulator<?> emulator, int ... regs) {
        HashMap<Integer, UnidbgPointer> ctx = new HashMap<Integer, UnidbgPointer>();
        for (int reg : regs) {
            ctx.put(reg, UnidbgPointer.register(emulator, reg));
        }
        return new RegContext(emulator.getBackend(), ctx);
    }

    private RegContext(Backend backend, Map<Integer, UnidbgPointer> ctx) {
        this.backend = backend;
        this.ctx = ctx;
    }

    public void restore() {
        for (Map.Entry<Integer, UnidbgPointer> entry : this.ctx.entrySet()) {
            UnidbgPointer ptr = entry.getValue();
            this.backend.reg_write(entry.getKey(), ptr == null ? 0L : ptr.peer);
        }
    }
}

