/*
 * Decompiled with CFR 0.152.
 */
package com.github.unidbg.arm;

import capstone.api.Instruction;
import com.github.unidbg.AbstractEmulator;
import com.github.unidbg.Emulator;
import com.github.unidbg.arm.ARM;
import com.github.unidbg.arm.FunctionCall;
import com.github.unidbg.arm.backend.Backend;
import com.github.unidbg.arm.backend.BackendException;
import com.github.unidbg.arm.backend.CodeHook;
import com.github.unidbg.arm.backend.UnHook;
import com.github.unidbg.debugger.FunctionCallListener;
import com.github.unidbg.pointer.UnidbgPointer;
import com.github.unidbg.thread.BaseTask;
import com.github.unidbg.thread.RunnableTask;
import com.github.unidbg.utils.Inspector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class TraceFunctionCall
implements CodeHook {
    private static final Log log = LogFactory.getLog(TraceFunctionCall.class);
    protected final Emulator<?> emulator;
    private final FunctionCallListener listener;
    private boolean detectedIllegalState;
    private UnHook unHook;

    TraceFunctionCall(Emulator<?> emulator, FunctionCallListener listener) {
        this.emulator = emulator;
        this.listener = listener;
    }

    final void pushFunction(long callerAddress, long functionAddress, long returnAddress, Number[] args) {
        RunnableTask runningTask = this.emulator.getThreadDispatcher().getRunningTask();
        FunctionCall call = new FunctionCall(callerAddress, functionAddress, returnAddress, args);
        runningTask.pushFunction(this.emulator, call);
        this.listener.onDebugPushFunction(this.emulator, call);
        this.listener.onCall(this.emulator, callerAddress, functionAddress);
    }

    @Override
    public void hook(Backend backend, long address, int size, Object user) {
        if (this.detectedIllegalState) {
            return;
        }
        RunnableTask runningTask = this.emulator.getThreadDispatcher().getRunningTask();
        FunctionCall call = runningTask.popFunction(this.emulator, address);
        if (call != null) {
            this.listener.onDebugPopFunction(this.emulator, address, call);
            if (call.returnAddress != address) {
                log.warn((Object)("Illegal state address=" + UnidbgPointer.pointer(this.emulator, address) + ", call=" + call.toReadableString(this.emulator)));
                if (LogFactory.getLog(AbstractEmulator.class).isDebugEnabled() || LogFactory.getLog(BaseTask.class).isDebugEnabled()) {
                    this.emulator.attach().debug();
                }
                this.detectedIllegalState = true;
                return;
            }
            this.listener.postCall(this.emulator, call.callerAddress, call.functionAddress, call.args);
        }
        try {
            Instruction instruction = this.disassemble(address, size);
            if (instruction != null) {
                if (log.isDebugEnabled() && !instruction.getMnemonic().startsWith("bl")) {
                    log.warn((Object)Inspector.inspectString(backend.mem_read(address, size), "Invalid " + instruction + ": thumb=" + ARM.isThumb(backend)));
                }
                this.onInstruction(instruction);
            } else if (log.isDebugEnabled()) {
                Instruction[] instructions = this.emulator.disassemble(address, size, 1L);
                if (instructions.length != 1) {
                    return;
                }
                instruction = instructions[0];
                String mnemonic = instruction.getMnemonic();
                if (this.emulator.is32Bit()) {
                    if (!(!mnemonic.startsWith("bl") || mnemonic.startsWith("ble") || mnemonic.startsWith("blt") || mnemonic.startsWith("bls") || mnemonic.startsWith("blo"))) {
                        log.warn((Object)Inspector.inspectString(backend.mem_read(address, size), "Unsupported " + instruction + ": thumb=" + ARM.isThumb(backend)));
                    }
                } else if (mnemonic.startsWith("bl")) {
                    log.warn((Object)Inspector.inspectString(backend.mem_read(address, size), "Unsupported " + instruction + ": thumb=" + ARM.isThumb(backend)));
                }
            }
        }
        catch (BackendException e) {
            throw new IllegalStateException(e);
        }
    }

    protected abstract Instruction disassemble(long var1, int var3);

    protected abstract void onInstruction(Instruction var1);

    @Override
    public void onAttach(UnHook unHook) {
        this.unHook = unHook;
    }

    @Override
    public void detach() {
        if (this.unHook != null) {
            this.unHook.unhook();
            this.unHook = null;
        }
    }
}

