/*
 * Decompiled with CFR 0.152.
 */
package com.github.unidbg.hook.hookzz;

import com.github.unidbg.Emulator;
import com.github.unidbg.Family;
import com.github.unidbg.Svc;
import com.github.unidbg.Symbol;
import com.github.unidbg.arm.Arm64Svc;
import com.github.unidbg.arm.ArmSvc;
import com.github.unidbg.arm.context.RegisterContext;
import com.github.unidbg.hook.BaseHook;
import com.github.unidbg.hook.ReplaceCallback;
import com.github.unidbg.hook.hookzz.Arm64HookEntryInfo;
import com.github.unidbg.hook.hookzz.ArmHookEntryInfo;
import com.github.unidbg.hook.hookzz.HookZzArm32RegisterContextImpl;
import com.github.unidbg.hook.hookzz.HookZzArm64RegisterContextImpl;
import com.github.unidbg.hook.hookzz.IHookZz;
import com.github.unidbg.hook.hookzz.InstrumentCallback;
import com.github.unidbg.hook.hookzz.WrapCallback;
import com.github.unidbg.memory.SvcMemory;
import com.github.unidbg.pointer.UnidbgPointer;
import com.sun.jna.Pointer;
import java.util.Stack;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class Dobby
extends BaseHook
implements IHookZz {
    private static final Log log = LogFactory.getLog(Dobby.class);
    private static final int RT_SUCCESS = 0;
    private final Symbol dobby_enable_near_branch_trampoline;
    private final Symbol dobby_disable_near_branch_trampoline;
    private final Symbol switch_to_file_log;
    private final Symbol dobbyHook;
    private final Symbol dobbyInstrument;

    public static Dobby getInstance(Emulator<?> emulator) {
        Dobby dobby = (Dobby)emulator.get(Dobby.class.getName());
        if (dobby == null) {
            dobby = new Dobby(emulator);
            emulator.set(Dobby.class.getName(), dobby);
        }
        return dobby;
    }

    private Dobby(Emulator<?> emulator) {
        super(emulator, "libdobby");
        boolean isIOS = emulator.getFamily() == Family.iOS;
        this.dobby_enable_near_branch_trampoline = this.module.findSymbolByName(isIOS ? "_dobby_enable_near_branch_trampoline" : "dobby_enable_near_branch_trampoline", false);
        this.dobby_disable_near_branch_trampoline = this.module.findSymbolByName(isIOS ? "_dobby_disable_near_branch_trampoline" : "dobby_disable_near_branch_trampoline", false);
        this.dobbyHook = this.module.findSymbolByName(isIOS ? "_DobbyHook" : "DobbyHook", false);
        this.dobbyInstrument = this.module.findSymbolByName(isIOS ? "_DobbyInstrument" : "DobbyInstrument", false);
        if (log.isDebugEnabled()) {
            log.debug((Object)("dobbyHook=" + this.dobbyHook + ", dobbyInstrument=" + this.dobbyInstrument));
        }
        if (this.dobby_enable_near_branch_trampoline == null && emulator.is64Bit()) {
            throw new IllegalStateException("dobby_enable_near_branch_trampoline is null");
        }
        if (this.dobby_disable_near_branch_trampoline == null && emulator.is64Bit()) {
            throw new IllegalStateException("dobby_disable_near_branch_trampoline is null");
        }
        if (this.dobbyHook == null) {
            throw new IllegalStateException("dobbyHook is null");
        }
        if (this.dobbyInstrument == null) {
            throw new IllegalStateException("dobbyInstrument is null");
        }
        this.switch_to_file_log = this.module.findSymbolByName(isIOS ? "_switch_to_file_log" : "switch_to_file_log", false);
    }

    @Override
    public void switch_to_file_log(String path) {
        if (this.switch_to_file_log == null) {
            throw new UnsupportedOperationException();
        }
        this.switch_to_file_log.call(this.emulator, path);
    }

    @Override
    public void enable_arm_arm64_b_branch() {
        if (this.dobby_enable_near_branch_trampoline == null) {
            return;
        }
        int ret = this.dobby_enable_near_branch_trampoline.call(this.emulator, new Object[0]).intValue();
        if (ret != 0) {
            throw new IllegalStateException("ret=" + ret);
        }
    }

    @Override
    public void disable_arm_arm64_b_branch() {
        if (this.dobby_disable_near_branch_trampoline == null) {
            return;
        }
        int ret = this.dobby_disable_near_branch_trampoline.call(this.emulator, new Object[0]).intValue();
        if (ret != 0) {
            throw new IllegalStateException("ret=" + ret);
        }
    }

    @Override
    public void replace(long functionAddress, ReplaceCallback callback) {
        this.replace(functionAddress, callback, false);
    }

    @Override
    public void replace(Symbol symbol, ReplaceCallback callback) {
        this.replace(symbol, callback, false);
    }

    @Override
    public void replace(long functionAddress, Svc svc) {
        if (svc == null) {
            throw new NullPointerException();
        }
        UnidbgPointer originCall = this.emulator.getMemory().malloc(this.emulator.getPointerSize(), false).getPointer();
        UnidbgPointer callback = this.emulator.getSvcMemory().registerSvc(svc);
        int ret = this.dobbyHook.call(this.emulator, UnidbgPointer.pointer(this.emulator, functionAddress), callback, originCall).intValue();
        if (ret != 0) {
            throw new IllegalStateException("ret=" + ret);
        }
    }

    @Override
    public void replace(Symbol symbol, Svc svc) {
        this.replace(symbol.getAddress(), svc);
    }

    @Override
    public void replace(long functionAddress, ReplaceCallback callback, boolean enablePostCall) {
        UnidbgPointer originCall = this.emulator.getMemory().malloc(this.emulator.getPointerSize(), false).getPointer();
        Pointer replaceCall = this.createReplacePointer(callback, originCall, enablePostCall);
        int ret = this.dobbyHook.call(this.emulator, UnidbgPointer.pointer(this.emulator, functionAddress), replaceCall, originCall).intValue();
        if (ret != 0) {
            throw new IllegalStateException("ret=" + ret);
        }
    }

    @Override
    public void replace(Symbol symbol, ReplaceCallback callback, boolean enablePostCall) {
        this.replace(symbol.getAddress(), callback, enablePostCall);
    }

    @Override
    public <T extends RegisterContext> void wrap(Symbol symbol, WrapCallback<T> callback) {
        this.wrap(symbol.getAddress(), callback);
    }

    @Override
    public <T extends RegisterContext> void wrap(long functionAddress, WrapCallback<T> callback) {
        throw new UnsupportedOperationException();
    }

    @Override
    public <T extends RegisterContext> void instrument(Symbol symbol, InstrumentCallback<T> callback) {
        this.instrument(symbol.getAddress(), callback);
    }

    @Override
    public <T extends RegisterContext> void instrument(long functionAddress, final InstrumentCallback<T> callback) {
        SvcMemory svcMemory = this.emulator.getSvcMemory();
        final Stack context = new Stack();
        UnidbgPointer dbiCall = svcMemory.registerSvc(this.emulator.is32Bit() ? new ArmSvc(){

            @Override
            public long handle(Emulator<?> emulator) {
                context.clear();
                callback.dbiCall(emulator, new HookZzArm32RegisterContextImpl(emulator, context), new ArmHookEntryInfo(emulator));
                return 0L;
            }
        } : new Arm64Svc(){

            @Override
            public long handle(Emulator<?> emulator) {
                context.clear();
                callback.dbiCall(emulator, new HookZzArm64RegisterContextImpl(emulator, context), new Arm64HookEntryInfo(emulator));
                return 0L;
            }
        });
        int ret = this.dobbyInstrument.call(this.emulator, UnidbgPointer.pointer(this.emulator, functionAddress), dbiCall).intValue();
        if (ret != 0) {
            throw new IllegalStateException("ret=" + ret);
        }
    }
}

