/*
 * Decompiled with CFR 0.152.
 */
package com.github.unidbg.hook.whale;

import com.github.unidbg.Emulator;
import com.github.unidbg.Family;
import com.github.unidbg.Svc;
import com.github.unidbg.Symbol;
import com.github.unidbg.hook.BaseHook;
import com.github.unidbg.hook.ReplaceCallback;
import com.github.unidbg.hook.whale.IWhale;
import com.github.unidbg.pointer.UnidbgPointer;
import com.sun.jna.Pointer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class Whale
extends BaseHook
implements IWhale {
    private static final Log log = LogFactory.getLog(Whale.class);
    private final Symbol WInlineHookFunction;
    private final Symbol WImportHookFunction;

    public static IWhale getInstance(Emulator<?> emulator) {
        IWhale whale = (IWhale)emulator.get(Whale.class.getName());
        if (whale == null) {
            whale = new Whale(emulator);
            emulator.set(Whale.class.getName(), whale);
        }
        return whale;
    }

    private Whale(Emulator<?> emulator) {
        super(emulator, "libwhale");
        boolean isIOS = emulator.getFamily() == Family.iOS;
        this.WInlineHookFunction = this.module.findSymbolByName(isIOS ? "_WInlineHookFunction" : "WInlineHookFunction", false);
        this.WImportHookFunction = this.module.findSymbolByName(isIOS ? "_WImportHookFunction" : "WImportHookFunction", false);
        if (log.isDebugEnabled()) {
            log.debug((Object)("WInlineHookFunction=" + this.WInlineHookFunction + ", WImportHookFunction=" + this.WImportHookFunction));
        }
        if (this.WInlineHookFunction == null) {
            throw new IllegalStateException("WInlineHookFunction is null");
        }
        if (this.WImportHookFunction == null) {
            throw new IllegalStateException("WImportHookFunction is null");
        }
    }

    @Override
    public void inlineHookFunction(long address, ReplaceCallback callback) {
        this.inlineHookFunction(address, callback, false);
    }

    @Override
    public void inlineHookFunction(Symbol symbol, ReplaceCallback callback) {
        this.inlineHookFunction(symbol.getAddress(), callback);
    }

    @Override
    public void replace(long functionAddress, ReplaceCallback callback) {
        this.inlineHookFunction(functionAddress, callback);
    }

    @Override
    public void replace(Symbol symbol, ReplaceCallback callback) {
        this.inlineHookFunction(symbol, callback);
    }

    @Override
    public void replace(long functionAddress, ReplaceCallback callback, boolean enablePostCall) {
        this.inlineHookFunction(functionAddress, callback, enablePostCall);
    }

    @Override
    public void replace(Symbol symbol, ReplaceCallback callback, boolean enablePostCall) {
        this.inlineHookFunction(symbol, callback, enablePostCall);
    }

    @Override
    public void inlineHookFunction(long address, ReplaceCallback callback, boolean enablePostCall) {
        UnidbgPointer backup = this.emulator.getMemory().malloc(this.emulator.getPointerSize(), false).getPointer();
        Pointer replace = this.createReplacePointer(callback, backup, enablePostCall);
        this.WInlineHookFunction.call(this.emulator, UnidbgPointer.pointer(this.emulator, address), replace, backup);
    }

    @Override
    public void replace(long functionAddress, Svc svc) {
        if (svc == null) {
            throw new NullPointerException();
        }
        UnidbgPointer originCall = this.emulator.getMemory().malloc(this.emulator.getPointerSize(), false).getPointer();
        UnidbgPointer callback = this.emulator.getSvcMemory().registerSvc(svc);
        this.WInlineHookFunction.call(this.emulator, UnidbgPointer.pointer(this.emulator, functionAddress), callback, originCall);
    }

    @Override
    public void replace(Symbol symbol, Svc svc) {
        this.replace(symbol.getAddress(), svc);
    }

    @Override
    public void inlineHookFunction(Symbol symbol, ReplaceCallback callback, boolean enablePostCall) {
        this.inlineHookFunction(symbol.getAddress(), callback, enablePostCall);
    }

    @Override
    public void importHookFunction(String symbol, ReplaceCallback callback) {
        this.importHookFunction(symbol, callback, false);
    }

    @Override
    public void importHookFunction(String symbol, ReplaceCallback callback, boolean enablePostCall) {
        UnidbgPointer backup = this.emulator.getMemory().malloc(this.emulator.getPointerSize(), false).getPointer();
        Pointer replace = this.createReplacePointer(callback, backup, enablePostCall);
        this.WImportHookFunction.call(this.emulator, symbol, null, replace, backup);
    }
}

