/*
 * Decompiled with CFR 0.152.
 */
package com.github.unidbg.pointer;

import com.github.unidbg.Emulator;
import com.github.unidbg.InvalidMemoryAccessException;
import com.github.unidbg.Module;
import com.github.unidbg.PointerArg;
import com.github.unidbg.arm.backend.Backend;
import com.github.unidbg.memory.Memory;
import com.github.unidbg.memory.MemoryMap;
import com.github.unidbg.pointer.ByteArrayBackend;
import com.github.unidbg.pointer.MemoryWriteListener;
import com.sun.jna.NativeLong;
import com.sun.jna.Pointer;
import com.sun.jna.WString;
import java.io.ByteArrayOutputStream;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Arrays;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class UnidbgPointer
extends Pointer
implements PointerArg {
    private static final Log log = LogFactory.getLog(UnidbgPointer.class);
    private final Emulator<?> emulator;
    private final Backend backend;
    public final long peer;
    private final int pointerSize;
    private final MemoryWriteListener listener;
    private long size;

    public static long nativeValue(Pointer ptr) {
        if (ptr == null) {
            return 0L;
        }
        UnidbgPointer up = (UnidbgPointer)ptr;
        return up.emulator.is64Bit() ? up.peer : up.toUIntPeer();
    }

    public long toUIntPeer() {
        return this.peer & 0xFFFFFFFFL;
    }

    public int toIntPeer() {
        return (int)this.toUIntPeer();
    }

    UnidbgPointer(Emulator<?> emulator, byte[] data) {
        super(0L);
        this.emulator = emulator;
        this.backend = data == null ? null : new ByteArrayBackend(data);
        this.peer = 0L;
        this.pointerSize = 0;
        this.listener = null;
    }

    private UnidbgPointer(Emulator<?> emulator, long peer, int pointerSize) {
        super(0L);
        this.emulator = emulator;
        this.backend = emulator.getBackend();
        this.peer = peer;
        this.pointerSize = pointerSize;
        this.listener = emulator instanceof MemoryWriteListener ? (MemoryWriteListener)((Object)emulator) : null;
    }

    public UnidbgPointer setSize(long size) {
        if (size < 0L) {
            throw new IllegalArgumentException("size=" + size);
        }
        this.size = size;
        return this;
    }

    public long getSize() {
        return this.size;
    }

    public static UnidbgPointer pointer(Emulator<?> emulator, long addr) {
        long peer = emulator.is64Bit() ? addr : addr & 0xFFFFFFFFL;
        return peer == 0L ? null : new UnidbgPointer(emulator, peer, emulator.getPointerSize());
    }

    public static UnidbgPointer pointer(Emulator<?> emulator, Number number) {
        return UnidbgPointer.pointer(emulator, number.longValue());
    }

    public static UnidbgPointer register(Emulator<?> emulator, int reg) {
        return UnidbgPointer.pointer(emulator, emulator.getBackend().reg_read(reg));
    }

    public long indexOf(long offset, byte value) {
        throw new AbstractMethodError();
    }

    public void read(long offset, byte[] buf, int index, int length) {
        byte[] data = this.getByteArray(offset, length);
        System.arraycopy(data, 0, buf, index, length);
    }

    public void read(long offset, short[] buf, int index, int length) {
        throw new AbstractMethodError();
    }

    public void read(long offset, char[] buf, int index, int length) {
        throw new AbstractMethodError();
    }

    public void read(long offset, int[] buf, int index, int length) {
        for (int i = index; i < length; ++i) {
            buf[i] = this.getInt((long)(i - index) * 4L + offset);
        }
    }

    public void read(long offset, long[] buf, int index, int length) {
        for (int i = index; i < length; ++i) {
            buf[i] = this.getLong((long)(i - index) * 8L + offset);
        }
    }

    public void read(long offset, float[] buf, int index, int length) {
        for (int i = index; i < length; ++i) {
            buf[i] = this.getFloat((long)(i - index) * 4L + offset);
        }
    }

    public void read(long offset, double[] buf, int index, int length) {
        for (int i = index; i < length; ++i) {
            buf[i] = this.getDouble((long)(i - index) * 8L + offset);
        }
    }

    public void read(long offset, Pointer[] buf, int index, int length) {
        throw new AbstractMethodError();
    }

    public void write(byte[] buf) {
        this.write(0L, buf, 0, buf.length);
    }

    public void write(long offset, byte[] buf, int index, int length) {
        byte[] data;
        if (this.size > 0L) {
            if (offset < 0L) {
                throw new IllegalArgumentException();
            }
            if (this.size - offset < (long)length) {
                throw new InvalidMemoryAccessException();
            }
        }
        if (index == 0 && buf.length == length) {
            data = buf;
        } else {
            data = new byte[length];
            System.arraycopy(buf, index, data, 0, length);
        }
        long address = this.peer + offset;
        this.backend.mem_write(address, data);
        if (this.listener != null) {
            this.listener.onSystemWrite(address, data);
        }
    }

    public void write(long offset, short[] buf, int index, int length) {
        for (int i = index; i < length; ++i) {
            this.setShort((long)(i - index) * 2L + offset, buf[i]);
        }
    }

    public void write(long offset, char[] buf, int index, int length) {
        throw new AbstractMethodError();
    }

    public void write(long offset, int[] buf, int index, int length) {
        for (int i = index; i < length; ++i) {
            this.setInt((long)(i - index) * 4L + offset, buf[i]);
        }
    }

    public void write(long offset, long[] buf, int index, int length) {
        for (int i = index; i < length; ++i) {
            this.setLong((long)(i - index) * 8L + offset, buf[i]);
        }
    }

    public void write(long offset, float[] buf, int index, int length) {
        for (int i = index; i < length; ++i) {
            this.setFloat((long)(i - index) * 4L + offset, buf[i]);
        }
    }

    public void write(long offset, double[] buf, int index, int length) {
        for (int i = index; i < length; ++i) {
            this.setDouble((long)(i - index) * 8L + offset, buf[i]);
        }
    }

    public void write(long offset, Pointer[] buf, int index, int length) {
        throw new AbstractMethodError();
    }

    public byte getByte(long offset) {
        return this.getByteArray(offset, 1)[0];
    }

    public char getChar(long offset) {
        return this.getByteBuffer(offset, 2L).getChar();
    }

    public short getShort(long offset) {
        return this.getByteBuffer(offset, 2L).getShort();
    }

    public int getInt(long offset) {
        return this.getByteBuffer(offset, 4L).getInt();
    }

    public long getLong(long offset) {
        return this.getByteBuffer(offset, 8L).getLong();
    }

    public NativeLong getNativeLong(long offset) {
        throw new AbstractMethodError();
    }

    public float getFloat(long offset) {
        return this.getByteBuffer(offset, 4L).getFloat();
    }

    public double getDouble(long offset) {
        return this.getByteBuffer(offset, 8L).getDouble();
    }

    public UnidbgPointer getPointer(long offset) {
        return UnidbgPointer.pointer(this.emulator, this.pointerSize == 4 ? (Number)this.getInt(offset) : (Number)this.getLong(offset));
    }

    public byte[] getByteArray(long offset, int arraySize) {
        if (this.size > 0L && offset + (long)arraySize > this.size) {
            throw new InvalidMemoryAccessException();
        }
        if (arraySize < 0 || arraySize >= 0x7FFFFFF) {
            throw new InvalidMemoryAccessException("Invalid array size: " + arraySize);
        }
        return this.backend.mem_read(this.peer + offset, arraySize);
    }

    public int[] getIntArray(long offset, int arraySize) {
        if (arraySize < 0 || arraySize >= 0x7FFFFFF) {
            throw new InvalidMemoryAccessException("Invalid array size: " + arraySize);
        }
        int[] array = new int[arraySize];
        for (int i = 0; i < arraySize; ++i) {
            array[i] = this.getInt(offset + (long)(i * 4));
        }
        return array;
    }

    public ByteBuffer getByteBuffer(long offset, long length) {
        return ByteBuffer.wrap(this.getByteArray(offset, (int)length)).order(ByteOrder.LITTLE_ENDIAN);
    }

    public String getWideString(long offset) {
        throw new AbstractMethodError();
    }

    public String getString(long offset) {
        return this.getString(offset, "UTF-8");
    }

    public String getString(long offset, String encoding) {
        ByteArrayOutputStream baos;
        block4: {
            long addr = this.peer + offset;
            baos = new ByteArrayOutputStream(64);
            do {
                byte[] data = this.backend.mem_read(addr, 16L);
                int length = data.length;
                for (int i = 0; i < data.length; ++i) {
                    if (data[i] != 0) continue;
                    length = i;
                    break;
                }
                baos.write(data, 0, length);
                addr += (long)length;
                if (length < data.length) break block4;
                if (baos.size() <= 262144) continue;
                throw new IllegalStateException("buffer overflow");
            } while (this.size <= 0L || offset + (long)baos.size() <= this.size);
            throw new InvalidMemoryAccessException();
        }
        try {
            String ret = baos.toString(encoding);
            log.debug((Object)("getString pointer=" + this + ", size=" + baos.size() + ", encoding=" + encoding + ", ret=" + ret));
            return ret;
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException(e);
        }
    }

    private ByteBuffer allocateBuffer(int size) {
        return ByteBuffer.allocate(size).order(ByteOrder.LITTLE_ENDIAN);
    }

    public void setMemory(long offset, long length, byte value) {
        byte[] data = new byte[(int)length];
        Arrays.fill(data, value);
        this.write(offset, data, 0, data.length);
    }

    public void setByte(long offset, byte value) {
        this.write(offset, new byte[]{value}, 0, 1);
    }

    public void setShort(long offset, short value) {
        this.write(offset, this.allocateBuffer(2).putShort(value).array(), 0, 2);
    }

    public void setChar(long offset, char value) {
        this.write(offset, this.allocateBuffer(2).putChar(value).array(), 0, 2);
    }

    public void setInt(long offset, int value) {
        this.write(offset, this.allocateBuffer(4).putInt(value).array(), 0, 4);
    }

    public void setLong(long offset, long value) {
        this.write(offset, this.allocateBuffer(8).putLong(value).array(), 0, 8);
    }

    public void setNativeLong(long offset, NativeLong value) {
        throw new AbstractMethodError();
    }

    public void setFloat(long offset, float value) {
        this.write(offset, this.allocateBuffer(4).putFloat(value).array(), 0, 4);
    }

    public void setDouble(long offset, double value) {
        this.write(offset, this.allocateBuffer(8).putDouble(value).array(), 0, 8);
    }

    public void setPointer(long offset, Pointer pointer) {
        long value = pointer == null ? 0L : ((UnidbgPointer)pointer).peer;
        if (this.pointerSize == 4) {
            this.setInt(offset, (int)value);
        } else {
            this.setLong(offset, value);
        }
    }

    public void setWideString(long offset, String value) {
        throw new AbstractMethodError();
    }

    public void setString(long offset, WString value) {
        throw new AbstractMethodError();
    }

    public void setString(long offset, String value) {
        this.setString(offset, value, "UTF-8");
    }

    public void setString(long offset, String value, String encoding) {
        try {
            byte[] data = value.getBytes(encoding);
            this.write(offset, Arrays.copyOf(data, data.length + 1), 0, data.length + 1);
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public UnidbgPointer share(long offset, long sz) {
        if (offset == 0L && sz == this.size) {
            return this;
        }
        UnidbgPointer pointer = new UnidbgPointer(this.emulator, this.peer + offset, this.pointerSize);
        if (this.size > 0L) {
            if (offset > this.size) {
                throw new InvalidMemoryAccessException("offset=" + offset + ", size=" + this.size + ", peer=0x" + Long.toHexString(this.peer));
            }
            long newSize = this.size - offset;
            pointer.setSize(sz > 0L && sz < newSize ? sz : newSize);
        } else {
            pointer.setSize(sz);
        }
        return pointer;
    }

    public String toString() {
        Memory memory = this.emulator == null ? null : this.emulator.getMemory();
        Module module = memory == null ? null : memory.findModuleByAddress(this.peer);
        MemoryMap memoryMap = null;
        if (memory != null) {
            for (MemoryMap mm : memory.getMemoryMap()) {
                if (this.peer < mm.base || this.peer >= mm.base + mm.size) continue;
                memoryMap = mm;
                break;
            }
        }
        StringBuilder sb = new StringBuilder();
        if (memoryMap == null) {
            sb.append("unidbg");
        } else {
            if ((memoryMap.prot & 1) != 0) {
                sb.append('R');
            }
            if ((memoryMap.prot & 2) != 0) {
                sb.append('W');
            }
            if ((memoryMap.prot & 4) != 0) {
                sb.append('X');
            }
        }
        sb.append("@0x");
        sb.append(Long.toHexString(this.peer));
        if (module != null) {
            sb.append("[").append(module.name).append("]0x").append(Long.toHexString(this.peer - module.base));
        }
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null) {
            return false;
        }
        return o instanceof UnidbgPointer && ((UnidbgPointer)o).peer == this.peer;
    }

    public int hashCode() {
        return (int)((this.peer >>> 32) + (this.peer & 0xFFFFFFFFL));
    }

    @Override
    public Pointer getPointer() {
        return this;
    }
}

