/*
 * Decompiled with CFR 0.152.
 */
package com.github.unidbg.signal;

import com.github.unidbg.signal.SigSet;
import java.util.ArrayList;
import java.util.Iterator;

public class UnixSigSet
implements SigSet {
    private long mask;

    public UnixSigSet(long mask) {
        this.mask = mask;
    }

    @Override
    public long getMask() {
        return this.mask;
    }

    @Override
    public void setMask(long mask) {
        this.mask = mask;
    }

    @Override
    public void blockSigSet(long mask) {
        this.mask |= mask;
    }

    @Override
    public void unblockSigSet(long mask) {
        this.mask &= mask ^ 0xFFFFFFFFFFFFFFFFL;
    }

    @Override
    public boolean containsSigNumber(int signum) {
        int bit = signum - 1;
        return (this.mask & 1L << bit) != 0L;
    }

    @Override
    public void removeSigNumber(int signum) {
        int bit = signum - 1;
        this.mask &= 1L << bit;
    }

    @Override
    public void addSigNumber(int signum) {
        int bit = signum - 1;
        this.mask |= 1L << bit;
    }

    @Override
    public Iterator<Integer> iterator() {
        return new SigSetIterator(this);
    }

    public String toString() {
        ArrayList<Integer> list = new ArrayList<Integer>(10);
        for (Integer signum : this) {
            list.add(signum);
        }
        return ((Object)list).toString();
    }

    private class SigSetIterator
    implements Iterator<Integer> {
        private long mask;
        private int bit;
        private int nextBit;

        public SigSetIterator(UnixSigSet sigSet) {
            this.mask = sigSet.mask;
        }

        @Override
        public boolean hasNext() {
            for (int i = this.bit; i < 64; ++i) {
                if ((this.mask & 1L << i) == 0L) continue;
                this.nextBit = i;
                return true;
            }
            return false;
        }

        @Override
        public Integer next() {
            this.bit = this.nextBit;
            this.mask &= 1L << this.bit ^ 0xFFFFFFFFFFFFFFFFL;
            return this.bit + 1;
        }

        @Override
        public void remove() {
            UnixSigSet unixSigSet = UnixSigSet.this;
            unixSigSet.mask = unixSigSet.mask & (1L << this.bit ^ 0xFFFFFFFFFFFFFFFFL);
        }
    }
}

