/*
 * Decompiled with CFR 0.152.
 */
package com.github.unidbg.thread;

import com.github.unidbg.AbstractEmulator;
import com.github.unidbg.arm.ARM;
import com.github.unidbg.arm.backend.Backend;
import com.github.unidbg.memory.Memory;
import com.github.unidbg.thread.MainTask;
import java.util.Arrays;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Function64
extends MainTask {
    private static final Log log = LogFactory.getLog(Function64.class);
    private final long address;
    private final boolean paddingArgument;
    private final Number[] arguments;

    public Function64(int pid, long address, long until, boolean paddingArgument, Number ... arguments) {
        super(pid, until);
        this.address = address;
        this.paddingArgument = paddingArgument;
        this.arguments = arguments;
    }

    @Override
    protected Number run(AbstractEmulator<?> emulator) {
        Backend backend = emulator.getBackend();
        Memory memory = emulator.getMemory();
        ARM.initArgs(emulator, this.paddingArgument, this.arguments);
        long sp = memory.getStackPoint();
        if (sp % 16L != 0L) {
            log.info((Object)"SP NOT 16 bytes aligned", (Throwable)new Exception(emulator.getStackPointer().toString()));
        }
        backend.reg_write(2, this.until);
        return emulator.emulate(this.address, this.until);
    }

    public String toString() {
        return "Function64 address=0x" + Long.toHexString(this.address) + ", arguments=" + Arrays.toString(this.arguments);
    }
}

