/*
 * Decompiled with CFR 0.152.
 */
package com.github.unidbg.unix;

import com.github.unidbg.Emulator;
import com.github.unidbg.Family;
import com.github.unidbg.Module;
import com.github.unidbg.arm.backend.UnHook;
import com.github.unidbg.debugger.Breaker;
import com.github.unidbg.file.FileIO;
import com.github.unidbg.file.FileResult;
import com.github.unidbg.file.IOResolver;
import com.github.unidbg.file.NewFileIO;
import com.github.unidbg.memory.MemRegion;
import com.github.unidbg.spi.SyscallHandler;
import com.github.unidbg.thread.MainTask;
import com.github.unidbg.unix.FileListener;
import com.github.unidbg.unix.struct.TimeVal32;
import com.github.unidbg.unix.struct.TimeVal64;
import com.github.unidbg.unix.struct.TimeZone;
import com.github.unidbg.utils.Inspector;
import com.sun.jna.Pointer;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class UnixSyscallHandler<T extends NewFileIO>
implements SyscallHandler<T> {
    private static final Log log = LogFactory.getLog(UnixSyscallHandler.class);
    private final List<IOResolver<T>> resolvers = new ArrayList<IOResolver<T>>(5);
    protected final Map<Integer, T> fdMap = new TreeMap<Integer, T>();
    protected boolean verbose;
    private FileListener fileListener;
    private Breaker breaker;
    private static final Pattern FD_PATTERN = Pattern.compile("/proc/self/fd/(\\d+)");
    private final Map<Integer, byte[]> sigMap = new HashMap<Integer, byte[]>();
    private static final int SIGHUP = 1;
    private static final int SIGINT = 2;
    private static final int SIGQUIT = 3;
    private static final int SIGILL = 4;
    private static final int SIGTRAP = 5;
    private static final int SIGABRT = 6;
    protected static final int SIGBUS = 7;
    private static final int SIGFPE = 8;
    private static final int SIGUSR1 = 10;
    private static final int SIGSEGV = 11;
    private static final int SIGUSR2 = 12;
    private static final int SIGPIPE = 13;
    private static final int SIGALRM = 14;
    private static final int SIGTERM = 15;
    protected static final int SIGCHLD = 17;
    private static final int SIGCONT = 18;
    private static final int SIGTSTP = 20;
    private static final int SIGTTIN = 21;
    private static final int SIGTTOU = 22;
    private static final int SIGWINCH = 28;
    private static final int SIGSYS = 31;
    private static final int SIGRTMIN = 32;
    protected boolean threadDispatcherEnabled;

    @Override
    public FileIO getFileIO(int fd) {
        return (FileIO)this.fdMap.get(fd);
    }

    @Override
    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    @Override
    public void setFileListener(FileListener fileListener) {
        this.fileListener = fileListener;
    }

    @Override
    public boolean isVerbose() {
        return this.verbose;
    }

    @Override
    public void setBreaker(Breaker breaker) {
        this.breaker = breaker;
    }

    protected final Breaker createBreaker(Emulator<?> emulator) {
        return this.breaker != null ? this.breaker : emulator.attach();
    }

    protected int getMinFd() {
        int fd;
        int last_fd = -1;
        Iterator<Integer> iterator = this.fdMap.keySet().iterator();
        while (iterator.hasNext() && last_fd + 1 == (fd = iterator.next().intValue())) {
            last_fd = fd;
        }
        return last_fd + 1;
    }

    @Override
    public void addIOResolver(IOResolver<T> resolver) {
        if (!this.resolvers.contains(resolver)) {
            this.resolvers.add(0, resolver);
        }
    }

    protected final FileResult<T> resolve(Emulator<T> emulator, String pathname, int oflags) {
        int fd;
        NewFileIO file;
        FileResult<T> failResult = null;
        for (IOResolver<T> resolver : this.resolvers) {
            FileResult<T> result = resolver.resolve(emulator, pathname, oflags);
            if (result != null && result.isSuccess()) {
                emulator.getMemory().setErrno(0);
                return result;
            }
            if (result == null || failResult != null && failResult.isFallback()) continue;
            failResult = result;
        }
        if (failResult != null && !failResult.isFallback()) {
            return failResult;
        }
        FileResult<T> result = emulator.getFileSystem().open(pathname, oflags);
        if (result != null && result.isSuccess()) {
            emulator.getMemory().setErrno(0);
            return result;
        }
        Family family = emulator.getFamily();
        if (pathname.endsWith(family.getLibraryExtension())) {
            for (Module module : emulator.getMemory().getLoadedModules()) {
                for (MemRegion memRegion : module.getRegions()) {
                    if (!pathname.equals(memRegion.getName())) continue;
                    try {
                        emulator.getMemory().setErrno(0);
                        return FileResult.success(this.createByteArrayFileIO(pathname, oflags, memRegion.readLibrary()));
                    }
                    catch (IOException e) {
                        throw new IllegalStateException(e);
                    }
                }
            }
        }
        if (failResult != null && failResult.isFallback()) {
            return FileResult.success(failResult.io);
        }
        if ((pathname.startsWith("/proc/" + emulator.getPid() + "/fd/") || pathname.startsWith("/proc/self/fd/")) && (file = (NewFileIO)this.fdMap.get(fd = Integer.parseInt(pathname.substring(pathname.lastIndexOf("/") + 1)))) != null) {
            return FileResult.success(file);
        }
        if (("/proc/" + emulator.getPid() + "/fd").equals(pathname) || "/proc/self/fd".equals(pathname)) {
            return this.createFdDir(oflags, pathname);
        }
        if (("/proc/" + emulator.getPid() + "/task/").equals(pathname) || "/proc/self/task/".equals(pathname)) {
            return this.createTaskDir(emulator, oflags, pathname);
        }
        return failResult;
    }

    protected FileResult<T> createTaskDir(Emulator<T> emulator, int oflags, String pathname) {
        throw new UnsupportedOperationException(pathname);
    }

    protected FileResult<T> createFdDir(int oflags, String pathname) {
        throw new UnsupportedOperationException(pathname);
    }

    protected abstract T createByteArrayFileIO(String var1, int var2, byte[] var3);

    protected int gettimeofday(Emulator<?> emulator, Pointer tv, Pointer tz) {
        byte[] after;
        byte[] before;
        if (log.isDebugEnabled()) {
            log.debug((Object)("gettimeofday tv=" + tv + ", tz=" + tz));
        }
        if (log.isDebugEnabled()) {
            before = tv.getByteArray(0L, 8);
            Inspector.inspect(before, "gettimeofday tv=" + tv);
        }
        if (tz != null && log.isDebugEnabled()) {
            before = tz.getByteArray(0L, 8);
            Inspector.inspect(before, "gettimeofday tz");
        }
        long currentTimeMillis = System.currentTimeMillis();
        long tv_sec = currentTimeMillis / 1000L;
        long tv_usec = currentTimeMillis % 1000L * 1000L;
        TimeVal32 timeVal = new TimeVal32(tv);
        timeVal.tv_sec = (int)tv_sec;
        timeVal.tv_usec = (int)tv_usec;
        timeVal.pack();
        if (tz != null) {
            Calendar calendar = Calendar.getInstance();
            int tz_minuteswest = -(calendar.get(15) + calendar.get(16)) / 60000;
            TimeZone timeZone = new TimeZone(tz);
            timeZone.tz_minuteswest = tz_minuteswest;
            timeZone.tz_dsttime = 0;
            timeZone.pack();
        }
        if (log.isDebugEnabled()) {
            after = tv.getByteArray(0L, 8);
            Inspector.inspect(after, "gettimeofday tv after tv_sec=" + tv_sec + ", tv_usec=" + tv_usec + ", tv=" + tv);
        }
        if (tz != null && log.isDebugEnabled()) {
            after = tz.getByteArray(0L, 8);
            Inspector.inspect(after, "gettimeofday tz after");
        }
        return 0;
    }

    protected int gettimeofday64(Pointer tv, Pointer tz) {
        byte[] after;
        byte[] before;
        if (log.isDebugEnabled()) {
            log.debug((Object)("gettimeofday tv=" + tv + ", tz=" + tz));
        }
        if (log.isDebugEnabled()) {
            before = tv.getByteArray(0L, 8);
            Inspector.inspect(before, "gettimeofday tv=" + tv);
        }
        if (tz != null && log.isDebugEnabled()) {
            before = tz.getByteArray(0L, 8);
            Inspector.inspect(before, "gettimeofday tz");
        }
        long currentTimeMillis = System.currentTimeMillis();
        long tv_sec = currentTimeMillis / 1000L;
        long tv_usec = currentTimeMillis % 1000L * 1000L;
        TimeVal64 timeVal = new TimeVal64(tv);
        timeVal.tv_sec = tv_sec;
        timeVal.tv_usec = tv_usec;
        timeVal.pack();
        if (tz != null) {
            Calendar calendar = Calendar.getInstance();
            int tz_minuteswest = -(calendar.get(15) + calendar.get(16)) / 60000;
            TimeZone timeZone = new TimeZone(tz);
            timeZone.tz_minuteswest = tz_minuteswest;
            timeZone.tz_dsttime = 0;
            timeZone.pack();
        }
        if (log.isDebugEnabled()) {
            after = tv.getByteArray(0L, 8);
            Inspector.inspect(after, "gettimeofday tv after tv_sec=" + tv_sec + ", tv_usec=" + tv_usec + ", tv=" + tv);
        }
        if (tz != null && log.isDebugEnabled()) {
            after = tz.getByteArray(0L, 8);
            Inspector.inspect(after, "gettimeofday tz after");
        }
        return 0;
    }

    protected int sigprocmask(Emulator<?> emulator, int how, Pointer set, Pointer oldset) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("sigprocmask how=" + how + ", set=" + set + ", oldset=" + oldset));
        }
        emulator.getMemory().setErrno(22);
        return -1;
    }

    protected final int read(Emulator<?> emulator, int fd, Pointer buffer, int count) {
        FileIO file;
        if (log.isDebugEnabled()) {
            log.debug((Object)("read fd=" + fd + ", buffer=" + buffer + ", count=" + count + ", from=" + emulator.getContext().getLRPointer()));
        }
        if ((file = (FileIO)this.fdMap.get(fd)) == null) {
            emulator.getMemory().setErrno(9);
            return -1;
        }
        int read = file.read(emulator.getBackend(), buffer, count);
        if (this.verbose && !file.isStdIO()) {
            System.out.printf("Read %d bytes from '%s'%n", read, file);
        }
        if (this.fileListener != null) {
            byte[] bytes = read <= 0 ? new byte[]{} : buffer.getByteArray(0L, read);
            this.fileListener.onRead(emulator, String.valueOf(file), bytes);
        }
        return read;
    }

    protected final int pread(Emulator<?> emulator, int fd, Pointer buffer, int count, long offset) {
        FileIO file;
        if (log.isDebugEnabled()) {
            log.debug((Object)("pread fd=" + fd + ", buffer=" + buffer + ", count=" + count + ", offset=" + offset + ", from=" + emulator.getContext().getLRPointer()));
        }
        if ((file = (FileIO)this.fdMap.get(fd)) == null) {
            emulator.getMemory().setErrno(9);
            return -1;
        }
        int read = file.pread(emulator.getBackend(), buffer, count, offset);
        if (this.verbose) {
            System.out.printf("PRead %d bytes with offset %d from '%s'%n", read, offset, file);
        }
        return read;
    }

    protected final int close(Emulator<?> emulator, int fd) {
        FileIO file = (FileIO)this.fdMap.remove(fd);
        if (file != null) {
            file.close();
            if (this.verbose) {
                System.out.printf("File closed '%s' from %s%n", file, emulator.getContext().getLRPointer());
            }
            if (this.fileListener != null) {
                this.fileListener.onClose(emulator, file);
            }
            return 0;
        }
        emulator.getMemory().setErrno(9);
        return -1;
    }

    @Override
    public final int open(Emulator<T> emulator, String pathname, int oflags) {
        int minFd = this.getMinFd();
        FileResult<T> resolveResult = this.resolve(emulator, pathname, oflags);
        if (resolveResult != null && resolveResult.isSuccess()) {
            emulator.getMemory().setErrno(0);
            this.fdMap.put(minFd, resolveResult.io);
            if (this.verbose) {
                System.out.printf("File opened '%s' with oflags=0x%x from %s%n", resolveResult.io, oflags, emulator.getContext().getLRPointer());
            }
            if (this.fileListener != null) {
                this.fileListener.onOpenSuccess(emulator, pathname, (FileIO)resolveResult.io);
            }
            return minFd;
        }
        T driverIO = this.createDriverFileIO(emulator, oflags, pathname);
        if (driverIO != null) {
            emulator.getMemory().setErrno(0);
            this.fdMap.put(minFd, driverIO);
            if (this.verbose) {
                System.out.printf("File opened '%s' with oflags=0x%x from %s%n", driverIO, oflags, emulator.getContext().getLRPointer());
            }
            if (this.fileListener != null) {
                this.fileListener.onOpenSuccess(emulator, pathname, (FileIO)driverIO);
            }
            return minFd;
        }
        FileResult<T> result = null;
        if (resolveResult != null) {
            result = resolveResult;
        }
        int errno = result != null ? result.errno : 2;
        emulator.getMemory().setErrno(errno);
        if (this.verbose) {
            System.out.printf("File opened '%s' with oflags=0x%x errno is %d from %s%n", pathname, oflags, errno, emulator.getContext().getLRPointer());
        }
        return -1;
    }

    protected abstract T createDriverFileIO(Emulator<?> var1, int var2, String var3);

    protected int fcntl(Emulator<?> emulator, int fd, int cmd, long arg) {
        FileIO file;
        if (log.isDebugEnabled()) {
            log.debug((Object)("fcntl fd=" + fd + ", cmd=" + cmd + ", arg=" + arg));
        }
        if ((file = (FileIO)this.fdMap.get(fd)) == null) {
            emulator.getMemory().setErrno(9);
            return -1;
        }
        return file.fcntl(emulator, cmd, arg);
    }

    protected int readlink(Emulator<?> emulator, String path, Pointer buf, int bufSize) {
        int fd;
        FileIO io;
        Matcher matcher;
        if (log.isDebugEnabled()) {
            log.debug((Object)("readlink path=" + path + ", buf=" + buf + ", bufSize=" + bufSize));
        }
        if ((matcher = FD_PATTERN.matcher(path)).find() && (io = (FileIO)this.fdMap.get(fd = Integer.parseInt(matcher.group(1)))) != null) {
            path = io.getPath();
        }
        buf.setString(0L, path);
        return path.length() + 1;
    }

    protected int sigaction(Emulator<?> emulator, int signum, Pointer act, Pointer oldact) {
        int ACT_SIZE = 16;
        return this.sigaction(emulator, signum, act, oldact, 16);
    }

    protected final int sigaction(Emulator<?> emulator, int signum, Pointer act, Pointer oldact, int sizeOfSigAction) {
        String prefix = "Unknown";
        if (signum > 32) {
            signum -= 32;
            prefix = "Real-time";
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("sigaction signum=" + signum + ", act=" + act + ", oldact=" + oldact + ", prefix=" + prefix));
        }
        if (oldact != null) {
            byte[] lastAct = this.sigMap.get(signum);
            byte[] data = lastAct == null ? new byte[sizeOfSigAction] : lastAct;
            oldact.write(0L, data, 0, data.length);
        }
        switch (signum) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 17: 
            case 18: 
            case 20: 
            case 21: 
            case 22: 
            case 28: 
            case 31: 
            case 32: {
                if (act != null) {
                    this.sigMap.put(signum, act.getByteArray(0L, sizeOfSigAction));
                }
                return 0;
            }
        }
        this.createBreaker(emulator).debug();
        throw new UnsupportedOperationException("signum=" + signum);
    }

    protected final int bind(Emulator<?> emulator, int sockfd, Pointer addr, int addrlen) {
        FileIO file;
        if (log.isDebugEnabled()) {
            byte[] data = addr.getByteArray(0L, addrlen);
            Inspector.inspect(data, "bind sockfd=" + sockfd + ", addr=" + addr + ", addrlen=" + addrlen);
        }
        if ((file = (FileIO)this.fdMap.get(sockfd)) == null) {
            emulator.getMemory().setErrno(9);
            return -1;
        }
        return file.bind(addr, addrlen);
    }

    protected final int listen(Emulator<?> emulator, int sockfd, int backlog) {
        FileIO file;
        if (log.isDebugEnabled()) {
            log.debug((Object)("listen sockfd=" + sockfd + ", backlog=" + backlog));
        }
        if ((file = (FileIO)this.fdMap.get(sockfd)) == null) {
            emulator.getMemory().setErrno(9);
            return -1;
        }
        return file.listen(backlog);
    }

    protected final int connect(Emulator<?> emulator, int sockfd, Pointer addr, int addrlen) {
        FileIO file;
        if (log.isDebugEnabled()) {
            byte[] data = addr.getByteArray(0L, addrlen);
            Inspector.inspect(data, "connect sockfd=" + sockfd + ", addr=" + addr + ", addrlen=" + addrlen);
        }
        if ((file = (FileIO)this.fdMap.get(sockfd)) == null) {
            emulator.getMemory().setErrno(9);
            return -1;
        }
        return file.connect(addr, addrlen);
    }

    protected final int sendto(Emulator<?> emulator, int sockfd, Pointer buf, int len, int flags, Pointer dest_addr, int addrlen) {
        FileIO file;
        byte[] data = buf.getByteArray(0L, len);
        if (log.isDebugEnabled()) {
            Inspector.inspect(data, "sendto sockfd=" + sockfd + ", buf=" + buf + ", flags=" + flags + ", dest_addr=" + dest_addr + ", addrlen=" + addrlen);
        }
        if ((file = (FileIO)this.fdMap.get(sockfd)) == null) {
            emulator.getMemory().setErrno(9);
            return -1;
        }
        return file.sendto(data, flags, dest_addr, addrlen);
    }

    protected final int write(Emulator<?> emulator, int fd, Pointer buffer, int count) {
        FileIO file;
        byte[] data = buffer.getByteArray(0L, count);
        if (log.isDebugEnabled()) {
            Inspector.inspect(data, "write fd=" + fd + ", buffer=" + buffer + ", count=" + count);
        }
        if ((file = (FileIO)this.fdMap.get(fd)) == null) {
            emulator.getMemory().setErrno(9);
            return -1;
        }
        int write = file.write(data);
        if (this.verbose && !file.isStdIO()) {
            System.out.printf("Write %d bytes to '%s'%n", write, file);
        }
        if (this.fileListener != null) {
            byte[] bytes = write <= 0 ? new byte[]{} : Arrays.copyOf(data, write);
            this.fileListener.onWrite(emulator, String.valueOf(file), bytes);
        }
        return write;
    }

    protected int getrandom(Pointer buf, int bufSize, int flags) {
        Random random = new Random();
        byte[] bytes = new byte[bufSize];
        random.nextBytes(bytes);
        buf.write(0L, bytes, 0, bytes.length);
        if (log.isDebugEnabled()) {
            log.debug((Object)Inspector.inspectString(bytes, "getrandom buf=" + buf + ", bufSize=" + bufSize + ", flags=0x" + Integer.toHexString(flags)));
        }
        return bufSize;
    }

    protected boolean handleSyscall(Emulator<?> emulator, int NR) {
        return false;
    }

    protected boolean handleUnknownSyscall(Emulator<?> emulator, int NR) {
        return false;
    }

    @Override
    public void serialize(DataOutput out) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void onAttach(UnHook unHook) {
    }

    @Override
    public void detach() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void destroy() {
        for (FileIO io : this.fdMap.values()) {
            io.close();
        }
    }

    @Override
    public void setEnableThreadDispatcher(boolean threadDispatcherEnabled) {
        this.threadDispatcherEnabled = threadDispatcherEnabled;
    }

    @Override
    public MainTask createSignalHandlerTask(Emulator<?> emulator, int sig) {
        return null;
    }
}

