/*
 * Decompiled with CFR 0.152.
 */
package com.github.unidbg.unwind;

import com.github.unidbg.Emulator;
import com.github.unidbg.arm.ARM;
import com.github.unidbg.pointer.UnidbgPointer;
import com.github.unidbg.unwind.Frame;
import com.github.unidbg.unwind.Unwinder;

public class SimpleARMUnwinder
extends Unwinder {
    public SimpleARMUnwinder(Emulator<?> emulator) {
        super(emulator);
    }

    @Override
    protected String getBaseFormat() {
        return "[0x%08x]";
    }

    @Override
    public Frame createFrame(UnidbgPointer ip, UnidbgPointer fp) {
        if (ip != null) {
            if (ip.peer == this.emulator.getReturnAddress()) {
                return new Frame(ip, null);
            }
            return new Frame(ARM.adjust_ip(ip), fp);
        }
        return null;
    }

    private Frame initFrame(Emulator<?> emulator) {
        UnidbgPointer ip = UnidbgPointer.register(emulator, 10);
        UnidbgPointer fp = UnidbgPointer.register(emulator, 73);
        return this.createFrame(ip, fp);
    }

    @Override
    protected Frame unw_step(Emulator<?> emulator, Frame frame) {
        if (frame == null) {
            return this.initFrame(emulator);
        }
        UnidbgPointer sp = UnidbgPointer.register(emulator, 12);
        if (frame.fp == null || frame.fp.peer < sp.peer) {
            System.err.println("fp=" + frame.fp + ", sp=" + sp);
            return null;
        }
        UnidbgPointer ip = frame.fp.getPointer(4L);
        UnidbgPointer fp = frame.fp.getPointer(0L);
        return this.createFrame(ip, fp);
    }
}

