/*
 * Decompiled with CFR 0.152.
 */
package com.github.unidbg;

import com.alibaba.fastjson.util.IOUtils;
import com.github.unidbg.AssemblyCodeDumper;
import com.github.unidbg.Emulator;
import com.github.unidbg.Family;
import com.github.unidbg.TraceHook;
import com.github.unidbg.TraceMemoryHook;
import com.github.unidbg.arm.ARMSvcMemory;
import com.github.unidbg.arm.backend.Backend;
import com.github.unidbg.arm.backend.BackendFactory;
import com.github.unidbg.arm.context.RegisterContext;
import com.github.unidbg.debugger.Debugger;
import com.github.unidbg.debugger.DebuggerType;
import com.github.unidbg.debugger.gdb.GdbStub;
import com.github.unidbg.debugger.ida.AndroidServer;
import com.github.unidbg.file.FileSystem;
import com.github.unidbg.file.NewFileIO;
import com.github.unidbg.listener.TraceCodeListener;
import com.github.unidbg.listener.TraceReadListener;
import com.github.unidbg.listener.TraceSystemMemoryWriteListener;
import com.github.unidbg.listener.TraceWriteListener;
import com.github.unidbg.memory.Memory;
import com.github.unidbg.memory.SvcMemory;
import com.github.unidbg.pointer.MemoryWriteListener;
import com.github.unidbg.spi.Dlfcn;
import com.github.unidbg.thread.MainTask;
import com.github.unidbg.thread.PopContextException;
import com.github.unidbg.thread.RunnableTask;
import com.github.unidbg.thread.ThreadDispatcher;
import com.github.unidbg.thread.UniThreadDispatcher;
import com.github.unidbg.unix.UnixSyscallHandler;
import com.github.unidbg.utils.Inspector;
import com.sun.jna.Pointer;
import java.io.Closeable;
import java.io.DataOutput;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.management.ManagementFactory;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractEmulator<T extends NewFileIO>
implements Emulator<T>,
MemoryWriteListener {
    private static final Logger log = LoggerFactory.getLogger(AbstractEmulator.class);
    public static final long DEFAULT_TIMEOUT = 0L;
    protected final Backend backend;
    private final int pid;
    protected long timeout = 0L;
    private final RegisterContext registerContext;
    private final FileSystem<T> fileSystem;
    protected final SvcMemory svcMemory;
    private final Family family;
    protected final DateFormat dateFormat = new SimpleDateFormat("[HH:mm:ss SSS]");
    private Debugger debugger;
    private long traceSystemMemoryWriteBegin;
    private long traceSystemMemoryWriteEnd;
    private boolean traceSystemMemoryWrite;
    private TraceSystemMemoryWriteListener traceSystemMemoryWriteListener;
    private boolean running;
    private final ThreadDispatcher threadDispatcher;
    private boolean closed;
    private final String processName;
    private final Map<String, Object> context = new HashMap<String, Object>();
    private final Stack<Context> contextStack = new Stack();

    public AbstractEmulator(boolean is64Bit, String processName, long svcBase, int svcSize, File rootDir, Family family, Collection<BackendFactory> backendFactories) {
        this.family = family;
        File targetDir = new File("target");
        if (!targetDir.exists()) {
            targetDir = FileUtils.getTempDirectory();
        }
        if (rootDir == null) {
            rootDir = new File(targetDir, "rootfs/default");
        }
        if (rootDir.isFile()) {
            throw new IllegalArgumentException("rootDir must be directory: " + rootDir);
        }
        if (!rootDir.exists() && !rootDir.mkdirs()) {
            throw new IllegalStateException("mkdirs failed: " + rootDir);
        }
        this.fileSystem = this.createFileSystem(rootDir);
        this.backend = BackendFactory.createBackend(this, is64Bit, backendFactories);
        this.processName = processName == null ? "unidbg" : processName;
        this.registerContext = this.createRegisterContext(this.backend);
        String name = ManagementFactory.getRuntimeMXBean().getName();
        String pid = name.split("@")[0];
        this.pid = Integer.parseInt(pid) & Short.MAX_VALUE;
        this.svcMemory = new ARMSvcMemory(svcBase, svcSize, this);
        this.threadDispatcher = this.createThreadDispatcher();
        this.backend.onInitialize();
    }

    protected ThreadDispatcher createThreadDispatcher() {
        return new UniThreadDispatcher(this);
    }

    @Override
    public final int getPageAlign() {
        int pageSize = this.backend.getPageSize();
        if (pageSize == 0) {
            pageSize = this.getPageAlignInternal();
        }
        return pageSize;
    }

    protected abstract int getPageAlignInternal();

    @Override
    public Family getFamily() {
        return this.family;
    }

    @Override
    public final SvcMemory getSvcMemory() {
        return this.svcMemory;
    }

    @Override
    public final FileSystem<T> getFileSystem() {
        return this.fileSystem;
    }

    protected abstract FileSystem<T> createFileSystem(File var1);

    @Override
    public boolean is64Bit() {
        return this.getPointerSize() == 8;
    }

    @Override
    public boolean is32Bit() {
        return this.getPointerSize() == 4;
    }

    protected abstract RegisterContext createRegisterContext(Backend var1);

    @Override
    public <V extends RegisterContext> V getContext() {
        return (V)this.registerContext;
    }

    protected abstract Memory createMemory(UnixSyscallHandler<T> var1, String[] var2);

    protected abstract Dlfcn createDyld(SvcMemory var1);

    protected abstract UnixSyscallHandler<T> createSyscallHandler(SvcMemory var1);

    protected abstract byte[] assemble(Iterable<String> var1);

    @Override
    public Debugger attach() {
        return this.attach(DebuggerType.CONSOLE);
    }

    @Override
    public Debugger attach(DebuggerType type) {
        if (this.debugger != null) {
            return this.debugger;
        }
        switch (type) {
            case GDB_SERVER: {
                this.debugger = new GdbStub(this);
                break;
            }
            case ANDROID_SERVER_V7: {
                this.debugger = new AndroidServer(this, 25);
                break;
            }
            default: {
                this.debugger = this.createConsoleDebugger();
            }
        }
        if (this.debugger == null) {
            throw new UnsupportedOperationException();
        }
        this.backend.debugger_add(this.debugger, 1L, 0L, this);
        this.timeout = 0L;
        return this.debugger;
    }

    protected abstract Debugger createConsoleDebugger();

    @Override
    public int getPid() {
        return this.pid;
    }

    @Override
    public final TraceHook traceRead(long begin, long end) {
        return this.traceRead(begin, end, null);
    }

    @Override
    public TraceHook traceRead(long begin, long end, TraceReadListener listener) {
        TraceMemoryHook hook = new TraceMemoryHook(true);
        if (listener != null) {
            hook.traceReadListener = listener;
        }
        this.backend.hook_add_new(hook, begin, end, (Object)this);
        return hook;
    }

    @Override
    public final TraceHook traceWrite(long begin, long end) {
        return this.traceWrite(begin, end, null);
    }

    @Override
    public void setTraceSystemMemoryWrite(long begin, long end, TraceSystemMemoryWriteListener listener) {
        this.traceSystemMemoryWrite = true;
        this.traceSystemMemoryWriteBegin = begin;
        this.traceSystemMemoryWriteEnd = end;
        this.traceSystemMemoryWriteListener = listener;
    }

    @Override
    public void onSystemWrite(long addr, byte[] data) {
        long min;
        if (!this.traceSystemMemoryWrite) {
            return;
        }
        long max = Math.max(addr, this.traceSystemMemoryWriteBegin);
        if (max < (min = Math.min(addr + (long)data.length, this.traceSystemMemoryWriteEnd))) {
            byte[] buf = new byte[(int)(min - max)];
            System.arraycopy(data, (int)(max - addr), buf, 0, buf.length);
            if (this.traceSystemMemoryWriteListener != null) {
                this.traceSystemMemoryWriteListener.onWrite(this, addr, buf);
            } else {
                StringWriter writer = new StringWriter();
                writer.write("### System Memory WRITE at 0x" + Long.toHexString(max) + "\n");
                new Exception().printStackTrace(new PrintWriter(writer));
                Inspector.inspect(buf, writer.toString());
            }
        }
    }

    @Override
    public TraceHook traceWrite(long begin, long end, TraceWriteListener listener) {
        TraceMemoryHook hook = new TraceMemoryHook(false);
        if (listener != null) {
            hook.traceWriteListener = listener;
        }
        this.backend.hook_add_new(hook, begin, end, (Object)this);
        return hook;
    }

    @Override
    public final TraceHook traceRead() {
        return this.traceRead(1L, 0L);
    }

    @Override
    public final TraceHook traceWrite() {
        return this.traceWrite(1L, 0L);
    }

    @Override
    public final TraceHook traceCode() {
        return this.traceCode(1L, 0L);
    }

    @Override
    public final TraceHook traceCode(long begin, long end) {
        return this.traceCode(begin, end, null);
    }

    @Override
    public TraceHook traceCode(long begin, long end, TraceCodeListener listener) {
        AssemblyCodeDumper hook = new AssemblyCodeDumper(this, begin, end, listener);
        this.backend.hook_add_new(hook, begin, end, (Object)this);
        return hook;
    }

    @Override
    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    @Override
    public boolean isRunning() {
        return this.running;
    }

    @Override
    public ThreadDispatcher getThreadDispatcher() {
        return this.threadDispatcher;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean emulateSignal(int sig) {
        MainTask main = this.getSyscallHandler().createSignalHandlerTask(this, sig);
        if (main == null) {
            return false;
        }
        Memory memory = this.getMemory();
        long spBackup = memory.getStackPoint();
        try {
            this.threadDispatcher.runMainForResult(main);
        }
        finally {
            memory.setStackPoint(spBackup);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final Number runMainForResult(MainTask task) {
        Memory memory = this.getMemory();
        long spBackup = memory.getStackPoint();
        try {
            Number number = this.getThreadDispatcher().runMainForResult(task);
            return number;
        }
        finally {
            memory.setStackPoint(spBackup);
        }
    }

    /*
     * Exception decompiling
     */
    public final Number emulate(long begin, long until) throws PopContextException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [5[CATCHBLOCK]], but top level block is 3[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private int handleEmuException(RuntimeException e, Pointer pointer, long start) {
        boolean enterDebug = log.isDebugEnabled();
        if (enterDebug || !log.isWarnEnabled()) {
            e.printStackTrace(System.out);
            this.attach().debug();
        } else {
            String msg = e.getMessage();
            if (msg == null) {
                msg = e.getClass().getName();
            }
            RunnableTask runningTask = this.threadDispatcher.getRunningTask();
            log.warn("emulate {} exception sp={}, msg={}, offset={}ms{}", new Object[]{pointer, this.getStackPointer(), msg, System.currentTimeMillis() - start, runningTask == null ? "" : " @ " + runningTask});
        }
        return -1;
    }

    public abstract Pointer getStackPointer();

    @Override
    public final synchronized void close() throws IOException {
        if (this.closed) {
            throw new IOException("Already closed.");
        }
        try {
            IOUtils.close((Closeable)this.debugger);
            this.closeInternal();
            this.backend.destroy();
        }
        finally {
            this.closed = true;
        }
    }

    protected abstract void closeInternal();

    @Override
    public Backend getBackend() {
        return this.backend;
    }

    @Override
    public String getProcessName() {
        return this.processName == null ? "unidbg" : this.processName;
    }

    @Override
    public void set(String key, Object value) {
        this.context.put(key, value);
    }

    @Override
    public <V> V get(String key) {
        return (V)this.context.get(key);
    }

    protected abstract boolean isPaddingArgument();

    protected void dumpClass(String className) {
        throw new UnsupportedOperationException("dumpClass className=" + className);
    }

    protected void searchClass(String keywords) {
        throw new UnsupportedOperationException("searchClass keywords=" + keywords);
    }

    protected void dumpGPBProtobufMsg(String className) {
        throw new UnsupportedOperationException("dumpGPBProtobufMsg className=" + className);
    }

    @Override
    public final void serialize(DataOutput out) throws IOException {
        out.writeUTF(this.getClass().getName());
        this.getMemory().serialize(out);
        this.getSvcMemory().serialize(out);
        this.getSyscallHandler().serialize(out);
        this.getDlfcn().serialize(out);
    }

    @Override
    public void pushContext(int off) {
        long context = this.backend.context_alloc();
        this.backend.context_save(context);
        this.contextStack.push(new Context(context, off));
    }

    @Override
    public int popContext() {
        Context ctx = this.contextStack.pop();
        ctx.restoreAndFree(this.backend);
        return ctx.off;
    }

    private /* synthetic */ void lambda$emulate$0() {
        this.backend.emu_stop();
        Debugger debugger = this.attach();
        if (!debugger.isDebugging()) {
            debugger.debug();
        }
    }

    private static class Context {
        private final long ctx;
        private final int off;

        Context(long ctx, int off) {
            this.ctx = ctx;
            this.off = off;
        }

        void restoreAndFree(Backend backend) {
            backend.context_restore(this.ctx);
            backend.context_free(this.ctx);
        }
    }
}

