/*
 * Decompiled with CFR 0.152.
 */
package com.github.unidbg;

import com.github.unidbg.utils.Inspector;
import com.sun.jna.Pointer;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Utils {
    private static final Log log = LogFactory.getLog(Utils.class);

    private static String digits(long val, int digits) {
        long hi = 1L << digits * 4;
        return Long.toHexString(hi | val & hi - 1L).substring(1);
    }

    public static String toUUID(byte[] data) {
        int i;
        if (data == null) {
            return null;
        }
        long msb = 0L;
        long lsb = 0L;
        assert (data.length == 16) : "data must be 16 bytes in length";
        for (i = 0; i < 8; ++i) {
            msb = msb << 8 | (long)(data[i] & 0xFF);
        }
        for (i = 8; i < 16; ++i) {
            lsb = lsb << 8 | (long)(data[i] & 0xFF);
        }
        long mostSigBits = msb;
        long leastSigBits = lsb;
        return (Utils.digits(mostSigBits >> 32, 8) + "-" + Utils.digits(mostSigBits >> 16, 4) + "-" + Utils.digits(mostSigBits, 4) + "-" + Utils.digits(leastSigBits >> 48, 4) + "-" + Utils.digits(leastSigBits, 12)).toUpperCase();
    }

    public static long readSignedLeb128(ByteBuffer buffer, int size) {
        long b;
        int shift = 0;
        long value = 0L;
        do {
            b = buffer.get() & 0xFF;
            value |= (b & 0x7FL) << shift;
            shift += 7;
        } while ((b & 0x80L) != 0L);
        if (shift < size && (b & 0x40L) != 0L) {
            value |= -(1L << shift);
        }
        return value;
    }

    public static BigInteger readULEB128(ByteBuffer buffer) {
        BigInteger result = BigInteger.ZERO;
        int shift = 0;
        while (true) {
            byte b = buffer.get();
            result = result.or(BigInteger.valueOf(b & 0x7F).shiftLeft(shift));
            if ((b & 0x80) == 0) break;
            shift += 7;
        }
        return result;
    }

    /*
     * Exception decompiling
     */
    public static ByteBuffer mapBuffer(File file) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static int readFile(RandomAccessFile randomAccessFile, Pointer buffer, int _count) {
        try {
            int count = _count;
            long remaining = randomAccessFile.length() - randomAccessFile.getFilePointer();
            if ((long)count > remaining && (count = (int)remaining) < 0) {
                log.warn((Object)("read path=" + randomAccessFile + ", fp=" + randomAccessFile.getFilePointer() + ", _count=" + _count + ", length=" + randomAccessFile.length() + ", buffer=" + buffer));
                return 0;
            }
            int total = 0;
            byte[] buf = new byte[Math.min(4096, count)];
            Pointer pointer = buffer;
            while (total < count) {
                int read = randomAccessFile.read(buf, 0, Math.min(buf.length, count - total));
                if (read <= 0) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("read path=" + randomAccessFile + ", fp=" + randomAccessFile.getFilePointer() + ", read=" + read + ", length=" + randomAccessFile.length() + ", buffer=" + buffer));
                    }
                    return total;
                }
                if (randomAccessFile.getFilePointer() > randomAccessFile.length()) {
                    throw new IllegalStateException("fp=" + randomAccessFile.getFilePointer() + ", length=" + randomAccessFile.length());
                }
                if (read > buf.length) {
                    throw new IllegalStateException("count=" + buf.length + ", read=" + read);
                }
                if (log.isDebugEnabled()) {
                    Inspector.inspect(buf, "read path=" + randomAccessFile + ", fp=" + randomAccessFile.getFilePointer() + ", read=" + read + ", length=" + randomAccessFile.length() + ", buffer=" + buffer);
                }
                pointer.write(0L, buf, 0, read);
                total += read;
                pointer = pointer.share((long)read);
            }
            return total;
        }
        catch (IOException e) {
            throw new IllegalStateException();
        }
    }

    public static File getClassLocation(Class<?> clazz) {
        return new File(clazz.getProtectionDomain().getCodeSource().getLocation().getPath());
    }

    public static long parseNumber(String str) {
        if (str.startsWith("0x")) {
            return Long.parseLong(str.substring(2).trim(), 16);
        }
        return Long.parseLong(str);
    }

    public static String decodeVectorRegister(byte[] data) {
        if (data.length != 16) {
            throw new IllegalStateException("data.length=" + data.length);
        }
        ByteBuffer buffer = ByteBuffer.allocate(16);
        buffer.order(ByteOrder.LITTLE_ENDIAN);
        buffer.put(data);
        buffer.flip();
        boolean twoDouble = false;
        for (int i = 8; i < 16; ++i) {
            if (data[i] == 0) continue;
            twoDouble = true;
            break;
        }
        if (twoDouble) {
            return String.format("(%s, %s)", buffer.getDouble(), buffer.getDouble());
        }
        boolean isDouble = false;
        for (int i = 4; i < 8; ++i) {
            if (data[i] == 0) continue;
            isDouble = true;
            break;
        }
        return String.format("(%s)", isDouble ? buffer.getDouble() : (double)buffer.getFloat());
    }
}

