/*
 * Decompiled with CFR 0.152.
 */
package com.github.unidbg.arm;

import capstone.api.Instruction;
import capstone.api.RegsAccess;
import com.github.unidbg.AssemblyCodeDumper;
import com.github.unidbg.Emulator;
import com.github.unidbg.Family;
import com.github.unidbg.Module;
import com.github.unidbg.Symbol;
import com.github.unidbg.TraceMemoryHook;
import com.github.unidbg.Utils;
import com.github.unidbg.arm.ARM;
import com.github.unidbg.arm.CodeHistory;
import com.github.unidbg.arm.backend.Backend;
import com.github.unidbg.arm.backend.UnHook;
import com.github.unidbg.debugger.BreakPoint;
import com.github.unidbg.debugger.BreakPointCallback;
import com.github.unidbg.debugger.DebugListener;
import com.github.unidbg.debugger.DebugRunnable;
import com.github.unidbg.debugger.Debugger;
import com.github.unidbg.debugger.FunctionCallListener;
import com.github.unidbg.memory.MemRegion;
import com.github.unidbg.memory.Memory;
import com.github.unidbg.memory.MemoryMap;
import com.github.unidbg.pointer.UnidbgPointer;
import com.github.unidbg.thread.Task;
import com.github.unidbg.unix.struct.StdString;
import com.github.unidbg.utils.Inspector;
import com.github.zhkl0228.demumble.DemanglerFactory;
import com.github.zhkl0228.demumble.GccDemangler;
import com.sun.jna.Pointer;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import keystone.Keystone;
import keystone.KeystoneEncoded;
import keystone.exceptions.AssembleFailedKeystoneException;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class AbstractARMDebugger
implements Debugger {
    private static final Log log = LogFactory.getLog(AbstractARMDebugger.class);
    private final Map<Long, BreakPoint> breakMap = new LinkedHashMap<Long, BreakPoint>();
    protected final Emulator<?> emulator;
    private final List<UnHook> unHookList = new ArrayList<UnHook>();
    private DebugListener listener;
    private boolean debugging;
    private boolean blockHooked;
    private boolean breakNextBlock;
    private String breakMnemonic;
    protected boolean callbackRunning;
    private AssemblyCodeDumper traceHook;
    private PrintStream traceHookRedirectStream;
    private TraceMemoryHook traceRead;
    private PrintStream traceReadRedirectStream;
    private TraceMemoryHook traceWrite;
    private PrintStream traceWriteRedirectStream;

    protected AbstractARMDebugger(Emulator<?> emulator) {
        this.emulator = emulator;
    }

    @Override
    public void onAttach(UnHook unHook) {
        this.unHookList.add(unHook);
    }

    @Override
    public void detach() {
        Iterator<UnHook> iterator = this.unHookList.iterator();
        while (iterator.hasNext()) {
            iterator.next().unhook();
            iterator.remove();
        }
    }

    @Override
    public final BreakPoint addBreakPoint(Module module, String symbol) {
        Symbol sym = module.findSymbolByName(symbol, false);
        if (sym == null) {
            throw new IllegalStateException("find symbol failed: " + symbol);
        }
        return this.addBreakPoint(module, sym.getValue());
    }

    @Override
    public final BreakPoint addBreakPoint(Module module, String symbol, BreakPointCallback callback) {
        Symbol sym = module.findSymbolByName(symbol, false);
        if (sym == null) {
            throw new IllegalStateException("find symbol failed: " + symbol);
        }
        return this.addBreakPoint(module, sym.getValue(), callback);
    }

    @Override
    public final BreakPoint addBreakPoint(Module module, long offset) {
        long address = module == null ? offset : module.base + offset;
        return this.addBreakPoint(address);
    }

    @Override
    public final BreakPoint addBreakPoint(Module module, long offset, BreakPointCallback callback) {
        long address = module == null ? offset : module.base + offset;
        return this.addBreakPoint(address, callback);
    }

    @Override
    public BreakPoint addBreakPoint(long address) {
        return this.addBreakPoint(address, null);
    }

    @Override
    public BreakPoint addBreakPoint(long address, BreakPointCallback callback) {
        boolean thumb = (address & 1L) != 0L;
        address &= 0xFFFFFFFFFFFFFFFEL;
        if (log.isDebugEnabled()) {
            log.debug((Object)("addBreakPoint address=0x" + Long.toHexString(address)));
        }
        BreakPoint breakPoint = this.emulator.getBackend().addBreakPoint(address, callback, thumb);
        this.breakMap.put(address, breakPoint);
        return breakPoint;
    }

    @Override
    public void traceFunctionCall(FunctionCallListener listener) {
        this.traceFunctionCall(null, listener);
    }

    @Override
    public void traceFunctionCall(Module module, FunctionCallListener listener) {
        throw new UnsupportedOperationException();
    }

    protected abstract Keystone createKeystone(boolean var1);

    public final boolean removeBreakPoint(long address) {
        if (this.breakMap.containsKey(address &= 0xFFFFFFFFFFFFFFFEL)) {
            this.breakMap.remove(address);
            return this.emulator.getBackend().removeBreakPoint(address);
        }
        return false;
    }

    @Override
    public void setDebugListener(DebugListener listener) {
        this.listener = listener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onBreak(Backend backend, long address, int size, Object user) {
        BreakPointCallback callback;
        BreakPoint breakPoint = this.breakMap.get(address);
        if (breakPoint != null && breakPoint.isTemporary()) {
            this.removeBreakPoint(address);
        }
        if (breakPoint != null && (callback = breakPoint.getCallback()) != null && callback.onHit(this.emulator, address)) {
            return;
        }
        try {
            if (this.listener == null || this.listener.canDebug(this.emulator, new CodeHistory(address, size, ARM.isThumb(backend)))) {
                this.cancelTrace();
                this.debugging = true;
                this.loop(this.emulator, address, size, null);
            }
        }
        catch (Exception e) {
            log.warn((Object)"process loop failed", (Throwable)e);
        }
        finally {
            this.debugging = false;
        }
    }

    private void cancelTrace() {
        if (this.traceHook != null) {
            this.traceHook.detach();
            this.traceHook = null;
        }
        if (this.traceHookRedirectStream != null) {
            com.alibaba.fastjson.util.IOUtils.close((Closeable)this.traceHookRedirectStream);
            this.traceHookRedirectStream = null;
        }
        if (this.traceRead != null) {
            this.traceRead.detach();
            this.traceRead = null;
        }
        if (this.traceReadRedirectStream != null) {
            com.alibaba.fastjson.util.IOUtils.close((Closeable)this.traceReadRedirectStream);
            this.traceReadRedirectStream = null;
        }
        if (this.traceWrite != null) {
            this.traceWrite.detach();
            this.traceWrite = null;
        }
        if (this.traceWriteRedirectStream != null) {
            com.alibaba.fastjson.util.IOUtils.close((Closeable)this.traceWriteRedirectStream);
            this.traceWriteRedirectStream = null;
        }
    }

    @Override
    public boolean isDebugging() {
        return this.debugging;
    }

    @Override
    public void hookBlock(Backend backend, long address, int size, Object user) {
        if (this.breakNextBlock) {
            this.onBreak(backend, address, size, user);
            this.breakNextBlock = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void hook(Backend backend, long address, int size, Object user) {
        Emulator emulator = (Emulator)user;
        try {
            CodeHistory history;
            Instruction[] instructions;
            if (this.breakMnemonic != null && (instructions = (history = new CodeHistory(address, size, ARM.isThumb(backend))).disassemble(emulator)).length > 0 && this.breakMnemonic.equals(instructions[0].getMnemonic())) {
                this.breakMnemonic = null;
                backend.setFastDebug(true);
                this.cancelTrace();
                this.debugging = true;
                this.loop(emulator, address, size, null);
            }
        }
        catch (Exception e) {
            log.warn((Object)"process hook failed", (Throwable)e);
        }
        finally {
            this.debugging = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void debug() {
        Backend backend = this.emulator.getBackend();
        long address = this.emulator.is32Bit() ? (long)backend.reg_read(11).intValue() & 0xFFFFFFFFL : backend.reg_read(260).longValue();
        try {
            this.cancelTrace();
            this.debugging = true;
            this.loop(this.emulator, address, 4, null);
        }
        catch (Exception e) {
            log.warn((Object)"debug failed", (Throwable)e);
        }
        finally {
            this.debugging = false;
        }
    }

    protected final void setSingleStep(int singleStep) {
        this.emulator.getBackend().setSingleStep(singleStep);
    }

    protected abstract void loop(Emulator<?> var1, long var2, int var4, DebugRunnable<?> var5) throws Exception;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T run(DebugRunnable<T> runnable) throws Exception {
        T ret;
        if (runnable == null) {
            throw new NullPointerException();
        }
        try {
            this.callbackRunning = true;
            ret = runnable.runWithArgs(null);
        }
        finally {
            this.callbackRunning = false;
        }
        try {
            this.cancelTrace();
            this.debugging = true;
            this.loop(this.emulator, -1L, 0, runnable);
        }
        finally {
            this.debugging = false;
        }
        return ret;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    final void dumpMemory(Pointer pointer, int _length, String label, StringType stringType) {
        if (stringType != null) {
            if (stringType == StringType.nullTerminated) {
                long addr = 0L;
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                boolean foundTerminated = false;
                do {
                    byte[] data = pointer.getByteArray(addr, 16);
                    int length = data.length;
                    for (int i = 0; i < data.length; ++i) {
                        if (data[i] != 0) continue;
                        length = i;
                        break;
                    }
                    baos.write(data, 0, length);
                    addr += (long)length;
                    if (length >= data.length) continue;
                    foundTerminated = true;
                    break;
                } while (baos.size() <= 65536);
                if (foundTerminated) {
                    Inspector.inspect(baos.toByteArray(), baos.size() >= 1024 ? label + ", hex=" + Hex.encodeHexString((byte[])baos.toByteArray()) : label + ", str=" + new String(baos.toByteArray(), StandardCharsets.UTF_8));
                    return;
                } else {
                    Inspector.inspect(pointer.getByteArray(0L, _length), label + ", find NULL-terminated failed");
                }
                return;
            }
            if (stringType != StringType.std_string) throw new UnsupportedOperationException("stringType=" + (Object)((Object)stringType));
            StdString string = StdString.createStdString(this.emulator, pointer);
            long size = string.getDataSize();
            byte[] data = string.getData(this.emulator);
            Inspector.inspect(data, size >= 1024L ? label + ", hex=" + Hex.encodeHexString((byte[])data) + ", std=" + new String(data, StandardCharsets.UTF_8) : label);
            return;
        }
        StringBuilder sb = new StringBuilder(label);
        byte[] data = pointer.getByteArray(0L, _length);
        if (_length == 4) {
            ByteBuffer buffer = ByteBuffer.wrap(data);
            buffer.order(ByteOrder.LITTLE_ENDIAN);
            int value = buffer.getInt();
            sb.append(", value=0x").append(Integer.toHexString(value));
        } else if (_length == 8) {
            ByteBuffer buffer = ByteBuffer.wrap(data);
            buffer.order(ByteOrder.LITTLE_ENDIAN);
            long value = buffer.getLong();
            sb.append(", value=0x").append(Long.toHexString(value));
        } else if (_length == 16) {
            byte[] tmp = Arrays.copyOf(data, 16);
            for (int i = 0; i < 8; ++i) {
                byte b = tmp[i];
                tmp[i] = tmp[15 - i];
                tmp[15 - i] = b;
            }
            byte[] bytes = new byte[tmp.length + 1];
            System.arraycopy(tmp, 0, bytes, 1, tmp.length);
            sb.append(", value=0x").append(new BigInteger(bytes).toString(16));
        }
        if (data.length >= 1024) {
            sb.append(", hex=").append(Hex.encodeHexString((byte[])data));
        }
        Inspector.inspect(data, sb.toString());
    }

    private void searchStack(byte[] data) {
        if (data == null || data.length < 1) {
            System.err.println("search stack failed as empty data");
            return;
        }
        UnidbgPointer stack = this.emulator.getContext().getStackPointer();
        Backend backend = this.emulator.getBackend();
        Collection<Pointer> pointers = this.searchMemory(backend, stack.peer, this.emulator.getMemory().getStackBase(), data);
        System.out.println("Search stack from " + stack + " matches " + pointers.size() + " count");
        for (Pointer pointer : pointers) {
            System.out.println("Stack matches: " + pointer);
        }
    }

    private void searchHeap(byte[] data, int prot) {
        if (data == null || data.length < 1) {
            System.err.println("search heap failed as empty data");
            return;
        }
        ArrayList<Pointer> list = new ArrayList<Pointer>();
        Backend backend = this.emulator.getBackend();
        for (MemoryMap map : this.emulator.getMemory().getMemoryMap()) {
            if ((map.prot & prot) == 0) continue;
            Collection<Pointer> pointers = this.searchMemory(backend, map.base, map.base + map.size, data);
            list.addAll(pointers);
        }
        System.out.println("Search heap matches " + list.size() + " count");
        for (Pointer pointer : list) {
            System.out.println("Heap matches: " + pointer);
        }
    }

    private Collection<Pointer> searchMemory(Backend backend, long start, long end, byte[] data) {
        ArrayList<Pointer> pointers = new ArrayList<Pointer>();
        long m = end - (long)data.length;
        for (long i = start; i < m; ++i) {
            byte[] oneByte = backend.mem_read(i, 1L);
            if (data[0] != oneByte[0] || !Arrays.equals(data, backend.mem_read(i, data.length))) continue;
            pointers.add(UnidbgPointer.pointer(this.emulator, i));
            i += (long)(data.length - 1);
        }
        return pointers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    final boolean handleCommon(Backend backend, String line, long address, int size, long nextAddress, DebugRunnable<?> runnable) throws Exception {
        Memory memory;
        block125: {
            long end;
            long begin;
            block120: {
                block126: {
                    block123: {
                        long end2;
                        long begin2;
                        block119: {
                            block124: {
                                Matcher matcher;
                                Pattern pattern;
                                block121: {
                                    long end3;
                                    long begin3;
                                    block118: {
                                        block122: {
                                            String keywords;
                                            String className;
                                            String hex;
                                            byte[] data;
                                            int index;
                                            if ("exit".equals(line)) return true;
                                            if ("quit".equals(line)) return true;
                                            if ("q".equals(line)) {
                                                return true;
                                            }
                                            if ("gc".equals(line)) {
                                                System.out.println("Run System.gc();");
                                                System.gc();
                                                return false;
                                            }
                                            if ("threads".equals(line)) {
                                                Iterator<Task> iterator = this.emulator.getThreadDispatcher().getTaskList().iterator();
                                                while (iterator.hasNext()) {
                                                    Task task = iterator.next();
                                                    System.out.println(task.getId() + ": " + task);
                                                }
                                                return false;
                                            }
                                            if (runnable == null || this.callbackRunning) {
                                                if ("c".equals(line)) {
                                                    return true;
                                                }
                                            } else if ("c".equals(line)) {
                                                try {
                                                    this.callbackRunning = true;
                                                    runnable.runWithArgs(null);
                                                    this.cancelTrace();
                                                    boolean bl = false;
                                                    return bl;
                                                }
                                                finally {
                                                    this.callbackRunning = false;
                                                }
                                            }
                                            if ("n".equals(line)) {
                                                if (nextAddress == 0L) {
                                                    System.out.println("Next address failed.");
                                                    return false;
                                                }
                                                this.addBreakPoint(nextAddress).setTemporary(true);
                                                return true;
                                            }
                                            if (line.startsWith("st") && (index = line.indexOf(32)) != -1 && (data = Hex.decodeHex((char[])(hex = line.substring(index + 1).trim()).toCharArray())).length > 0) {
                                                this.searchStack(data);
                                                return false;
                                            }
                                            if (line.startsWith("shw") && (index = line.indexOf(32)) != -1 && (data = Hex.decodeHex((char[])(hex = line.substring(index + 1).trim()).toCharArray())).length > 0) {
                                                this.searchHeap(data, 2);
                                                return false;
                                            }
                                            if (line.startsWith("shr") && (index = line.indexOf(32)) != -1 && (data = Hex.decodeHex((char[])(hex = line.substring(index + 1).trim()).toCharArray())).length > 0) {
                                                this.searchHeap(data, 1);
                                                return false;
                                            }
                                            if (line.startsWith("shx") && (index = line.indexOf(32)) != -1 && (data = Hex.decodeHex((char[])(hex = line.substring(index + 1).trim()).toCharArray())).length > 0) {
                                                this.searchHeap(data, 4);
                                                return false;
                                            }
                                            if (this.emulator.getFamily() == Family.iOS && !this.emulator.isRunning() && line.startsWith("dump ") && !(className = line.substring(5).trim()).isEmpty()) {
                                                this.dumpClass(className);
                                                return false;
                                            }
                                            if (this.emulator.getFamily() == Family.iOS && !this.emulator.isRunning() && line.startsWith("gpb ") && !(className = line.substring(4).trim()).isEmpty()) {
                                                this.dumpGPBProtobufMsg(className);
                                                return false;
                                            }
                                            if (this.emulator.getFamily() == Family.iOS && !this.emulator.isRunning() && line.startsWith("search ") && !(keywords = line.substring(7).trim()).isEmpty()) {
                                                this.searchClass(keywords);
                                                return false;
                                            }
                                            int traceSize = 65536;
                                            if (!line.startsWith("traceRead")) break block121;
                                            pattern = Pattern.compile("traceRead\\s+(\\w+)\\s+(\\w+)");
                                            matcher = pattern.matcher(line);
                                            if (this.traceRead != null) {
                                                this.traceRead.detach();
                                            }
                                            this.traceRead = new TraceMemoryHook(true);
                                            if (!matcher.find()) break block122;
                                            begin3 = Utils.parseNumber(matcher.group(1));
                                            if (begin3 > (end3 = Utils.parseNumber(matcher.group(2))) && end3 > 0L && end3 <= 65536L) {
                                                end3 += begin3;
                                            }
                                            if (begin3 >= end3) {
                                                File traceFile2 = new File("target/traceRead.txt");
                                                if (!traceFile2.exists() && !traceFile2.createNewFile()) {
                                                    throw new IllegalStateException("createNewFile: " + traceFile2);
                                                }
                                                this.traceReadRedirectStream = new PrintStream(new BufferedOutputStream(Files.newOutputStream(traceFile2.toPath(), new OpenOption[0])), true);
                                                this.traceReadRedirectStream.printf("[%s]Start traceRead%n", new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date()));
                                                this.traceRead.setRedirect(this.traceReadRedirectStream);
                                                System.out.printf("Set trace all memory read success with trace file: %s.%n", traceFile2);
                                                break block118;
                                            } else {
                                                boolean needTraceFile;
                                                boolean bl = needTraceFile = end3 - begin3 > 65536L;
                                                if (needTraceFile) {
                                                    File traceFile3 = new File(String.format("target/traceRead_0x%x-0x%x.txt", begin3, end3));
                                                    if (!traceFile3.exists() && !traceFile3.createNewFile()) {
                                                        throw new IllegalStateException("createNewFile: " + traceFile3);
                                                    }
                                                    this.traceReadRedirectStream = new PrintStream(new BufferedOutputStream(Files.newOutputStream(traceFile3.toPath(), new OpenOption[0])), true);
                                                    this.traceReadRedirectStream.printf("[%s]Start traceRead: 0x%x-0x%x%n", new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date()), begin3, end3);
                                                    this.traceRead.setRedirect(this.traceReadRedirectStream);
                                                    System.out.printf("Set trace 0x%x->0x%x memory read success with trace file: %s.%n", begin3, end3, traceFile3.getAbsolutePath());
                                                    break block118;
                                                } else {
                                                    System.out.printf("Set trace 0x%x->0x%x memory read success.%n", begin3, end3);
                                                }
                                            }
                                            break block118;
                                        }
                                        begin3 = 1L;
                                        end3 = 0L;
                                        File traceFile4 = new File("target/traceRead.txt");
                                        if (!traceFile4.exists() && !traceFile4.createNewFile()) {
                                            throw new IllegalStateException("createNewFile: " + traceFile4);
                                        }
                                        this.traceReadRedirectStream = new PrintStream(new BufferedOutputStream(Files.newOutputStream(traceFile4.toPath(), new OpenOption[0])), true);
                                        this.traceReadRedirectStream.printf("[%s]Start traceRead%n", new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date()));
                                        this.traceRead.setRedirect(this.traceReadRedirectStream);
                                        System.out.printf("Set trace all memory read success with trace file: %s.%n", traceFile4.getAbsolutePath());
                                    }
                                    backend.hook_add_new(this.traceRead, begin3, end3, (Object)this.emulator);
                                    return false;
                                }
                                if (!line.startsWith("traceWrite")) break block123;
                                pattern = Pattern.compile("traceWrite\\s+(\\w+)\\s+(\\w+)");
                                matcher = pattern.matcher(line);
                                if (this.traceWrite != null) {
                                    this.traceWrite.detach();
                                }
                                this.traceWrite = new TraceMemoryHook(false);
                                if (!matcher.find()) break block124;
                                begin2 = Utils.parseNumber(matcher.group(1));
                                if (begin2 > (end2 = Utils.parseNumber(matcher.group(2))) && end2 > 0L && end2 <= 65536L) {
                                    end2 += begin2;
                                }
                                if (begin2 >= end2) {
                                    File traceFile5 = new File("target/traceWrite.txt");
                                    if (!traceFile5.exists() && !traceFile5.createNewFile()) {
                                        throw new IllegalStateException("createNewFile: " + traceFile5);
                                    }
                                    this.traceWriteRedirectStream = new PrintStream(new BufferedOutputStream(Files.newOutputStream(traceFile5.toPath(), new OpenOption[0])), true);
                                    this.traceWriteRedirectStream.printf("[%s]Start traceWrite%n", new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date()));
                                    this.traceWrite.setRedirect(this.traceWriteRedirectStream);
                                    System.out.printf("Set trace all memory write success with trace file: %s.%n", traceFile5);
                                    break block119;
                                } else {
                                    boolean needTraceFile;
                                    boolean bl = needTraceFile = end2 - begin2 > 65536L;
                                    if (needTraceFile) {
                                        File traceFile6 = new File(String.format("target/traceWrite_0x%x-0x%x.txt", begin2, end2));
                                        if (!traceFile6.exists() && !traceFile6.createNewFile()) {
                                            throw new IllegalStateException("createNewFile: " + traceFile6);
                                        }
                                        this.traceWriteRedirectStream = new PrintStream(new BufferedOutputStream(Files.newOutputStream(traceFile6.toPath(), new OpenOption[0])), true);
                                        this.traceWriteRedirectStream.printf("[%s]Start traceWrite: 0x%x-0x%x%n", new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date()), begin2, end2);
                                        this.traceWrite.setRedirect(this.traceWriteRedirectStream);
                                        System.out.printf("Set trace 0x%x->0x%x memory write success with trace file: %s.%n", begin2, end2, traceFile6.getAbsolutePath());
                                        break block119;
                                    } else {
                                        System.out.printf("Set trace 0x%x->0x%x memory write success.%n", begin2, end2);
                                    }
                                }
                                break block119;
                            }
                            begin2 = 1L;
                            end2 = 0L;
                            File traceFile7 = new File("target/traceWrite.txt");
                            if (!traceFile7.exists() && !traceFile7.createNewFile()) {
                                throw new IllegalStateException("createNewFile: " + traceFile7);
                            }
                            this.traceWriteRedirectStream = new PrintStream(new BufferedOutputStream(Files.newOutputStream(traceFile7.toPath(), new OpenOption[0])), true);
                            this.traceWriteRedirectStream.printf("[%s]Start traceWrite%n", new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date()));
                            this.traceWrite.setRedirect(this.traceWriteRedirectStream);
                            System.out.printf("Set trace all memory write success with trace file: %s.%n", traceFile7.getAbsolutePath());
                        }
                        backend.hook_add_new(this.traceWrite, begin2, end2, (Object)this.emulator);
                        return false;
                    }
                    if (!line.startsWith("trace")) break block125;
                    memory = this.emulator.getMemory();
                    Pattern pattern2 = Pattern.compile("trace\\s+(\\w+)\\s+(\\w+)");
                    Matcher matcher2 = pattern2.matcher(line);
                    if (this.traceHook != null) {
                        this.traceHook.detach();
                    }
                    this.traceHookRedirectStream = null;
                    if (!matcher2.find()) break block126;
                    begin = Utils.parseNumber(matcher2.group(1));
                    if (begin > (end = Utils.parseNumber(matcher2.group(2))) && end > 0L && end < 65536L) {
                        end += begin;
                    }
                    if (begin >= end) {
                        File traceFile8 = new File("target/traceCode.txt");
                        if (!traceFile8.exists()) {
                            if (!traceFile8.getParentFile().exists()) throw new IllegalStateException("createNewFile: " + traceFile8.getAbsolutePath());
                            if (!traceFile8.createNewFile()) {
                                throw new IllegalStateException("createNewFile: " + traceFile8.getAbsolutePath());
                            }
                        }
                        this.traceHookRedirectStream = new PrintStream(new BufferedOutputStream(Files.newOutputStream(traceFile8.toPath(), new OpenOption[0])), true);
                        this.traceHookRedirectStream.printf("[%s]Start traceCode%n", new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date()));
                        System.out.printf("Set trace all instructions success with trace file: %s.%n", traceFile8.getAbsolutePath());
                        break block120;
                    } else {
                        boolean needTraceFile;
                        boolean bl = needTraceFile = end - begin > 65536L;
                        if (needTraceFile) {
                            File traceFile9 = new File(String.format("target/traceCode_0x%x-0x%x.txt", begin, end));
                            if (!traceFile9.exists() && !traceFile9.createNewFile()) {
                                throw new IllegalStateException("createNewFile: " + traceFile9);
                            }
                            this.traceHookRedirectStream = new PrintStream(new BufferedOutputStream(Files.newOutputStream(traceFile9.toPath(), new OpenOption[0])), true);
                            this.traceHookRedirectStream.printf("[%s]Start traceCode: 0x%x-0x%x%n", new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date()), begin, end);
                            System.out.printf("Set trace 0x%x->0x%x instructions success with trace file: %s.%n", begin, end, traceFile9.getAbsolutePath());
                            break block120;
                        } else {
                            System.out.printf("Set trace 0x%x->0x%x instructions success.%n", begin, end);
                        }
                    }
                    break block120;
                }
                String redirect = null;
                Module module = memory.findModuleByAddress(address);
                int index2 = line.indexOf(32);
                if (index2 != -1) {
                    redirect = line.substring(index2 + 1).trim();
                }
                File traceFile1022 = null;
                if (redirect != null && !redirect.trim().isEmpty()) {
                    Module check = memory.findModule(redirect);
                    if (check != null) {
                        module = check;
                    } else {
                        File outFile = new File(redirect.trim());
                        try {
                            if (!outFile.exists() && !outFile.createNewFile()) {
                                throw new IllegalStateException("createNewFile: " + outFile);
                            }
                            this.traceHookRedirectStream = new PrintStream(new BufferedOutputStream(Files.newOutputStream(outFile.toPath(), new OpenOption[0])), true);
                            this.traceHookRedirectStream.printf("[%s]Start trace %s%n", new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date()), module == null ? "all" : module);
                            traceFile1022 = outFile;
                        }
                        catch (IOException e) {
                            System.err.println("Set trace redirect out file failed: " + outFile);
                            return false;
                        }
                    }
                }
                begin = module == null ? 1L : module.base;
                end = module == null ? 0L : module.base + module.size;
                System.out.println("Set trace " + (module == null ? "all" : module) + " instructions success" + (traceFile1022 == null ? "." : " with trace file: " + traceFile1022.getAbsolutePath()));
            }
            this.traceHook = new AssemblyCodeDumper(this.emulator, begin, end, null);
            if (this.traceHookRedirectStream != null) {
                this.traceHook.setRedirect(this.traceHookRedirectStream);
            }
            backend.hook_add_new(this.traceHook, begin, end, this.emulator);
            return false;
        }
        if (line.startsWith("vm")) {
            memory = this.emulator.getMemory();
            String maxLengthSoName = memory.getMaxLengthLibraryName();
            StringBuilder sb = new StringBuilder();
            String filter = null;
            int index3 = line.indexOf(32);
            if (index3 != -1) {
                filter = line.substring(index3 + 1).trim();
            }
            int index2 = 0;
            long filterAddress = -1L;
            if (filter != null && filter.startsWith("0x")) {
                filterAddress = Utils.parseNumber(filter);
            }
            for (Module module : memory.getLoadedModules()) {
                if (filter != null && !module.getPath().toLowerCase().contains(filter.toLowerCase()) && (filterAddress < module.base || filterAddress >= module.base + module.size)) continue;
                sb.append(String.format("[%3s][%" + maxLengthSoName.length() + "s] ", index2++, FilenameUtils.getName((String)module.name)));
                sb.append(String.format("[0x%0" + Long.toHexString(memory.getMaxSizeOfLibrary()).length() + "x-0x%x]", module.getBaseHeader(), module.base + module.size));
                sb.append(module.getPath());
                sb.append("\n");
            }
            if (index2 == 0) {
                System.err.println("Find loaded library failed with filter: " + filter);
                return false;
            }
            System.out.println(sb);
            return false;
        }
        if (!"vbs".equals(line)) {
            if ("stop".equals(line)) {
                backend.emu_stop();
                return true;
            }
            if ("s".equals(line) || "si".equals(line)) {
                this.setSingleStep(1);
                return true;
            }
            if ("nb".equals(line)) {
                if (!this.blockHooked) {
                    this.blockHooked = true;
                    this.emulator.getBackend().hook_add_new(this, 1L, 0L, (Object)this.emulator);
                }
                this.breakNextBlock = true;
                return true;
            }
            if (line.startsWith("s")) {
                try {
                    this.setSingleStep(Integer.parseInt(line.substring(1)));
                    return true;
                }
                catch (NumberFormatException e) {
                    this.breakMnemonic = line.substring(1);
                    backend.setFastDebug(false);
                    return true;
                }
            }
            if (line.startsWith("p")) {
                long originalAddress = address;
                String assembly = line.substring(1).trim();
                boolean isThumb = ARM.isThumb(backend);
                try (Keystone keystone = this.createKeystone(isThumb);){
                    KeystoneEncoded encoded = keystone.assemble(assembly);
                    byte[] code = encoded.getMachineCode();
                    if ((long)code.length != (nextAddress & 0xFFFFFFFFFFFFFFFEL) - (address &= 0xFFFFFFFFFFFFFFFEL)) {
                        System.err.println("patch code failed: nextAddress=0x" + Long.toHexString(nextAddress) + ", codeSize=" + code.length);
                        boolean insns22 = false;
                        return insns22;
                    }
                    UnidbgPointer pointer = UnidbgPointer.pointer(this.emulator, address);
                    assert (pointer != null);
                    pointer.write(0L, code, 0, code.length);
                    this.disassemble(this.emulator, originalAddress, size, isThumb);
                    boolean traceFile1022 = false;
                    return traceFile1022;
                }
                catch (AssembleFailedKeystoneException e) {
                    System.err.println("Assemble failed: " + assembly);
                    return false;
                }
            }
            Module module = this.emulator.getMemory().findModuleByAddress(address);
            if (module != null && line.startsWith("cc")) {
                int sizeBytes = (int)Utils.parseNumber(line.substring(2).trim()) & 0xFFFFFFFE;
                if (sizeBytes < 2) {
                    System.err.println("Usage: cc (size bytes)");
                    return false;
                }
                Instruction[] insns = this.emulator.disassemble(address & 0xFFFFFFFFFFFFFFFEL, sizeBytes, 32767L);
                StringBuilder sb = new StringBuilder();
                if (this.emulator.is32Bit()) {
                    sb.append("    \"").append("push {r7, lr}").append("\\n").append('\"').append("\n\n");
                } else {
                    sb.append("    \"").append("sub sp, sp, #0x10").append("\\n").append('\"').append('\n');
                    sb.append("    \"").append("stp x29, x30, [sp]").append("\\n").append('\"').append("\n\n");
                }
                String lastRegWrite = null;
                for (Instruction insn : insns) {
                    short[] regsWrite;
                    RegsAccess regsAccess = insn.regsAccess();
                    if (regsAccess != null && (regsWrite = regsAccess.getRegsWrite()) != null && regsWrite.length == 1) {
                        lastRegWrite = insn.regName((int)regsWrite[0]);
                    }
                    String asm = "    \"" + insn + "\\n\"";
                    sb.append(String.format("%-50s", asm));
                    sb.append(" // 0x").append(Long.toHexString(insn.getAddress()));
                    sb.append(" offset 0x").append(Long.toHexString(insn.getAddress() - (address & 0xFFFFFFFFFFFFFFFEL)));
                    sb.append("\n");
                }
                sb.append('\n');
                if (this.emulator.is32Bit()) {
                    if (lastRegWrite != null && !"r0".equals(lastRegWrite)) {
                        sb.append("    \"").append("mov r0, ").append(lastRegWrite).append("\\n").append('\"').append('\n');
                    }
                    sb.append("    \"").append("pop {r7, pc}").append("\\n").append('\"');
                } else {
                    if (lastRegWrite != null && !"x0".equals(lastRegWrite) && !"w0".equals(lastRegWrite)) {
                        sb.append("    \"").append("mov ").append(lastRegWrite.startsWith("x") ? "x0" : "w0").append(", ").append(lastRegWrite).append("\\n").append('\"').append('\n');
                    }
                    sb.append("    \"").append("ldp x29, x30, [sp]").append("\\n").append('\"').append('\n');
                    sb.append("    \"").append("add sp, sp, #0x10").append("\\n").append('\"').append('\n');
                    sb.append("    \"").append("ret").append("\\n").append('\"');
                }
                try (InputStream inputStream = Objects.requireNonNull(this.getClass().getResourceAsStream("/cc.c"));){
                    String template = IOUtils.toString((InputStream)inputStream, (Charset)StandardCharsets.UTF_8);
                    template = this.emulator.is64Bit() ? template.replace("$(ARCH_SPEC)", "-m64 -arch arm64") : template.replace("$(ARCH_SPEC)", "-m32 -arch armv7");
                    System.err.println(template.replace("$(REPLACE_ASM)", sb.toString()));
                    return false;
                }
            }
            this.showHelp(address);
            return false;
        }
        memory = this.emulator.getMemory();
        StringBuilder sb = new StringBuilder("* means temporary bp:\n");
        String maxLengthSoName = memory.getMaxLengthLibraryName();
        Iterator<Map.Entry<Long, BreakPoint>> filter = this.breakMap.entrySet().iterator();
        while (true) {
            if (!filter.hasNext()) {
                System.out.println(sb);
                return false;
            }
            Map.Entry<Long, BreakPoint> entry = filter.next();
            address = entry.getKey();
            BreakPoint bp22 = entry.getValue();
            Instruction ins = null;
            try {
                byte[] code2 = backend.mem_read(address, 4L);
                Instruction[] insns22 = this.emulator.disassemble(address, code2, bp22.isThumb(), 1L);
                if (insns22 != null && insns22.length > 0) {
                    ins = insns22[0];
                }
            }
            catch (Exception code2) {
                // empty catch block
            }
            if (ins == null) {
                sb.append(String.format("[%" + String.valueOf(maxLengthSoName).length() + "s]", "0x" + Long.toHexString(address)));
                if (bp22.isTemporary()) {
                    sb.append('*');
                }
            } else {
                sb.append(ARM.assembleDetail(this.emulator, ins, address, bp22.isThumb(), bp22.isTemporary(), memory.getMaxLengthLibraryName().length()));
            }
            sb.append("\n");
        }
    }

    protected void dumpGPBProtobufMsg(String className) {
        throw new UnsupportedOperationException();
    }

    protected void searchClass(String keywords) {
    }

    protected void dumpClass(String className) {
    }

    void showHelp(long address) {
    }

    final long disassemble(Emulator<?> emulator, long address, int size, boolean thumb) {
        Symbol symbol;
        long next = 0L;
        boolean on = false;
        int maxLength = emulator.getMemory().getMaxLengthLibraryName().length();
        StringBuilder sb = new StringBuilder();
        Module module = AbstractARMDebugger.findModuleByAddress(emulator, address);
        Symbol symbol2 = symbol = module == null ? null : module.findClosestSymbolByAddress(address, false);
        if (symbol != null && address - symbol.getAddress() <= 4096L) {
            GccDemangler demangler = DemanglerFactory.createDemangler();
            sb.append(demangler.demangle(symbol.getName())).append(" + 0x").append(Long.toHexString(address - (symbol.getAddress() & 0xFFFFFFFFFFFFFFFEL))).append("\n");
        }
        long nextAddr = address - (long)size;
        for (CodeHistory history : Arrays.asList(new CodeHistory(address - (long)size, size, thumb), new CodeHistory(address, size, thumb))) {
            Instruction[] instructions = history.disassemble(emulator);
            if (instructions == null) continue;
            for (Instruction ins : instructions) {
                if (ins.getAddress() == address) {
                    sb.append("=> *");
                    on = true;
                } else {
                    sb.append("    ");
                    if (on) {
                        next = ins.getAddress();
                        on = false;
                    }
                }
                sb.append(ARM.assembleDetail(emulator, ins, ins.getAddress(), history.thumb, on, maxLength)).append('\n');
                nextAddr += (long)ins.getBytes().length;
            }
        }
        Instruction[] insns = emulator.disassemble(nextAddr, 60, 15L);
        if (insns != null) {
            for (Instruction ins : insns) {
                if (nextAddr == address) {
                    sb.append("=> *");
                    on = true;
                } else {
                    sb.append("    ");
                    if (on) {
                        next = nextAddr;
                        on = false;
                    }
                }
                sb.append(ARM.assembleDetail(emulator, ins, nextAddr, thumb, on, maxLength)).append('\n');
                nextAddr += (long)ins.getSize();
            }
        }
        System.out.println(sb);
        if (on) {
            next = nextAddr;
        }
        if (thumb) {
            next |= 1L;
        }
        return next;
    }

    @Override
    public final void disassembleBlock(Emulator<?> emulator, long address, boolean thumb) {
        Instruction[] insns;
        Symbol symbol;
        StringBuilder sb = new StringBuilder();
        Module module = AbstractARMDebugger.findModuleByAddress(emulator, address);
        Symbol symbol2 = symbol = module == null ? null : module.findClosestSymbolByAddress(address, false);
        if (symbol != null && address - symbol.getAddress() <= 4096L) {
            GccDemangler demangler = DemanglerFactory.createDemangler();
            sb.append(demangler.demangle(symbol.getName())).append(" + 0x").append(Long.toHexString(address - (symbol.getAddress() & 0xFFFFFFFFFFFFFFFEL))).append("\n");
        }
        long nextAddr = address;
        UnidbgPointer pointer = UnidbgPointer.pointer(emulator, address);
        assert (pointer != null);
        byte[] code = pointer.getByteArray(0L, 40);
        for (Instruction ins : insns = emulator.disassemble(nextAddr, code, thumb, 0L)) {
            sb.append("    ");
            sb.append(ARM.assembleDetail(emulator, ins, nextAddr, thumb, false, emulator.getMemory().getMaxLengthLibraryName().length())).append('\n');
            nextAddr += (long)ins.getSize();
        }
        System.out.println(sb);
    }

    public static Module findModuleByAddress(Emulator<?> emulator, long address) {
        MemRegion region;
        Memory memory = emulator.getMemory();
        Module module = memory.findModuleByAddress(address);
        if (module == null && (region = emulator.getSvcMemory().findRegion(address)) != null) {
            String name = region.getName();
            int maxLength = memory.getMaxLengthLibraryName().length();
            if (name.length() > maxLength) {
                name = name.substring(name.length() - maxLength);
            }
            module = new Module(name, region.begin, region.end - region.begin, Collections.emptyMap(), Collections.emptyList(), null){

                @Override
                public Number callFunction(Emulator<?> emulator, long offset, Object ... args) {
                    throw new UnsupportedOperationException();
                }

                @Override
                public Symbol findSymbolByName(String name, boolean withDependencies) {
                    throw new UnsupportedOperationException();
                }

                @Override
                public Symbol findClosestSymbolByAddress(long address, boolean fast) {
                    return null;
                }

                @Override
                public int callEntry(Emulator<?> emulator, String ... args) {
                    throw new UnsupportedOperationException();
                }

                @Override
                public String getPath() {
                    throw new UnsupportedOperationException();
                }

                @Override
                public void registerSymbol(String symbolName, long address) {
                    throw new UnsupportedOperationException();
                }

                @Override
                public int virtualMemoryAddressToFileOffset(long offset) {
                    throw new UnsupportedOperationException();
                }
            };
        }
        return module;
    }

    @Override
    public final void brk(UnidbgPointer pc, int svcNumber) {
        if (pc != null) {
            this.removeBreakPoint(pc.peer);
        }
        this.debug();
    }

    @Override
    public void close() {
    }

    protected static enum StringType {
        nullTerminated,
        std_string;

    }
}

