/*
 * Decompiled with CFR 0.152.
 */
package com.github.unidbg.arm;

import com.github.unidbg.Emulator;
import com.github.unidbg.Family;
import com.github.unidbg.Module;
import com.github.unidbg.Utils;
import com.github.unidbg.arm.ARM;
import com.github.unidbg.arm.AbstractARMDebugger;
import com.github.unidbg.arm.TraceFunctionCall64;
import com.github.unidbg.arm.backend.Backend;
import com.github.unidbg.arm.backend.BackendException;
import com.github.unidbg.debugger.DebugRunnable;
import com.github.unidbg.debugger.Debugger;
import com.github.unidbg.debugger.FunctionCallListener;
import com.github.unidbg.pointer.UnidbgPointer;
import com.github.unidbg.thread.RunnableTask;
import java.util.Scanner;
import keystone.Keystone;
import keystone.KeystoneArchitecture;
import keystone.KeystoneMode;
import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.binary.Hex;

class SimpleARM64Debugger
extends AbstractARMDebugger
implements Debugger {
    SimpleARM64Debugger(Emulator<?> emulator) {
        super(emulator);
    }

    @Override
    public void traceFunctionCall(Module module, FunctionCallListener listener) {
        Backend backend = this.emulator.getBackend();
        TraceFunctionCall64 hook = new TraceFunctionCall64(this.emulator, listener);
        long begin = module == null ? 1L : module.base;
        long end = module == null ? 0L : module.base + module.size;
        backend.hook_add_new(hook, begin, end, (Object)this.emulator);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected final void loop(Emulator<?> emulator, long address, int size, DebugRunnable<?> runnable) throws Exception {
        String line;
        Backend backend = emulator.getBackend();
        long nextAddress = 0L;
        try {
            if (address != -1L) {
                RunnableTask runningTask = emulator.getThreadDispatcher().getRunningTask();
                System.out.println("debugger break at: 0x" + Long.toHexString(address) + (runningTask == null ? "" : " @ " + runningTask));
                emulator.showRegs();
            }
            if (address > 0L) {
                nextAddress = this.disassemble(emulator, address, size, false);
            }
        }
        catch (BackendException e) {
            e.printStackTrace(System.err);
        }
        Scanner scanner = new Scanner(System.in);
        while ((line = scanner.nextLine()) != null) {
            line = line.trim();
            try {
                String[] tokens;
                if ("help".equals(line)) {
                    this.showHelp(address);
                    continue;
                }
                if (line.startsWith("run") && runnable != null) {
                    try {
                        this.callbackRunning = true;
                        String arg = line.substring(3).trim();
                        if (arg.length() > 0) {
                            String[] args = arg.split("\\s+");
                            runnable.runWithArgs(args);
                            continue;
                        }
                        runnable.runWithArgs(null);
                        continue;
                    }
                    finally {
                        this.callbackRunning = false;
                        continue;
                    }
                }
                if ("d".equals(line) || "dis".equals(line)) {
                    emulator.showRegs();
                    this.disassemble(emulator, address, size, false);
                    continue;
                }
                if (line.startsWith("d0x")) {
                    if (line.endsWith("L")) {
                        line = line.substring(0, line.length() - 1);
                    }
                    long da = Long.parseLong(line.substring(3), 16);
                    this.disassembleBlock(emulator, da & 0xFFFFFFFFFFFFFFFCL, false);
                    continue;
                }
                if (line.startsWith("m")) {
                    String command = line;
                    tokens = line.split("\\s+");
                    int length = 112;
                    try {
                        if (tokens.length >= 2) {
                            command = tokens[0];
                            String str = tokens[1];
                            length = (int)Utils.parseNumber(str);
                        }
                    }
                    catch (NumberFormatException str) {
                        // empty catch block
                    }
                    AbstractARMDebugger.StringType stringType = null;
                    if (command.endsWith("s")) {
                        stringType = AbstractARMDebugger.StringType.nullTerminated;
                        command = command.substring(0, command.length() - 1);
                    } else if (command.endsWith("std")) {
                        stringType = AbstractARMDebugger.StringType.std_string;
                        command = command.substring(0, command.length() - 3);
                    }
                    int reg = -1;
                    String name = null;
                    if (command.startsWith("mx") && (command.length() == 3 || command.length() == 4)) {
                        int idx = Integer.parseInt(command.substring(2));
                        if (idx >= 0 && idx <= 28) {
                            reg = 199 + idx;
                            name = "x" + idx;
                        }
                    } else if ("mfp".equals(command)) {
                        reg = 1;
                        name = "fp";
                    } else if ("mip".equals(command)) {
                        reg = 215;
                        name = "ip";
                    } else if ("msp".equals(command)) {
                        reg = 4;
                        name = "sp";
                    } else if (command.startsWith("m0x")) {
                        long addr;
                        UnidbgPointer pointer;
                        String hex = command.substring(3).trim();
                        if (hex.endsWith("L")) {
                            hex = hex.substring(0, hex.length() - 1);
                        }
                        if ((pointer = UnidbgPointer.pointer(emulator, addr = Long.parseLong(hex, 16))) != null) {
                            this.dumpMemory(pointer, length, pointer.toString(), stringType);
                            continue;
                        }
                        System.out.println(addr + " is null");
                        continue;
                    }
                    if (reg != -1) {
                        UnidbgPointer pointer = UnidbgPointer.register(emulator, reg);
                        if (pointer != null) {
                            this.dumpMemory(pointer, length, name + "=" + pointer, stringType);
                            continue;
                        }
                        System.out.println(name + " is null");
                        continue;
                    }
                }
                if ("where".equals(line)) {
                    new Exception("here").printStackTrace(System.out);
                    continue;
                }
                if (line.startsWith("wx0x")) {
                    long addr;
                    UnidbgPointer pointer;
                    String[] tokens2 = line.split("\\s+");
                    String hex = tokens2[0].substring(4).trim();
                    if (hex.endsWith("L")) {
                        hex = hex.substring(0, hex.length() - 1);
                    }
                    if ((pointer = UnidbgPointer.pointer(emulator, addr = Long.parseLong(hex, 16))) != null && tokens2.length > 1) {
                        byte[] data = Hex.decodeHex((char[])tokens2[1].toCharArray());
                        pointer.write(0L, data, 0, data.length);
                        this.dumpMemory(pointer, data.length, pointer.toString(), null);
                        continue;
                    }
                    System.out.println(addr + " is null");
                    continue;
                }
                if (line.startsWith("w")) {
                    long value;
                    String command;
                    tokens = line.split("\\s+");
                    if (tokens.length < 2) {
                        System.out.println("wx0-wx28, wfp, wip, wsp <value>: write specified register");
                        System.out.println("wb(address), ws(address), wi(address), wl(address) <value>: write (byte, short, integer, long) memory of specified address, address must start with 0x");
                        continue;
                    }
                    try {
                        command = tokens[0];
                        String str = tokens[1];
                        value = Utils.parseNumber(str);
                    }
                    catch (NumberFormatException e) {
                        e.printStackTrace(System.err);
                        continue;
                    }
                    int reg = -1;
                    if (command.startsWith("wx") && (command.length() == 3 || command.length() == 4)) {
                        int idx = Integer.parseInt(command.substring(2));
                        if (idx >= 0 && idx <= 28) {
                            reg = 199 + idx;
                        }
                    } else if ("wfp".equals(command)) {
                        reg = 1;
                    } else if ("wip".equals(command)) {
                        reg = 215;
                    } else if ("wsp".equals(command)) {
                        reg = 4;
                    } else if (command.startsWith("wb0x") || command.startsWith("ws0x") || command.startsWith("wi0x") || command.startsWith("wl0x")) {
                        long addr;
                        UnidbgPointer pointer;
                        String hex = command.substring(4).trim();
                        if (hex.endsWith("L")) {
                            hex = hex.substring(0, hex.length() - 1);
                        }
                        if ((pointer = UnidbgPointer.pointer(emulator, addr = Long.parseLong(hex, 16))) != null) {
                            if (command.startsWith("wb")) {
                                pointer.setByte(0L, (byte)value);
                            } else if (command.startsWith("ws")) {
                                pointer.setShort(0L, (short)value);
                            } else if (command.startsWith("wi")) {
                                pointer.setInt(0L, (int)value);
                            } else if (command.startsWith("wl")) {
                                pointer.setLong(0L, value);
                            }
                            this.dumpMemory(pointer, 16, pointer.toString(), null);
                            continue;
                        }
                        System.out.println(addr + " is null");
                        continue;
                    }
                    if (reg != -1) {
                        backend.reg_write(reg, value);
                        ARM.showRegs64(emulator, new int[]{reg});
                        continue;
                    }
                }
                if (emulator.isRunning() && "bt".equals(line)) {
                    try {
                        emulator.getUnwinder().unwind();
                    }
                    catch (Throwable e) {
                        e.printStackTrace(System.err);
                    }
                    continue;
                }
                if (line.startsWith("b0x")) {
                    try {
                        if (line.endsWith("L")) {
                            line = line.substring(0, line.length() - 1);
                        }
                        long addr = Long.parseLong(line.substring(3), 16) & 0xFFFFFFFFFFFFFFFEL;
                        Module module = null;
                        if (addr < 0x40000000L && (module = SimpleARM64Debugger.findModuleByAddress(emulator, address)) != null) {
                            addr += module.base;
                        }
                        this.addBreakPoint(addr);
                        if (module == null) {
                            module = SimpleARM64Debugger.findModuleByAddress(emulator, addr);
                        }
                        System.out.println("Add breakpoint: 0x" + Long.toHexString(addr) + (module == null ? "" : " in " + module.name + " [0x" + Long.toHexString(addr - module.base) + "]"));
                        continue;
                    }
                    catch (NumberFormatException addr) {
                        // empty catch block
                    }
                }
                if ("blr".equals(line)) {
                    long addr = backend.reg_read(2).longValue();
                    this.addBreakPoint(addr);
                    Module module = SimpleARM64Debugger.findModuleByAddress(emulator, addr);
                    System.out.println("Add breakpoint: 0x" + Long.toHexString(addr) + (module == null ? "" : " in " + module.name + " [0x" + Long.toHexString(addr - module.base) + "]"));
                    continue;
                }
                if ("r".equals(line)) {
                    long addr = backend.reg_read(260).longValue();
                    if (!this.removeBreakPoint(addr)) continue;
                    Module module = SimpleARM64Debugger.findModuleByAddress(emulator, addr);
                    System.out.println("Remove breakpoint: 0x" + Long.toHexString(addr) + (module == null ? "" : " in " + module.name + " [0x" + Long.toHexString(addr - module.base) + "]"));
                    continue;
                }
                if ("b".equals(line)) {
                    long addr = backend.reg_read(260).longValue();
                    this.addBreakPoint(addr);
                    Module module = SimpleARM64Debugger.findModuleByAddress(emulator, addr);
                    System.out.println("Add breakpoint: 0x" + Long.toHexString(addr) + (module == null ? "" : " in " + module.name + " [0x" + Long.toHexString(addr - module.base) + "]"));
                    continue;
                }
                if (!this.handleCommon(backend, line, address, size, nextAddress, runnable)) continue;
                break;
            }
            catch (RuntimeException | DecoderException e) {
                e.printStackTrace(System.err);
            }
        }
    }

    @Override
    final void showHelp(long address) {
        Module module;
        System.out.println("c: continue");
        System.out.println("n: step over");
        if (this.emulator.isRunning()) {
            System.out.println("bt: back trace");
        }
        System.out.println();
        System.out.println("st hex: search stack");
        System.out.println("shw hex: search writable heap");
        System.out.println("shr hex: search readable heap");
        System.out.println("shx hex: search executable heap");
        System.out.println();
        System.out.println("nb: break at next block");
        System.out.println("s|si: step into");
        System.out.println("s[decimal]: execute specified amount instruction");
        System.out.println("s(bl): execute util BL mnemonic, low performance");
        System.out.println();
        System.out.println("m(op) [size]: show memory, default size is 0x70, size may hex or decimal");
        System.out.println("mx0-mx28, mfp, mip, msp [size]: show memory of specified register");
        System.out.println("m(address) [size]: show memory of specified address, address must start with 0x");
        System.out.println();
        System.out.println("wx0-wx28, wfp, wip, wsp <value>: write specified register");
        System.out.println("wb(address), ws(address), wi(address), wl(address) <value>: write (byte, short, integer, long) memory of specified address, address must start with 0x");
        System.out.println("wx(address) <hex>: write bytes to memory at specified address, address must start with 0x");
        System.out.println();
        System.out.println("b(address): add temporarily breakpoint, address must start with 0x, can be module offset");
        System.out.println("b: add breakpoint of register PC");
        System.out.println("r: remove breakpoint of register PC");
        System.out.println("blr: add temporarily breakpoint of register LR");
        System.out.println();
        System.out.println("p (assembly): patch assembly at PC address");
        System.out.println("where: show java stack trace");
        System.out.println();
        System.out.println("trace [begin end]: Set trace instructions");
        System.out.println("traceRead [begin end]: Set trace memory read");
        System.out.println("traceWrite [begin end]: Set trace memory write");
        System.out.println("vm: view loaded modules");
        System.out.println("vbs: view breakpoints");
        System.out.println("d|dis: show disassemble");
        System.out.println("d(0x): show disassemble at specify address");
        System.out.println("stop: stop emulation");
        System.out.println("run [arg]: run test");
        System.out.println("gc: Run System.gc()");
        System.out.println("threads: show thread list");
        if (this.emulator.getFamily() == Family.iOS && !this.emulator.isRunning()) {
            System.out.println("dump [class name]: dump objc class");
            System.out.println("search [keywords]: search objc classes");
            System.out.println("gpb [class name]: dump GPB protobuf msg def");
        }
        if ((module = this.emulator.getMemory().findModuleByAddress(address)) != null) {
            System.out.printf("cc (size): convert asm from (0x%x) to (0x%x + size) bytes to c function%n", address, address);
        }
    }

    @Override
    protected Keystone createKeystone(boolean isThumb) {
        return new Keystone(KeystoneArchitecture.Arm64, KeystoneMode.LittleEndian);
    }
}

