/*
 * Decompiled with CFR 0.152.
 */
package com.github.unidbg.arm.backend;

import com.github.unidbg.Emulator;
import com.github.unidbg.arm.backend.AbstractBackend;
import com.github.unidbg.debugger.BreakPoint;
import com.github.unidbg.debugger.BreakPointCallback;
import com.github.unidbg.pointer.UnidbgPointer;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

abstract class FastBackend
extends AbstractBackend {
    protected final Emulator<?> emulator;
    private int svcNumber = 1;
    private final Map<Integer, SoftBreakPoint> softBreakpointMap = new HashMap<Integer, SoftBreakPoint>();

    public FastBackend(Emulator<?> emulator) {
        this.emulator = emulator;
    }

    @Override
    public BreakPoint addBreakPoint(long address, BreakPointCallback callback, boolean thumb) {
        int svcNumber = ++this.svcNumber;
        byte[] code = this.addSoftBreakPoint(address, svcNumber, thumb);
        UnidbgPointer pointer = UnidbgPointer.pointer(this.emulator, address);
        assert (pointer != null);
        byte[] backup = pointer.getByteArray(0L, code.length);
        pointer.write(0L, code, 0, code.length);
        SoftBreakPoint breakPoint = new SoftBreakPoint(address, backup, callback, thumb);
        this.softBreakpointMap.put(svcNumber, breakPoint);
        return breakPoint;
    }

    protected abstract byte[] addSoftBreakPoint(long var1, int var3, boolean var4);

    @Override
    public boolean removeBreakPoint(long address) {
        address &= 0xFFFFFFFFFFFFFFFEL;
        Iterator<Map.Entry<Integer, SoftBreakPoint>> iterator = this.softBreakpointMap.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<Integer, SoftBreakPoint> entry = iterator.next();
            SoftBreakPoint breakPoint = entry.getValue();
            if (address != breakPoint.address) continue;
            UnidbgPointer pointer = UnidbgPointer.pointer(this.emulator, address);
            assert (pointer != null);
            pointer.write(0L, breakPoint.backup, 0, breakPoint.backup.length);
            iterator.remove();
            return true;
        }
        return false;
    }

    @Override
    public void setSingleStep(int singleStep) {
    }

    @Override
    public final void setFastDebug(boolean fastDebug) {
    }

    private static class SoftBreakPoint
    implements BreakPoint {
        final long address;
        final byte[] backup;
        final BreakPointCallback callback;
        final boolean thumb;

        SoftBreakPoint(long address, byte[] backup, BreakPointCallback callback, boolean thumb) {
            this.address = address;
            this.backup = backup;
            this.callback = callback;
            this.thumb = thumb;
        }

        @Override
        public void setTemporary(boolean temporary) {
        }

        @Override
        public boolean isTemporary() {
            return true;
        }

        @Override
        public BreakPointCallback getCallback() {
            return this.callback;
        }

        @Override
        public boolean isThumb() {
            return this.thumb;
        }
    }
}

