/*
 * Decompiled with CFR 0.152.
 */
package com.github.unidbg.arm.context;

import com.github.unidbg.Emulator;
import com.github.unidbg.arm.backend.Backend;
import com.github.unidbg.arm.context.AbstractRegisterContext;
import com.github.unidbg.arm.context.RegisterContext;
import com.github.unidbg.pointer.UnidbgPointer;

public abstract class BaseRegisterContext
extends AbstractRegisterContext
implements RegisterContext {
    protected final Emulator<?> emulator;
    private final int firstArgReg;
    private final int regArgCount;

    BaseRegisterContext(Emulator<?> emulator, int firstArgReg, int regArgCount) {
        this.emulator = emulator;
        this.firstArgReg = firstArgReg;
        this.regArgCount = regArgCount;
    }

    @Override
    public UnidbgPointer getPointerArg(int index) {
        if (index < this.regArgCount) {
            int reg = this.firstArgReg + index;
            return UnidbgPointer.register(this.emulator, reg);
        }
        UnidbgPointer sp = this.getStackPointer();
        return sp.getPointer((long)(index - this.regArgCount) * (long)this.emulator.getPointerSize());
    }

    @Override
    public int getIntByReg(int regId) {
        Backend backend = this.emulator.getBackend();
        Number number = backend.reg_read(regId);
        return number.intValue();
    }

    @Override
    public long getLongByReg(int regId) {
        Backend backend = this.emulator.getBackend();
        Number number = backend.reg_read(regId);
        return number.longValue();
    }
}

