/*
 * Decompiled with CFR 0.152.
 */
package com.github.unidbg.debugger.gdb;

import com.github.unidbg.Emulator;
import com.github.unidbg.debugger.gdb.GdbStub;
import com.github.unidbg.debugger.gdb.GdbStubCommand;

class BreakpointCommand
implements GdbStubCommand {
    BreakpointCommand() {
    }

    @Override
    public boolean processCommand(Emulator<?> emulator, GdbStub stub, String command) {
        boolean isThumb;
        int divider = command.substring(3).indexOf(",");
        long address = Long.parseLong(command.substring(3, divider + 3), 16);
        int type = Integer.parseInt(command.substring(divider + 4));
        boolean bl = isThumb = type == 2 || type == 3;
        if (isThumb) {
            address |= 1L;
        }
        if (command.startsWith("Z0")) {
            stub.addBreakPoint(address);
        } else {
            stub.removeBreakPoint(address);
        }
        stub.makePacketAndSend("OK");
        return true;
    }
}

