/*
 * Decompiled with CFR 0.152.
 */
package com.github.unidbg.debugger.ida;

import java.io.ByteArrayOutputStream;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;

public class Utils {
    public static String readCString(ByteBuffer buffer) {
        int read;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        while ((read = buffer.get() & 0xFF) != 0) {
            baos.write(read);
        }
        return baos.toString();
    }

    public static void writeCString(ByteBuffer buffer, String str) {
        byte[] data = str.getBytes(StandardCharsets.UTF_8);
        buffer.put(Arrays.copyOf(data, data.length + 1));
    }

    public static long unpack_dd(ByteBuffer buffer) {
        byte b = buffer.get();
        if ((b & 0xFF) == 255) {
            return (long)buffer.getInt() & 0xFFFFFFFFL;
        }
        if ((b & 0xC0) == 192) {
            int b0 = b & 0x3F;
            int b1 = buffer.get() & 0xFF;
            int b2 = buffer.get() & 0xFF;
            int b3 = buffer.get() & 0xFF;
            return (long)(b0 << 24 | b1 << 16 | b2 << 8 | b3) & 0xFFFFFFFFL;
        }
        if ((b & 0x80) == 128) {
            int b0 = b & 0x7F;
            int b1 = buffer.get() & 0xFF;
            return b0 << 8 | b1;
        }
        return b & 0xFF;
    }

    public static long unpack_dq(ByteBuffer buffer) {
        long low = Utils.unpack_dd(buffer);
        long high = Utils.unpack_dd(buffer);
        return high << 32 | low;
    }

    public static byte[] pack_dq(long value) {
        byte[] d1 = Utils.pack_dd(value);
        byte[] d2 = Utils.pack_dd(value >> 32);
        byte[] data = new byte[d1.length + d2.length];
        System.arraycopy(d1, 0, data, 0, d1.length);
        System.arraycopy(d2, 0, data, d1.length, d2.length);
        return data;
    }

    public static byte[] pack_dd(long value) {
        ByteBuffer buffer = ByteBuffer.allocate(16);
        if ((value &= 0xFFFFFFFFL) <= 127L) {
            buffer.put((byte)value);
            return Utils.flipBuffer(buffer);
        }
        if (value >> 14 == 0L) {
            buffer.put((byte)(value >> 8 | 0x80L));
            buffer.put((byte)value);
            return Utils.flipBuffer(buffer);
        }
        if (value >> 29 == 0L) {
            buffer.putInt((int)(value | 0xFFFFFFFFC0000000L));
        } else {
            buffer.put((byte)-1);
            buffer.putInt((int)value);
        }
        return Utils.flipBuffer(buffer);
    }

    public static byte[] flipBuffer(ByteBuffer buffer) {
        buffer.flip();
        byte[] data = new byte[buffer.remaining()];
        buffer.get(data);
        return data;
    }
}

